/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.db.ConnectionPool;
import play.api.db.ConnectionPool$;
import play.api.db.DatabaseConfig;
import play.api.db.HikariCPConfig;
import play.api.libs.JNDI$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Singleton
@ScalaSignature(bytes="\u0006\u000514A\u0001D\u0007\u0001)!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u00042\u0001\t\u0007I\u0011\u0002\u001a\t\rY\u0002\u0001\u0015!\u00034\u0011\u00159\u0004\u0001\"\u00119\u0011\u0015i\u0006\u0001\"\u0011_\u000f\u0015AW\u0002#\u0001j\r\u0015aQ\u0002#\u0001k\u0011\u0015!\u0003\u0002\"\u0001l\u0011\u001d\t\u0004B1A\u0005\nIBaA\u000e\u0005!\u0002\u0013\u0019$A\u0006%jW\u0006\u0014\u0018n\u0011)D_:tWm\u0019;j_:\u0004vn\u001c7\u000b\u00059y\u0011A\u00013c\u0015\t\u0001\u0012#A\u0002ba&T\u0011AE\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039ui\u0011!D\u0005\u0003=5\u0011abQ8o]\u0016\u001cG/[8o!>|G.A\u0006f]ZL'o\u001c8nK:$\bCA\u0011#\u001b\u0005y\u0011BA\u0012\u0010\u0005-)eN^5s_:lWM\u001c;\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002\u001d\u0001!)qD\u0001a\u0001A!\u0012!!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\na!\u001b8kK\u000e$(\"\u0001\u0018\u0002\u000b)\fg/\u0019=\n\u0005AZ#AB%oU\u0016\u001cG/\u0001\u0004m_\u001e<WM]\u000b\u0002gA\u0011\u0011\u0005N\u0005\u0003k=\u0011a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0007GJ,\u0017\r^3\u0015\tezD*\u0015\t\u0003uuj\u0011a\u000f\u0006\u0003y5\n1a]9m\u0013\tq4H\u0001\u0006ECR\f7k\\;sG\u0016DQ\u0001Q\u0003A\u0002\u0005\u000bAA\\1nKB\u0011!)\u0013\b\u0003\u0007\u001e\u0003\"\u0001R\f\u000e\u0003\u0015S!AR\n\u0002\rq\u0012xn\u001c;?\u0013\tAu#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%\u0018\u0011\u0015iU\u00011\u0001O\u0003!!'mQ8oM&<\u0007C\u0001\u000fP\u0013\t\u0001VB\u0001\bECR\f'-Y:f\u0007>tg-[4\t\u000bI+\u0001\u0019A*\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t!6,D\u0001V\u0015\t1v+\u0001\u0004d_:4\u0017n\u001a\u0006\u00031f\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u00025\u0006\u00191m\\7\n\u0005q+&AB\"p]\u001aLw-A\u0003dY>\u001cX\r\u0006\u0002`EB\u0011a\u0003Y\u0005\u0003C^\u0011A!\u00168ji\")1M\u0002a\u0001s\u0005QA-\u0019;b'>,(oY3)\u0005\u0001)\u0007C\u0001\u0016g\u0013\t97FA\u0005TS:<G.\u001a;p]\u00061\u0002*[6be&\u001c\u0005kQ8o]\u0016\u001cG/[8o!>|G\u000e\u0005\u0002\u001d\u0011M\u0011\u0001\"\u0006\u000b\u0002S\u0002")
public class HikariCPConnectionPool
implements ConnectionPool {
    private final Logger logger = Logger$.MODULE$.apply(this.getClass());

    private Logger logger() {
        return this.logger;
    }

    @Override
    public DataSource create(String name, DatabaseConfig dbConfig, Config configuration) {
        Configuration config = new Configuration(configuration);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.logger().info((Function0 & Serializable)() -> "Creating Pool for datasource '" + name + "'", MarkerContext$.MODULE$.NoMarker());
            HikariConfig hikariConfig = new HikariCPConfig(name, dbConfig, config).toHikariConfig();
            HikariDataSource datasource = new HikariDataSource(hikariConfig);
            DataSource wrappedDataSource = ConnectionPool$.MODULE$.wrapToLogSql((DataSource)datasource, configuration);
            dbConfig.jndiName().foreach((Function1 & Serializable)jndiName -> {
                HikariCPConnectionPool.$anonfun$create$3(this, wrappedDataSource, name, jndiName);
                return BoxedUnit.UNIT;
            });
            return wrappedDataSource;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DataSource datasource = (DataSource)success.value();
            return datasource;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            throw config.reportError(name, ex.getMessage(), (Option)new Some((Object)ex));
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public void close(DataSource dataSource) {
        this.logger().info((Function0 & Serializable)() -> "Shutting down connection pool.", MarkerContext$.MODULE$.NoMarker());
        DataSource dataSource2 = ConnectionPool$.MODULE$.unwrap(dataSource);
        if (dataSource2 instanceof HikariDataSource) {
            HikariDataSource hikariDataSource = (HikariDataSource)dataSource2;
            hikariDataSource.close();
            return;
        }
        throw package$.MODULE$.error("Unable to close data source: not a HikariDataSource");
    }

    public static final /* synthetic */ void $anonfun$create$3(HikariCPConnectionPool $this, DataSource wrappedDataSource$1, String name$1, String jndiName) {
        JNDI$.MODULE$.initialContext().rebind(jndiName, (Object)wrappedDataSource$1);
        $this.logger().info((Function0 & Serializable)() -> "datasource [" + name$1 + "] bound to JNDI as " + jndiName, MarkerContext$.MODULE$.NoMarker());
    }

    @Inject
    public HikariCPConnectionPool(Environment environment) {
    }
}

