/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.db.Database;
import play.api.db.evolutions.ApplicationEvolutions;
import play.api.db.evolutions.DatabaseUrlPatterns$;
import play.api.db.evolutions.DownScript;
import play.api.db.evolutions.EvolutionsApi;
import play.api.db.evolutions.EvolutionsConfig;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import play.api.db.evolutions.EvolutionsHelper$;
import play.api.db.evolutions.EvolutionsReader;
import play.api.db.evolutions.Script;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.Tuple3$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.Exception$;

public final class ApplicationEvolutions$
implements Serializable {
    private static final Logger logger;
    private static final String SelectPlayEvolutionsLockSql;
    private static final String SelectPlayEvolutionsLockMysqlSql;
    private static final String SelectPlayEvolutionsLockOracleSql;
    private static final String CreatePlayEvolutionsLockSql;
    private static final String CreatePlayEvolutionsLockMysqlSql;
    private static final String CreatePlayEvolutionsLockOracleSql;
    private static final String InsertIntoPlayEvolutionsLockSql;
    private static final String InsertIntoPlayEvolutionsLockMysqlSql;
    private static final String InsertIntoPlayEvolutionsLockOracleSql;
    private static final List lockPlayEvolutionsLockSqls;
    private static final List lockPlayEvolutionsLockMysqlSqls;
    private static final List lockPlayEvolutionsLockOracleSqls;
    public static final ApplicationEvolutions$ MODULE$;

    private ApplicationEvolutions$() {
    }

    static {
        MODULE$ = new ApplicationEvolutions$();
        logger = Logger$.MODULE$.apply(ApplicationEvolutions.class);
        SelectPlayEvolutionsLockSql = "\n      select lock from ${schema}${evolutions_table}_lock\n    ";
        SelectPlayEvolutionsLockMysqlSql = "\n      select `lock` from ${schema}${evolutions_table}_lock\n    ";
        SelectPlayEvolutionsLockOracleSql = "\n      select \"lock\" from ${schema}${evolutions_table}_lock\n    ";
        CreatePlayEvolutionsLockSql = "\n      create table ${schema}${evolutions_table}_lock (\n        lock int not null primary key\n      )\n    ";
        CreatePlayEvolutionsLockMysqlSql = "\n      create table ${schema}${evolutions_table}_lock (\n        `lock` int not null primary key\n      )\n    ";
        CreatePlayEvolutionsLockOracleSql = "\n      CREATE TABLE ${schema}${evolutions_table}_lock (\n        \"lock\" Number(10,0) Not Null Enable,\n        CONSTRAINT ${evolutions_table}_lock_pk PRIMARY KEY (\"lock\")\n      )\n    ";
        InsertIntoPlayEvolutionsLockSql = "\n      insert into ${schema}${evolutions_table}_lock (lock) values (1)\n    ";
        InsertIntoPlayEvolutionsLockMysqlSql = "\n      insert into ${schema}${evolutions_table}_lock (`lock`) values (1)\n    ";
        InsertIntoPlayEvolutionsLockOracleSql = "\n      insert into ${schema}${evolutions_table}_lock (\"lock\") values (1)\n    ";
        lockPlayEvolutionsLockSqls = (List)new .colon.colon((Object)"\n        select lock from ${schema}${evolutions_table}_lock where lock = 1 for update nowait\n      ", (List)Nil$.MODULE$);
        lockPlayEvolutionsLockMysqlSqls = (List)new .colon.colon((Object)"\n        set innodb_lock_wait_timeout = 1\n      ", (List)new .colon.colon((Object)"\n        select `lock` from ${schema}${evolutions_table}_lock where `lock` = 1 for update\n      ", (List)Nil$.MODULE$));
        lockPlayEvolutionsLockOracleSqls = (List)new .colon.colon((Object)"\n        select \"lock\" from ${schema}${evolutions_table}_lock where \"lock\" = 1 for update nowait\n      ", (List)Nil$.MODULE$);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ApplicationEvolutions$.class);
    }

    public String SelectPlayEvolutionsLockSql() {
        return SelectPlayEvolutionsLockSql;
    }

    public String SelectPlayEvolutionsLockMysqlSql() {
        return SelectPlayEvolutionsLockMysqlSql;
    }

    public String SelectPlayEvolutionsLockOracleSql() {
        return SelectPlayEvolutionsLockOracleSql;
    }

    public String CreatePlayEvolutionsLockSql() {
        return CreatePlayEvolutionsLockSql;
    }

    public String CreatePlayEvolutionsLockMysqlSql() {
        return CreatePlayEvolutionsLockMysqlSql;
    }

    public String CreatePlayEvolutionsLockOracleSql() {
        return CreatePlayEvolutionsLockOracleSql;
    }

    public String InsertIntoPlayEvolutionsLockSql() {
        return InsertIntoPlayEvolutionsLockSql;
    }

    public String InsertIntoPlayEvolutionsLockMysqlSql() {
        return InsertIntoPlayEvolutionsLockMysqlSql;
    }

    public String InsertIntoPlayEvolutionsLockOracleSql() {
        return InsertIntoPlayEvolutionsLockOracleSql;
    }

    public List<String> lockPlayEvolutionsLockSqls() {
        return lockPlayEvolutionsLockSqls;
    }

    public List<String> lockPlayEvolutionsLockMysqlSqls() {
        return lockPlayEvolutionsLockMysqlSqls;
    }

    public List<String> lockPlayEvolutionsLockOracleSqls() {
        return lockPlayEvolutionsLockOracleSqls;
    }

    public void runEvolutions(Database database, EvolutionsConfig config, EvolutionsApi evolutions, EvolutionsReader reader, Function4<String, EvolutionsDatasourceConfig, Seq<Script>, Object, BoxedUnit> block) {
        String db = database.name();
        EvolutionsDatasourceConfig dbConfig = config.forDatasource(db);
        if (dbConfig.enabled()) {
            this.withLock(database, dbConfig, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                ApplicationEvolutions$.runEvolutions$$anonfun$1(evolutions, db, reader, dbConfig, block);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void withLock(Database db, EvolutionsDatasourceConfig dbConfig, Function0<BoxedUnit> block) {
        if (dbConfig.useLocks()) {
            DataSource ds = db.dataSource();
            String url = db.url();
            Connection c = ds.getConnection();
            c.setAutoCommit(false);
            Statement s = c.createStatement();
            this.createLockTableIfNecessary(url, c, s, dbConfig);
            this.lock(url, c, s, dbConfig, this.lock$default$5());
            try {
                block.apply$mcV$sp();
            }
            finally {
                this.unlock(c, s);
            }
            return;
        }
        block.apply$mcV$sp();
    }

    /*
     * Unable to fully structure code
     */
    private void createLockTableIfNecessary(String url, Connection c, Statement s, EvolutionsDatasourceConfig dbConfig) {
        var6_5 = url;
        if (var6_5 == null) ** GOTO lbl-1000
        var7_6 = DatabaseUrlPatterns$.MODULE$.OracleJdbcUrl().unapplySeq((CharSequence)var6_5);
        if (!var7_6.isEmpty() && (var8_7 = (List)var7_6.get()).lengthCompare(0) == 0) {
            v0 = Tuple3$.MODULE$.apply((Object)this.SelectPlayEvolutionsLockOracleSql(), (Object)this.CreatePlayEvolutionsLockOracleSql(), (Object)this.InsertIntoPlayEvolutionsLockOracleSql());
        } else {
            var9_8 = DatabaseUrlPatterns$.MODULE$.MysqlJdbcUrl().unapplySeq((CharSequence)var6_5);
            if (!var9_8.isEmpty() && (var10_9 = (List)var9_8.get()).lengthCompare(2) == 0) {
                var11_10 = (String)var10_9.apply(0);
                var12_11 = (String)var10_9.apply(1);
                v0 = Tuple3$.MODULE$.apply((Object)this.SelectPlayEvolutionsLockMysqlSql(), (Object)this.CreatePlayEvolutionsLockMysqlSql(), (Object)this.InsertIntoPlayEvolutionsLockMysqlSql());
            } else lbl-1000:
            // 2 sources

            {
                v0 = Tuple3$.MODULE$.apply((Object)this.SelectPlayEvolutionsLockSql(), (Object)this.CreatePlayEvolutionsLockSql(), (Object)this.InsertIntoPlayEvolutionsLockSql());
            }
        }
        var5_12 = v0;
        selectScript = (String)var5_12._1();
        createScript = (String)var5_12._2();
        insertScript = (String)var5_12._3();
        try {
            r = s.executeQuery(EvolutionsHelper$.MODULE$.applyConfig(selectScript, dbConfig));
            r.close();
        }
        catch (SQLException e) {
            c.rollback();
            s.execute(EvolutionsHelper$.MODULE$.applyConfig(createScript, dbConfig));
            s.executeUpdate(EvolutionsHelper$.MODULE$.applyConfig(insertScript, dbConfig));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void lock(String url, Connection c, Statement s, EvolutionsDatasourceConfig dbConfig, int attempts) {
        while (true) {
            if ((var7_7 = url) == null) ** GOTO lbl-1000
            var8_8 = DatabaseUrlPatterns$.MODULE$.MysqlJdbcUrl().unapplySeq((CharSequence)var7_7);
            if (!var8_8.isEmpty() && (var9_9 = (List)var8_8.get()).lengthCompare(2) == 0) {
                var10_10 = (String)var9_9.apply(0);
                var11_11 = (String)var9_9.apply(1);
                v0 = this.lockPlayEvolutionsLockMysqlSqls();
            } else {
                var12_12 = DatabaseUrlPatterns$.MODULE$.OracleJdbcUrl().unapplySeq((CharSequence)var7_7);
                if (!var12_12.isEmpty() && (var13_13 = (List)var12_12.get()).lengthCompare(0) == 0) {
                    v0 = this.lockPlayEvolutionsLockOracleSqls();
                } else lbl-1000:
                // 2 sources

                {
                    v0 = this.lockPlayEvolutionsLockSqls();
                }
            }
            lockScripts = v0;
            try {
                lockScripts.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lock$$anonfun$1(java.sql.Statement play.api.db.evolutions.EvolutionsDatasourceConfig java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)((Statement)s, (EvolutionsDatasourceConfig)dbConfig));
            }
            catch (SQLException e) {
                if (attempts == 0) {
                    throw e;
                }
                ApplicationEvolutions$.logger.warn((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, lock$$anonfun$2(), ()Ljava/lang/String;)(), MarkerContext$.MODULE$.NoMarker());
                c.rollback();
                Thread.sleep(1000L);
                --attempts;
                continue;
            }
            break;
        }
    }

    private int lock$default$5() {
        return 5;
    }

    private void unlock(Connection c, Statement s) {
        Exception$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{SQLException.class})).apply((Function0 & Serializable)() -> {
            ApplicationEvolutions$.unlock$$anonfun$1(s);
            return BoxedUnit.UNIT;
        });
        Exception$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{SQLException.class})).apply((Function0 & Serializable)() -> {
            ApplicationEvolutions$.unlock$$anonfun$2(c);
            return BoxedUnit.UNIT;
        });
        Exception$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{SQLException.class})).apply((Function0 & Serializable)() -> {
            ApplicationEvolutions$.unlock$$anonfun$3(c);
            return BoxedUnit.UNIT;
        });
    }

    private static final void runEvolutions$$anonfun$1(EvolutionsApi evolutions$1, String db$6, EvolutionsReader reader$1, EvolutionsDatasourceConfig dbConfig$1, Function4 block$1) {
        Seq<Script> scripts = evolutions$1.scripts(db$6, reader$1, dbConfig$1.schema(), dbConfig$1.metaTable());
        boolean hasDown = scripts.exists((Function1 & Serializable)_$2 -> _$2 instanceof DownScript);
        boolean onlyDowns = scripts.forall((Function1 & Serializable)_$3 -> _$3 instanceof DownScript);
        if (!(!scripts.nonEmpty() || onlyDowns && dbConfig$1.skipApplyDownsOnly())) {
            block$1.apply((Object)db$6, (Object)dbConfig$1, scripts, (Object)BoxesRunTime.boxToBoolean((boolean)hasDown));
            return;
        }
    }

    private static final /* synthetic */ boolean lock$$anonfun$1(Statement s$1, EvolutionsDatasourceConfig dbConfig$2, String script) {
        return s$1.execute(EvolutionsHelper$.MODULE$.applyConfig(script, dbConfig$2));
    }

    private static final String lock$$anonfun$2() {
        return "Exception while attempting to lock evolutions (other node probably has lock), sleeping for 1 sec";
    }

    private static final void unlock$$anonfun$1(Statement s$2) {
        s$2.close();
    }

    private static final void unlock$$anonfun$2(Connection c$1) {
        c$1.commit();
    }

    private static final void unlock$$anonfun$3(Connection c$2) {
        c$2.close();
    }
}

