/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.db.DBApi;
import play.api.db.Database;
import play.api.db.evolutions.ApplicationEvolutions$;
import play.api.db.evolutions.DynamicEvolutions;
import play.api.db.evolutions.Evolutions$;
import play.api.db.evolutions.EvolutionsApi;
import play.api.db.evolutions.EvolutionsConfig;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import play.api.db.evolutions.EvolutionsReader;
import play.api.db.evolutions.EvolutionsWebCommands;
import play.api.db.evolutions.InvalidDatabaseRevision$;
import play.api.db.evolutions.Script;
import play.core.HandleWebCommandSupport;
import play.core.WebCommands;
import scala.Function1;
import scala.Function4;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;

@Singleton
public class ApplicationEvolutions {
    private final EvolutionsConfig config;
    private final EvolutionsReader reader;
    private final EvolutionsApi evolutions;
    private final DynamicEvolutions dynamicEvolutions;
    private final DBApi dbApi;
    private final Environment environment;
    private final WebCommands webCommands;
    private final Logger logger;
    private int invalidDatabaseRevisions;

    public static String CreatePlayEvolutionsLockMysqlSql() {
        return ApplicationEvolutions$.MODULE$.CreatePlayEvolutionsLockMysqlSql();
    }

    public static String CreatePlayEvolutionsLockOracleSql() {
        return ApplicationEvolutions$.MODULE$.CreatePlayEvolutionsLockOracleSql();
    }

    public static String CreatePlayEvolutionsLockSql() {
        return ApplicationEvolutions$.MODULE$.CreatePlayEvolutionsLockSql();
    }

    public static String InsertIntoPlayEvolutionsLockMysqlSql() {
        return ApplicationEvolutions$.MODULE$.InsertIntoPlayEvolutionsLockMysqlSql();
    }

    public static String InsertIntoPlayEvolutionsLockOracleSql() {
        return ApplicationEvolutions$.MODULE$.InsertIntoPlayEvolutionsLockOracleSql();
    }

    public static String InsertIntoPlayEvolutionsLockSql() {
        return ApplicationEvolutions$.MODULE$.InsertIntoPlayEvolutionsLockSql();
    }

    public static String SelectPlayEvolutionsLockMysqlSql() {
        return ApplicationEvolutions$.MODULE$.SelectPlayEvolutionsLockMysqlSql();
    }

    public static String SelectPlayEvolutionsLockOracleSql() {
        return ApplicationEvolutions$.MODULE$.SelectPlayEvolutionsLockOracleSql();
    }

    public static String SelectPlayEvolutionsLockSql() {
        return ApplicationEvolutions$.MODULE$.SelectPlayEvolutionsLockSql();
    }

    public static List<String> lockPlayEvolutionsLockMysqlSqls() {
        return ApplicationEvolutions$.MODULE$.lockPlayEvolutionsLockMysqlSqls();
    }

    public static List<String> lockPlayEvolutionsLockOracleSqls() {
        return ApplicationEvolutions$.MODULE$.lockPlayEvolutionsLockOracleSqls();
    }

    public static List<String> lockPlayEvolutionsLockSqls() {
        return ApplicationEvolutions$.MODULE$.lockPlayEvolutionsLockSqls();
    }

    public static void runEvolutions(Database database, EvolutionsConfig evolutionsConfig, EvolutionsApi evolutionsApi, EvolutionsReader evolutionsReader, Function4<String, EvolutionsDatasourceConfig, Seq<Script>, Object, BoxedUnit> function4) {
        ApplicationEvolutions$.MODULE$.runEvolutions(database, evolutionsConfig, evolutionsApi, evolutionsReader, function4);
    }

    @Inject
    public ApplicationEvolutions(EvolutionsConfig config, EvolutionsReader reader, EvolutionsApi evolutions, DynamicEvolutions dynamicEvolutions, DBApi dbApi, Environment environment, WebCommands webCommands) {
        this.config = config;
        this.reader = reader;
        this.evolutions = evolutions;
        this.dynamicEvolutions = dynamicEvolutions;
        this.dbApi = dbApi;
        this.environment = environment;
        this.webCommands = webCommands;
        this.logger = Logger$.MODULE$.apply(ApplicationEvolutions.class);
        this.invalidDatabaseRevisions = 0;
        this.start();
    }

    public boolean upToDate() {
        return this.invalidDatabaseRevisions == 0;
    }

    public void start() {
        this.webCommands.addHandler((HandleWebCommandSupport)new EvolutionsWebCommands(this.dbApi, this.evolutions, this.reader, this.config));
        this.dynamicEvolutions.create();
        this.dbApi.databases().foreach((Function1)(JProcedure1 & Serializable)_$1 -> ApplicationEvolutions$.MODULE$.runEvolutions((Database)_$1, this.config, this.evolutions, this.reader, (Function4<String, EvolutionsDatasourceConfig, Seq<Script>, Object, BoxedUnit>)(Function4 & Serializable)(v1, v2, v3, v4) -> {
            this.start$$anonfun$1$$anonfun$1((String)v1, (EvolutionsDatasourceConfig)v2, (Seq)v3, BoxesRunTime.unboxToBoolean((Object)v4));
            return BoxedUnit.UNIT;
        }));
    }

    private final Nothing$ invalidDatabaseRevision$1(String db$1, Seq scripts$1) {
        ++this.invalidDatabaseRevisions;
        throw InvalidDatabaseRevision$.MODULE$.apply(db$1, Evolutions$.MODULE$.toHumanReadableScript((Seq<Script>)scripts$1));
    }

    private static final String start$$anonfun$1$$anonfun$1$$anonfun$1(String db$2, Seq scripts$2) {
        return "Your production database [" + db$2 + "] needs evolutions, including downs! \n\n" + Evolutions$.MODULE$.toHumanReadableScript((Seq<Script>)scripts$2);
    }

    private static final String start$$anonfun$1$$anonfun$1$$anonfun$2(String db$3) {
        return "Run with -Dplay.evolutions.db." + db$3 + ".autoApply=true and -Dplay.evolutions.db." + db$3 + ".autoApplyDowns=true if you want to run them automatically, including downs (be careful, especially if your down evolutions drop existing data)";
    }

    private static final String start$$anonfun$1$$anonfun$1$$anonfun$3(String db$4, Seq scripts$3) {
        return "Your production database [" + db$4 + "] needs evolutions! \n\n" + Evolutions$.MODULE$.toHumanReadableScript((Seq<Script>)scripts$3);
    }

    private static final String start$$anonfun$1$$anonfun$1$$anonfun$4(String db$5) {
        return "Run with -Dplay.evolutions.db." + db$5 + ".autoApply=true if you want to run them automatically (be careful)";
    }

    private final /* synthetic */ void start$$anonfun$1$$anonfun$1(String db, EvolutionsDatasourceConfig dbConfig, Seq scripts, boolean hasDown) {
        Mode mode = this.environment.mode();
        if (Mode.Test$.MODULE$.equals(mode)) {
            this.evolutions.evolve(db, (Seq<Script>)scripts, dbConfig.autocommit(), dbConfig.schema(), dbConfig.metaTable(), dbConfig.substitutionsMappings(), dbConfig.substitutionsPrefix(), dbConfig.substitutionsSuffix(), dbConfig.substitutionsEscape());
            return;
        }
        if (Mode.Dev$.MODULE$.equals(mode)) {
            if (!dbConfig.autoApply()) {
                ++this.invalidDatabaseRevisions;
                return;
            }
            if (dbConfig.autoApply()) {
                this.evolutions.evolve(db, (Seq<Script>)scripts, dbConfig.autocommit(), dbConfig.schema(), dbConfig.metaTable(), dbConfig.substitutionsMappings(), dbConfig.substitutionsPrefix(), dbConfig.substitutionsSuffix(), dbConfig.substitutionsEscape());
                return;
            }
        }
        if (Mode.Prod$.MODULE$.equals(mode)) {
            if (!hasDown && dbConfig.autoApply()) {
                this.evolutions.evolve(db, (Seq<Script>)scripts, dbConfig.autocommit(), dbConfig.schema(), dbConfig.metaTable(), dbConfig.substitutionsMappings(), dbConfig.substitutionsPrefix(), dbConfig.substitutionsSuffix(), dbConfig.substitutionsEscape());
                return;
            }
            if (hasDown && dbConfig.autoApply() && dbConfig.autoApplyDowns()) {
                this.evolutions.evolve(db, (Seq<Script>)scripts, dbConfig.autocommit(), dbConfig.schema(), dbConfig.metaTable(), dbConfig.substitutionsMappings(), dbConfig.substitutionsPrefix(), dbConfig.substitutionsSuffix(), dbConfig.substitutionsEscape());
                return;
            }
            if (hasDown) {
                this.logger.warn(() -> ApplicationEvolutions.start$$anonfun$1$$anonfun$1$$anonfun$1(db, scripts), MarkerContext$.MODULE$.NoMarker());
                this.logger.warn(() -> ApplicationEvolutions.start$$anonfun$1$$anonfun$1$$anonfun$2(db), MarkerContext$.MODULE$.NoMarker());
                throw this.invalidDatabaseRevision$1(db, scripts);
            }
            this.logger.warn(() -> ApplicationEvolutions.start$$anonfun$1$$anonfun$1$$anonfun$3(db, scripts), MarkerContext$.MODULE$.NoMarker());
            this.logger.warn(() -> ApplicationEvolutions.start$$anonfun$1$$anonfun$1$$anonfun$4(db), MarkerContext$.MODULE$.NoMarker());
            throw this.invalidDatabaseRevision$1(db, scripts);
        }
        throw this.invalidDatabaseRevision$1(db, scripts);
    }
}

