/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import play.api.MarkerContext$;
import play.api.db.Database;
import play.api.db.evolutions.DatabaseEvolutions$;
import play.api.db.evolutions.DatabaseUrlPatterns$;
import play.api.db.evolutions.DefaultEvolutionsApi$;
import play.api.db.evolutions.DownScript;
import play.api.db.evolutions.DownScript$;
import play.api.db.evolutions.Evolution;
import play.api.db.evolutions.Evolution$;
import play.api.db.evolutions.Evolutions$;
import play.api.db.evolutions.EvolutionsHelper$;
import play.api.db.evolutions.EvolutionsReader;
import play.api.db.evolutions.InconsistentDatabase;
import play.api.db.evolutions.InconsistentDatabase$;
import play.api.db.evolutions.Script;
import play.api.db.evolutions.UpScript;
import play.api.db.evolutions.UpScript$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class DatabaseEvolutions {
    private final Database database;
    private final String schema;
    private final String metaTable;
    private final Map<String, String> substitutionsMappings;
    private final String substitutionsPrefix;
    private final String substitutionsSuffix;
    private final boolean substitutionsEscape;

    public static String $lessinit$greater$default$2() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$3() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$3();
    }

    public static Map<String, String> $lessinit$greater$default$4() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$5() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$6() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$7() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$7();
    }

    public DatabaseEvolutions(Database database, String schema, String metaTable, Map<String, String> substitutionsMappings, String substitutionsPrefix, String substitutionsSuffix, boolean substitutionsEscape) {
        this.database = database;
        this.schema = schema;
        this.metaTable = metaTable;
        this.substitutionsMappings = substitutionsMappings;
        this.substitutionsPrefix = substitutionsPrefix;
        this.substitutionsSuffix = substitutionsSuffix;
        this.substitutionsEscape = substitutionsEscape;
    }

    public DatabaseEvolutions(Database database, String schema, String metaTable) {
        this(database, schema, metaTable, (Map<String, String>)Predef$.MODULE$.Map().empty(), "$evolutions{{{", "}}}", true);
    }

    public DatabaseEvolutions(Database database, String schema) {
        this(database, schema, "play_evolutions");
    }

    public Seq<Script> scripts(Seq<Evolution> evolutions) {
        if (evolutions.nonEmpty()) {
            Seq application = (Seq)evolutions.reverse();
            Seq<Evolution> database = this.databaseEvolutions();
            Tuple2 tuple2 = database.span((Function1 & Serializable)e -> !application.headOption().exists((Function1 & Serializable)_$1 -> e.revision() <= _$1.revision()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq nonConflictingDowns = (Seq)tuple2._1();
            Seq dRest = (Seq)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)nonConflictingDowns, (Object)dRest);
            Seq nonConflictingDowns2 = (Seq)tuple22._1();
            Seq dRest2 = (Seq)tuple22._2();
            Tuple2 tuple23 = application.span((Function1 & Serializable)e -> !database.headOption().exists((Function1 & Serializable)_$2 -> _$2.revision() >= e.revision()));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Seq nonConflictingUps = (Seq)tuple23._1();
            Seq uRest = (Seq)tuple23._2();
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)nonConflictingUps, (Object)uRest);
            Seq nonConflictingUps2 = (Seq)tuple24._1();
            Seq uRest2 = (Seq)tuple24._2();
            Tuple2<Seq<Evolution>, Seq<Evolution>> tuple25 = Evolutions$.MODULE$.conflictings((Seq<Evolution>)dRest2, (Seq<Evolution>)uRest2);
            if (tuple25 == null) {
                throw new MatchError(tuple25);
            }
            Seq conflictingDowns = (Seq)tuple25._1();
            Seq conflictingUps = (Seq)tuple25._2();
            Tuple2 tuple26 = Tuple2$.MODULE$.apply((Object)conflictingDowns, (Object)conflictingUps);
            Seq conflictingDowns2 = (Seq)tuple26._1();
            Seq conflictingUps2 = (Seq)tuple26._2();
            Seq ups = ((SeqOps)nonConflictingUps2.$plus$plus((IterableOnce)conflictingUps2)).reverseIterator().map((Function1 & Serializable)e -> UpScript$.MODULE$.apply((Evolution)e)).toSeq();
            Seq downs = (Seq)((IterableOps)nonConflictingDowns2.$plus$plus((IterableOnce)conflictingDowns2)).map((Function1 & Serializable)e -> DownScript$.MODULE$.apply((Evolution)e));
            return (Seq)downs.$plus$plus((IterableOnce)ups);
        }
        return package$.MODULE$.Nil();
    }

    public Seq<Script> scripts(EvolutionsReader reader) {
        return this.scripts((Seq<Evolution>)reader.evolutions(this.database.name()).toList());
    }

    public Seq<Evolution> databaseEvolutions() {
        Seq seq;
        this.checkEvolutionsState();
        try (Connection connection = this.database.getConnection(true);){
            seq = (Seq)this.executeQuery("select id, hash, apply_script, revert_script from ${schema}${evolutions_table} order by id", (Function1 & Serializable)rs2 -> (Seq)((SeqOps)package$.MODULE$.Seq().unfold(rs2, (Function1 & Serializable)rs -> {
                boolean bl = rs.next();
                if (!bl) {
                    return None$.MODULE$;
                }
                if (bl) {
                    return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)Evolution$.MODULE$.apply(rs.getInt(1), (String)Option$.MODULE$.apply((Object)rs.getString(3)).getOrElse(DatabaseEvolutions::databaseEvolutions$$anonfun$1$$anonfun$1$$anonfun$1), (String)Option$.MODULE$.apply((Object)rs.getString(4)).getOrElse(DatabaseEvolutions::databaseEvolutions$$anonfun$1$$anonfun$1$$anonfun$2)), rs));
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            })).reverse(), connection);
        }
        return seq;
    }

    public void evolve(Seq<Script> scripts, boolean autocommit) {
        block11: {
            this.checkEvolutionsState();
            Connection connection = this.database.getConnection(autocommit);
            IntRef applying = IntRef.create((int)-1);
            ObjectRef lastScript = ObjectRef.create(null);
            try {
                Object object;
                try {
                    scripts.foreach((Function1 & Serializable)script -> {
                        int n;
                        Script script2 = script;
                        lastScript$1.elem = script2;
                        script2 = null;
                        applying$1.elem = n = script.evolution().revision();
                        this.logBefore$1((Script)script, connection);
                        script.statements().foreach((Function1)(JProcedure1 & Serializable)statement -> {
                            DefaultEvolutionsApi$.MODULE$.logger().debug(() -> DatabaseEvolutions.evolve$$anonfun$1$$anonfun$1$$anonfun$1(statement), MarkerContext$.MODULE$.NoMarker());
                            long start = System.currentTimeMillis();
                            this.execute((String)statement, false, connection);
                            DefaultEvolutionsApi$.MODULE$.logger().debug(() -> DatabaseEvolutions.evolve$$anonfun$1$$anonfun$1$$anonfun$2(start), MarkerContext$.MODULE$.NoMarker());
                        });
                        return this.logAfter$1((Script)script, connection);
                    });
                    if (!autocommit) {
                        connection.commit();
                        object = BoxedUnit.UNIT;
                        break block11;
                    }
                    object = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    String message;
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Object object2;
                        Throwable throwable3 = (Throwable)option.get();
                        Throwable e = throwable3;
                        Throwable throwable4 = e;
                        if (throwable4 instanceof SQLException) {
                            SQLException ex = (SQLException)throwable4;
                            object2 = ex.getMessage() + " [ERROR:" + ex.getErrorCode() + ", SQLSTATE:" + ex.getSQLState() + "]";
                        } else {
                            Throwable ex = throwable4;
                            object2 = ex.getMessage();
                        }
                        message = object2;
                        DefaultEvolutionsApi$.MODULE$.logger().error(() -> DatabaseEvolutions.evolve$$anonfun$2(message), MarkerContext$.MODULE$.NoMarker());
                        if (!autocommit) {
                            connection.rollback();
                            String humanScript = "-- Rev:" + ((Script)lastScript.elem).evolution().revision() + "," + ((Script)lastScript.elem instanceof UpScript ? "Ups" : "Downs") + " - " + ((Script)lastScript.elem).evolution().hash() + "\n\n" + ((Script)lastScript.elem instanceof UpScript ? ((Script)lastScript.elem).evolution().sql_up() : ((Script)lastScript.elem).evolution().sql_down());
                            throw InconsistentDatabase$.MODULE$.apply(this.database.name(), humanScript, message, ((Script)lastScript.elem).evolution().revision(), autocommit);
                        }
                    } else {
                        throw throwable;
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)this.updateLastProblem$1(message, applying.elem, connection));
                }
            }
            finally {
                connection.close();
            }
        }
        this.checkEvolutionsState();
    }

    private void checkEvolutionsState() {
        block8: {
            boolean autocommit = true;
            try (Connection connection = this.database.getConnection(autocommit);){
                try {
                    this.executeQuery("select id, hash, apply_script, revert_script, state, last_problem from ${schema}${evolutions_table} where state like 'applying_%'", (Function1)(JProcedure1 & Serializable)problem -> {
                        if (problem.next()) {
                            int revision = problem.getInt("id");
                            String state = problem.getString("state");
                            String hash = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(problem.getString("hash")), 7);
                            String string = state;
                            String script = "applying_up".equals(string) ? problem.getString("apply_script") : problem.getString("revert_script");
                            String error = problem.getString("last_problem");
                            DefaultEvolutionsApi$.MODULE$.logger().error(() -> DatabaseEvolutions.checkEvolutionsState$$anonfun$1$$anonfun$1(error), MarkerContext$.MODULE$.NoMarker());
                            String string2 = state;
                            String string3 = "applying_up";
                            String humanScript = "-- Rev:" + revision + "," + (!(string2 != null ? !string2.equals(string3) : string3 != null) ? "Ups" : "Downs") + " - " + hash + "\n\n" + script;
                            throw InconsistentDatabase$.MODULE$.apply(this.database.name(), humanScript, error, revision, autocommit);
                        }
                    }, connection);
                }
                catch (InconsistentDatabase e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                        this.createPlayEvolutionsTable$1(connection);
                        break block8;
                    }
                    throw throwable;
                }
            }
        }
    }

    public Seq<Script> resetScripts() {
        Seq<Evolution> appliedEvolutions = this.databaseEvolutions();
        return (Seq)appliedEvolutions.map((Function1 & Serializable)evolution -> DownScript$.MODULE$.apply((Evolution)evolution));
    }

    public void resolve(int revision) {
        try (Connection connection = this.database.getConnection(true);){
            this.execute("update ${schema}${evolutions_table} set state = 'applied' where state = 'applying_up' and id = " + revision, this.execute$default$2(), connection);
            this.execute("delete from ${schema}${evolutions_table} where state = 'applying_down' and id = " + revision, this.execute$default$2(), connection);
        }
    }

    private <T> T executeQuery(String sql, Function1<ResultSet, T> f, Connection c) {
        Object object;
        try (Statement ps = c.createStatement();){
            ResultSet rs = ps.executeQuery(EvolutionsHelper$.MODULE$.applySchemaAndTable(sql, this.schema, this.metaTable));
            object = f.apply((Object)rs);
        }
        return (T)object;
    }

    private boolean execute(String sql, boolean metaQuery, Connection c) {
        boolean bl;
        try (Statement s = c.createStatement();){
            bl = s.execute(metaQuery ? EvolutionsHelper$.MODULE$.applySchemaAndTable(sql, this.schema, this.metaTable) : EvolutionsHelper$.MODULE$.substituteVariables(sql, this.substitutionsMappings, this.substitutionsPrefix, this.substitutionsSuffix, this.substitutionsEscape));
        }
        return bl;
    }

    private boolean execute$default$2() {
        return true;
    }

    private boolean prepareAndExecute(String sql, Function1<PreparedStatement, BoxedUnit> block, Connection c) {
        boolean bl;
        try (PreparedStatement ps = c.prepareStatement(EvolutionsHelper$.MODULE$.applySchemaAndTable(sql, this.schema, this.metaTable));){
            block.apply((Object)ps);
            bl = ps.execute();
        }
        return bl;
    }

    private static final String databaseEvolutions$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "";
    }

    private static final String databaseEvolutions$$anonfun$1$$anonfun$1$$anonfun$2() {
        return "";
    }

    private final void logBefore$1(Script script, Connection conn) {
        Script script2 = script;
        if (script2 instanceof UpScript) {
            Evolution evolution;
            UpScript upScript = UpScript$.MODULE$.unapply((UpScript)script2);
            Evolution e = evolution = upScript._1();
            this.prepareAndExecute("insert into ${schema}${evolutions_table} (id, hash, applied_at, apply_script, revert_script, state, last_problem) values(?, ?, ?, ?, ?, ?, ?)", (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
                ps.setInt(1, e.revision());
                ps.setString(2, e.hash());
                ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                ps.setString(4, e.sql_up());
                ps.setString(5, e.sql_down());
                ps.setString(6, "applying_up");
                ps.setString(7, "");
            }, conn);
            return;
        }
        if (script2 instanceof DownScript) {
            Evolution evolution;
            DownScript downScript = DownScript$.MODULE$.unapply((DownScript)script2);
            Evolution e = evolution = downScript._1();
            this.execute("update ${schema}${evolutions_table} set state = 'applying_down' where id = " + e.revision(), this.execute$default$2(), conn);
            return;
        }
        throw new MatchError((Object)script2);
    }

    private final boolean logAfter$1(Script script, Connection conn) {
        Script script2 = script;
        if (script2 instanceof UpScript) {
            Evolution evolution;
            UpScript upScript = UpScript$.MODULE$.unapply((UpScript)script2);
            Evolution e = evolution = upScript._1();
            return this.execute("update ${schema}${evolutions_table} set state = 'applied' where id = " + e.revision(), this.execute$default$2(), conn);
        }
        if (script2 instanceof DownScript) {
            Evolution evolution;
            DownScript downScript = DownScript$.MODULE$.unapply((DownScript)script2);
            Evolution e = evolution = downScript._1();
            return this.execute("delete from ${schema}${evolutions_table} where id = " + e.revision(), this.execute$default$2(), conn);
        }
        throw new MatchError((Object)script2);
    }

    private final boolean updateLastProblem$1(String message, int revision, Connection conn) {
        return this.prepareAndExecute("update ${schema}${evolutions_table} set last_problem = ? where id = ?", (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, message);
            ps.setInt(2, revision);
        }, conn);
    }

    private static final String evolve$$anonfun$1$$anonfun$1$$anonfun$1(String statement$1) {
        return "Execute: " + statement$1;
    }

    private static final String evolve$$anonfun$1$$anonfun$1$$anonfun$2(long start$1) {
        return "Finished in " + (System.currentTimeMillis() - start$1) + "ms";
    }

    private static final String evolve$$anonfun$2(String message$2) {
        return message$2;
    }

    private final String createPlayEvolutionsTable$1$$anonfun$1() {
        return EvolutionsHelper$.MODULE$.applySchemaAndTable("could not create ${schema}${evolutions_table} table", this.schema, this.metaTable);
    }

    private static final Throwable createPlayEvolutionsTable$1$$anonfun$2(Throwable ex$1) {
        return ex$1;
    }

    /*
     * Unable to fully structure code
     */
    private final void createPlayEvolutionsTable$1(Connection conn) {
        try {
            var3_2 = this.database.url();
            if (var3_2 == null) ** GOTO lbl-1000
            var4_3 = DatabaseUrlPatterns$.MODULE$.SqlServerJdbcUrl().unapplySeq((CharSequence)var3_2);
            if (!var4_3.isEmpty() && (var5_4 = (List)var4_3.get()).lengthCompare(0) == 0) {
                v0 = DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsSqlServerSql();
            } else {
                var6_5 = DatabaseUrlPatterns$.MODULE$.OracleJdbcUrl().unapplySeq((CharSequence)var3_2);
                if (!var6_5.isEmpty() && (var7_6 = (List)var6_5.get()).lengthCompare(0) == 0) {
                    v0 = DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsOracleSql();
                } else {
                    var8_7 = DatabaseUrlPatterns$.MODULE$.MysqlJdbcUrl().unapplySeq((CharSequence)var3_2);
                    if (!var8_7.isEmpty() && (var9_8 = (List)var8_7.get()).lengthCompare(2) == 0) {
                        var10_9 = (String)var9_8.apply(0);
                        var11_10 = (String)var9_8.apply(1);
                        v0 = DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsMySql();
                    } else {
                        var12_11 = DatabaseUrlPatterns$.MODULE$.DerbyJdbcUrl().unapplySeq((CharSequence)var3_2);
                        if (!var12_11.isEmpty() && (var13_12 = (List)var12_11.get()).lengthCompare(0) == 0) {
                            v0 = DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsDerby();
                        } else {
                            var14_13 = DatabaseUrlPatterns$.MODULE$.HsqlJdbcUrl().unapplySeq((CharSequence)var3_2);
                            if (!var14_13.isEmpty() && (var15_14 = (List)var14_13.get()).lengthCompare(0) == 0) {
                                v0 = DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsHsql();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v0 = DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsSql();
                            }
                        }
                    }
                }
            }
            createScript = v0;
            this.execute(createScript, this.execute$default$2(), conn);
        }
        catch (Throwable var16_16) {
            var17_17 = var16_16;
            if (var17_17 != null && !(var18_18 = NonFatal$.MODULE$.unapply(var17_17)).isEmpty()) {
                ex = var19_19 = (Throwable)var18_18.get();
                DefaultEvolutionsApi$.MODULE$.logger().warn((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, createPlayEvolutionsTable$1$$anonfun$1(), ()Ljava/lang/String;)((DatabaseEvolutions)this), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, createPlayEvolutionsTable$1$$anonfun$2(java.lang.Throwable ), ()Ljava/lang/Throwable;)((Throwable)ex), MarkerContext$.MODULE$.NoMarker());
            }
            throw var16_16;
        }
    }

    private static final String checkEvolutionsState$$anonfun$1$$anonfun$1(String error$1) {
        return error$1;
    }
}

