/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class EvolutionsHelper$ {
    public static final EvolutionsHelper$ MODULE$ = new EvolutionsHelper$();

    public String substituteVariables(String sql, Map<String, String> substitutionsMappings, String prefix, String suffix, boolean escape) {
        ObjectRef result = ObjectRef.create((Object)sql);
        substitutionsMappings.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)EvolutionsHelper$.$anonfun$substituteVariables$1(check$ifrefutable$1))).map((Function1 & Serializable)x$1 -> {
            EvolutionsHelper$.$anonfun$substituteVariables$2(result, prefix, suffix, x$1);
            return BoxedUnit.UNIT;
        });
        if (escape) {
            return ((String)result.elem).replaceAll("(?i)" + Pattern.quote("!" + prefix) + "([^" + Pattern.quote(suffix) + "]*)" + Pattern.quote(suffix), Matcher.quoteReplacement(prefix) + "$1" + Matcher.quoteReplacement(suffix));
        }
        return (String)result.elem;
    }

    public String applySchemaAndTable(String sql, String schema, String table) {
        String withSchema = this.applySchema(sql, schema);
        return this.applyTableName(withSchema, table);
    }

    public String applyConfig(String sql, EvolutionsDatasourceConfig config) {
        return this.applySchemaAndTable(sql, config.schema(), config.metaTable());
    }

    public String applySchema(String sql, String schema) {
        return sql.replaceAll("\\$\\{schema}", (String)Option$.MODULE$.apply((Object)schema).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim())))).map((Function1 & Serializable)x$3 -> x$3.trim() + ".").getOrElse((Function0 & Serializable)() -> ""));
    }

    public String applyTableName(String sql, String table) {
        return sql.replaceAll("\\$\\{evolutions_table}", this.getPreparedTableName(table));
    }

    private String getPreparedTableName(String tableName) {
        return (String)Option$.MODULE$.apply((Object)tableName).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4.trim())))).getOrElse((Function0 & Serializable)() -> "play_evolutions");
    }

    public static final /* synthetic */ boolean $anonfun$substituteVariables$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$substituteVariables$2(ObjectRef result$1, String prefix$1, String suffix$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            result$1.elem = ((String)result$1.elem).replaceAll("(?i)(^|[^!])" + Pattern.quote(prefix$1 + k + suffix$1), "$1" + Matcher.quoteReplacement(v));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private EvolutionsHelper$() {
    }
}

