/*
 * Decompiled with CFR 0.152.
 */
package play.db.evolutions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.api.db.evolutions.ClassLoaderEvolutionsReader;
import play.api.db.evolutions.DatabaseEvolutions;
import play.api.db.evolutions.EvolutionsReader;
import play.db.Database;
import play.db.evolutions.Evolution;
import play.db.evolutions.SimpleEvolutionsReader;
import play.libs.Scala;

public class Evolutions {
    private static final String DEFAULT_SCHEMA = "";
    private static final boolean DEFAULT_AUTOCOMMIT = true;
    private static final String DEFAULT_METATABLE = "play_evolutions";

    public static EvolutionsReader fromClassLoader() {
        return Evolutions.fromClassLoader(Evolutions.class.getClassLoader());
    }

    public static EvolutionsReader fromClassLoader(ClassLoader classLoader) {
        return Evolutions.fromClassLoader(classLoader, DEFAULT_SCHEMA);
    }

    public static EvolutionsReader fromClassLoader(ClassLoader classLoader, String string) {
        return new ClassLoaderEvolutionsReader(classLoader, string);
    }

    public static EvolutionsReader fromMap(Map<String, List<Evolution>> map) {
        return new SimpleEvolutionsReader(map);
    }

    public static EvolutionsReader forDefault(Evolution ... evolutionArray) {
        HashMap<String, List<Evolution>> hashMap = new HashMap<String, List<Evolution>>();
        hashMap.put("default", Arrays.asList(evolutionArray));
        return Evolutions.fromMap(hashMap);
    }

    public static void applyEvolutions(Database database) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader());
    }

    public static void applyEvolutions(Database database, boolean bl) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader(), bl);
    }

    public static void applyEvolutions(Database database, String string) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader(), string);
    }

    public static void applyEvolutions(Database database, Map<String, String> map, String string, String string2, boolean bl) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader(), map, string, string2, bl);
    }

    public static void applyEvolutions(String string, Database database) {
        Evolutions.applyEvolutions(string, database, Evolutions.fromClassLoader());
    }

    public static void applyEvolutions(Database database, String string, Map<String, String> map, String string2, String string3, boolean bl) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader(), string, map, string2, string3, bl);
    }

    public static void applyEvolutions(String string, Database database, Map<String, String> map, String string2, String string3, boolean bl) {
        Evolutions.applyEvolutions(string, database, Evolutions.fromClassLoader(), map, string2, string3, bl);
    }

    public static void applyEvolutions(Database database, String string, String string2) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader(), string, string2);
    }

    public static void applyEvolutions(Database database, String string, String string2, Map<String, String> map, String string3, String string4, boolean bl) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader(), string, string2, map, string3, string4, bl);
    }

    public static void applyEvolutions(String string, Database database, boolean bl) {
        Evolutions.applyEvolutions(string, database, Evolutions.fromClassLoader(), bl);
    }

    public static void applyEvolutions(Database database, boolean bl, String string) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader(), bl, string);
    }

    public static void applyEvolutions(Database database, boolean bl, String string, String string2) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader(), bl, string, string2);
    }

    public static void applyEvolutions(Database database, boolean bl, String string, Map<String, String> map, String string2, String string3, boolean bl2) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader(), bl, string, map, string2, string3, bl2);
    }

    public static void applyEvolutions(String string, Database database, boolean bl, Map<String, String> map, String string2, String string3, boolean bl2) {
        Evolutions.applyEvolutions(string, database, Evolutions.fromClassLoader(), bl, map, string2, string3, bl2);
    }

    public static void applyEvolutions(Database database, boolean bl, Map<String, String> map, String string, String string2, boolean bl2) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader(), bl, map, string, string2, bl2);
    }

    public static void applyEvolutions(Database database, boolean bl, String string, String string2, Map<String, String> map, String string3, String string4, boolean bl2) {
        Evolutions.applyEvolutions(database, Evolutions.fromClassLoader(), bl, string, string2, map, string3, string4, bl2);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader) {
        Evolutions.applyEvolutions(database, evolutionsReader, true);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader, boolean bl) {
        Evolutions.applyEvolutions(database, evolutionsReader, bl, DEFAULT_SCHEMA);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader, String string) {
        Evolutions.applyEvolutions(database, evolutionsReader, true, string);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader, Map<String, String> map, String string, String string2, boolean bl) {
        Evolutions.applyEvolutions(database, evolutionsReader, DEFAULT_SCHEMA, map, string, string2, bl);
    }

    public static void applyEvolutions(String string, Database database, EvolutionsReader evolutionsReader) {
        Evolutions.applyEvolutions(database, evolutionsReader, DEFAULT_SCHEMA, string);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader, String string, Map<String, String> map, String string2, String string3, boolean bl) {
        Evolutions.applyEvolutions(database, evolutionsReader, string, DEFAULT_METATABLE, map, string2, string3, bl);
    }

    public static void applyEvolutions(String string, Database database, EvolutionsReader evolutionsReader, Map<String, String> map, String string2, String string3, boolean bl) {
        Evolutions.applyEvolutions(database, evolutionsReader, DEFAULT_SCHEMA, string, map, string2, string3, bl);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader, String string, String string2) {
        Evolutions.applyEvolutions(database, evolutionsReader, true, string, string2);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader, String string, String string2, Map<String, String> map, String string3, String string4, boolean bl) {
        Evolutions.applyEvolutions(database, evolutionsReader, true, string, string2, map, string3, string4, bl);
    }

    public static void applyEvolutions(String string, Database database, EvolutionsReader evolutionsReader, boolean bl) {
        Evolutions.applyEvolutions(database, evolutionsReader, bl, DEFAULT_SCHEMA, string);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader, boolean bl, String string) {
        DatabaseEvolutions databaseEvolutions = new DatabaseEvolutions(database.asScala(), string);
        databaseEvolutions.evolve(databaseEvolutions.scripts(evolutionsReader), bl);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader, boolean bl, String string, String string2) {
        DatabaseEvolutions databaseEvolutions = new DatabaseEvolutions(database.asScala(), string, string2);
        databaseEvolutions.evolve(databaseEvolutions.scripts(evolutionsReader), bl);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader, boolean bl, String string, Map<String, String> map, String string2, String string3, boolean bl2) {
        Evolutions.applyEvolutions(database, evolutionsReader, bl, string, DEFAULT_METATABLE, map, string2, string3, bl2);
    }

    public static void applyEvolutions(String string, Database database, EvolutionsReader evolutionsReader, boolean bl, Map<String, String> map, String string2, String string3, boolean bl2) {
        Evolutions.applyEvolutions(database, evolutionsReader, bl, DEFAULT_SCHEMA, string, map, string2, string3, bl2);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader, boolean bl, Map<String, String> map, String string, String string2, boolean bl2) {
        Evolutions.applyEvolutions(database, evolutionsReader, bl, DEFAULT_SCHEMA, map, string, string2, bl2);
    }

    public static void applyEvolutions(Database database, EvolutionsReader evolutionsReader, boolean bl, String string, String string2, Map<String, String> map, String string3, String string4, boolean bl2) {
        DatabaseEvolutions databaseEvolutions = new DatabaseEvolutions(database.asScala(), string, string2, (scala.collection.immutable.Map<String, String>)Scala.asScala(map), string3, string4, bl2);
        databaseEvolutions.evolve(databaseEvolutions.scripts(evolutionsReader), bl);
    }

    public static void cleanupEvolutions(Database database, boolean bl, String string) {
        DatabaseEvolutions databaseEvolutions = new DatabaseEvolutions(database.asScala(), string);
        databaseEvolutions.evolve(databaseEvolutions.resetScripts(), bl);
    }

    public static void cleanupEvolutions(Database database, boolean bl, String string, String string2) {
        DatabaseEvolutions databaseEvolutions = new DatabaseEvolutions(database.asScala(), string, string2);
        databaseEvolutions.evolve(databaseEvolutions.resetScripts(), bl);
    }

    public static void cleanupEvolutions(Database database, boolean bl, String string, String string2, Map<String, String> map, String string3, String string4, boolean bl2) {
        DatabaseEvolutions databaseEvolutions = new DatabaseEvolutions(database.asScala(), string, string2, (scala.collection.immutable.Map<String, String>)Scala.asScala(map), string3, string4, bl2);
        databaseEvolutions.evolve(databaseEvolutions.resetScripts(), bl);
    }

    public static void cleanupEvolutions(Database database, boolean bl) {
        Evolutions.cleanupEvolutions(database, bl, DEFAULT_SCHEMA);
    }

    public static void cleanupEvolutions(Database database, String string) {
        Evolutions.cleanupEvolutions(database, true, string);
    }

    public static void cleanupEvolutions(Database database, String string, String string2) {
        Evolutions.cleanupEvolutions(database, true, string, string2);
    }

    public static void cleanupEvolutions(Database database, String string, String string2, Map<String, String> map, String string3, String string4, boolean bl) {
        Evolutions.cleanupEvolutions(database, true, string, string2, map, string3, string4, bl);
    }

    public static void cleanupEvolutions(Database database) {
        Evolutions.cleanupEvolutions(database, DEFAULT_SCHEMA);
    }
}

