/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.ConfigLoader;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Logger;
import play.api.Logger$;
import play.api.db.evolutions.DefaultEvolutionsConfig;
import play.api.db.evolutions.DefaultEvolutionsDatasourceConfig;
import play.api.db.evolutions.EvolutionsConfig;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Singleton
@ScalaSignature(bytes="\u0006\u0005]3A\u0001C\u0005\u0001%!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u0003-\u0001\u0011\u0005Q\u0006C\u00045\u0001\t\u0007I\u0011B\u001b\t\re\u0002\u0001\u0015!\u00037\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u0015a\u0004\u0001\"\u0001<\u0011\u0015i\u0004\u0001\"\u0001?\u0005u!UMZ1vYR,eo\u001c7vi&|gn]\"p]\u001aLw\rU1sg\u0016\u0014(B\u0001\u0006\f\u0003))go\u001c7vi&|gn\u001d\u0006\u0003\u00195\t!\u0001\u001a2\u000b\u00059y\u0011aA1qS*\t\u0001#\u0001\u0003qY\u0006L8\u0001A\n\u0004\u0001MY\u0002C\u0001\u000b\u001a\u001b\u0005)\"B\u0001\f\u0018\u0003\u0011a\u0017M\\4\u000b\u0003a\tAA[1wC&\u0011!$\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007q\t3%D\u0001\u001e\u0015\tqr$\u0001\u0004j]*,7\r\u001e\u0006\u0002A\u0005)!.\u0019<bq&\u0011!%\b\u0002\t!J|g/\u001b3feB\u0011A%J\u0007\u0002\u0013%\u0011a%\u0003\u0002\u0011\u000bZ|G.\u001e;j_:\u001c8i\u001c8gS\u001e\f!B]8pi\u000e{gNZ5h!\tI#&D\u0001\u000e\u0013\tYSBA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059z\u0003C\u0001\u0013\u0001\u0011\u00159#\u00011\u0001)Q\t\u0011\u0011\u0007\u0005\u0002\u001de%\u00111'\b\u0002\u0007\u0013:TWm\u0019;\u0002\r1|wmZ3s+\u00051\u0004CA\u00158\u0013\tATB\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\r9W\r\u001e\u000b\u0002G\u0005)\u0001/\u0019:tK\u0006YQM\\1cY\u0016$7*Z=t)\ryt*\u0015\t\u0004\u0001&ceBA!H!\t\u0011U)D\u0001D\u0015\t!\u0015#\u0001\u0004=e>|GO\u0010\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*R\u0001\u0007!J,G-\u001a4\n\u0005)[%aA*fi*\u0011\u0001*\u0012\t\u0003\u00016K!AT&\u0003\rM#(/\u001b8h\u0011\u0015\u0001v\u00011\u0001)\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]\")!k\u0002a\u0001\u0019\u000691/Z2uS>t\u0007F\u0001\u0001U!\taR+\u0003\u0002W;\tI1+\u001b8hY\u0016$xN\u001c")
public class DefaultEvolutionsConfigParser
implements Provider<EvolutionsConfig> {
    private final Configuration rootConfig;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public EvolutionsConfig get() {
        return this.parse();
    }

    public EvolutionsConfig parse() {
        Configuration config = (Configuration)this.rootConfig.get("play.evolutions", ConfigLoader$.MODULE$.configurationLoader());
        Set datasources = (Set)((Configuration)config.get("db", ConfigLoader$.MODULE$.configurationLoader())).subKeys().$plus$plus((IterableOnce)this.loadDatasources$1("applyEvolutions")).$plus$plus((IterableOnce)this.loadDatasources$1("applyDownEvolutions"));
        boolean enabled = BoxesRunTime.unboxToBoolean((Object)config.get("enabled", ConfigLoader$.MODULE$.booleanLoader()));
        String schema = (String)config.get("schema", ConfigLoader$.MODULE$.stringLoader());
        String metaTable = (String)config.get("metaTable", ConfigLoader$.MODULE$.stringLoader());
        boolean autocommit = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(config, (Function0 & Serializable)() -> "play.evolutions", "autocommit", "evolutions.autocommit", ConfigLoader$.MODULE$.booleanLoader()));
        boolean useLocks = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(config, (Function0 & Serializable)() -> "play.evolutions", "useLocks", "evolutions.use.locks", ConfigLoader$.MODULE$.booleanLoader()));
        boolean autoApply = BoxesRunTime.unboxToBoolean((Object)config.get("autoApply", ConfigLoader$.MODULE$.booleanLoader()));
        boolean autoApplyDowns = BoxesRunTime.unboxToBoolean((Object)config.get("autoApplyDowns", ConfigLoader$.MODULE$.booleanLoader()));
        boolean skipApplyDownsOnly = BoxesRunTime.unboxToBoolean((Object)config.get("skipApplyDownsOnly", ConfigLoader$.MODULE$.booleanLoader()));
        String path = (String)config.get("path", ConfigLoader$.MODULE$.stringLoader());
        String substPrefix = (String)config.get("substitutions.prefix", ConfigLoader$.MODULE$.stringLoader());
        String substSuffix = (String)config.get("substitutions.suffix", ConfigLoader$.MODULE$.stringLoader());
        Map substMappings = DefaultEvolutionsConfigParser.loadSubstitutionsMappings$1(config);
        boolean escapeEnabled = BoxesRunTime.unboxToBoolean((Object)config.get("substitutions.escapeEnabled", ConfigLoader$.MODULE$.booleanLoader()));
        DefaultEvolutionsDatasourceConfig defaultConfig = new DefaultEvolutionsDatasourceConfig(enabled, schema, metaTable, autocommit, useLocks, autoApply, autoApplyDowns, skipApplyDownsOnly, substPrefix, substSuffix, (Map<String, String>)substMappings, escapeEnabled, path);
        Map datasourceConfigMap = (Map)((IterableOnceOps)datasources.map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), (Object)config))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)config.getPrototypedMap("db", ""));
        Map datasourceConfig = (Map)datasourceConfigMap.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String datasource = (String)tuple2._1();
                Configuration dsConfig = (Configuration)tuple2._2();
                boolean enabled = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("enabled", ConfigLoader$.MODULE$.booleanLoader()));
                String schema = (String)dsConfig.get("schema", ConfigLoader$.MODULE$.stringLoader());
                String metaTable = (String)dsConfig.get("metaTable", ConfigLoader$.MODULE$.stringLoader());
                boolean autocommit = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("autocommit", ConfigLoader$.MODULE$.booleanLoader()));
                boolean useLocks = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("useLocks", ConfigLoader$.MODULE$.booleanLoader()));
                boolean autoApply = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(dsConfig, (Function0 & Serializable)() -> "play.evolutions.db." + datasource, "autoApply", "applyEvolutions." + datasource, ConfigLoader$.MODULE$.booleanLoader()));
                boolean autoApplyDowns = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(dsConfig, (Function0 & Serializable)() -> "play.evolutions.db." + datasource, "autoApplyDowns", "applyDownEvolutions." + datasource, ConfigLoader$.MODULE$.booleanLoader()));
                boolean skipApplyDownsOnly = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(dsConfig, (Function0 & Serializable)() -> "play.evolutions.db." + datasource, "skipApplyDownsOnly", "skipApplyDownsOnly." + datasource, ConfigLoader$.MODULE$.booleanLoader()));
                String path = (String)dsConfig.get("path", ConfigLoader$.MODULE$.stringLoader());
                String substPrefix = (String)dsConfig.get("substitutions.prefix", ConfigLoader$.MODULE$.stringLoader());
                String substSuffix = (String)dsConfig.get("substitutions.suffix", ConfigLoader$.MODULE$.stringLoader());
                boolean escapeEnabled = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("substitutions.escapeEnabled", ConfigLoader$.MODULE$.booleanLoader()));
                Map substMappings = DefaultEvolutionsConfigParser.loadSubstitutionsMappings$1(dsConfig);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)datasource), (Object)new DefaultEvolutionsDatasourceConfig(enabled, schema, metaTable, autocommit, useLocks, autoApply, autoApplyDowns, skipApplyDownsOnly, substPrefix, substSuffix, (Map<String, String>)substMappings, escapeEnabled, path));
            }
            throw new MatchError((Object)tuple2);
        });
        return new DefaultEvolutionsConfig(defaultConfig, (Map<String, EvolutionsDatasourceConfig>)datasourceConfig);
    }

    public Set<String> enabledKeys(Configuration configuration, String section) {
        return (Set)configuration.getOptional(section, ConfigLoader$.MODULE$.configurationLoader()).fold((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable)conf -> (Set)conf.keys().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DefaultEvolutionsConfigParser.$anonfun$enabledKeys$3(conf, x$6))));
    }

    private final Object getDeprecated$1(Configuration config, Function0 baseKey, String path, String deprecated, ConfigLoader evidence$1) {
        if (this.rootConfig.underlying().hasPath(deprecated)) {
            this.rootConfig.reportDeprecation(baseKey.apply() + "." + path, deprecated);
            return this.rootConfig.get(deprecated, evidence$1);
        }
        return config.get(path, evidence$1);
    }

    private static final Map loadSubstitutionsMappings$1(Configuration config) {
        return ((IterableOnceOps)((Configuration)config.get("substitutions.mappings", ConfigLoader$.MODULE$.configurationLoader())).entrySet().map((Function1 & Serializable)e -> new Tuple2(e._1(), (Object)((ConfigValue)e._2()).unwrapped().toString()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final Set loadDatasources$1(String path) {
        if (this.rootConfig.underlying().hasPath(path)) {
            return ((Configuration)this.rootConfig.get(path, ConfigLoader$.MODULE$.configurationLoader())).subKeys();
        }
        return Predef$.MODULE$.Set().empty();
    }

    public static final /* synthetic */ boolean $anonfun$enabledKeys$3(Configuration conf$1, String x$6) {
        return BoxesRunTime.unboxToBoolean((Object)conf$1.getOptional(x$6, ConfigLoader$.MODULE$.booleanLoader()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    @Inject
    public DefaultEvolutionsConfigParser(Configuration rootConfig) {
        this.rootConfig = rootConfig;
        this.logger = Logger$.MODULE$.apply(DefaultEvolutionsConfigParser.class);
    }
}

