/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.db.Database;
import play.api.db.evolutions.ApplicationEvolutions;
import play.api.db.evolutions.DatabaseUrlPatterns$;
import play.api.db.evolutions.DownScript;
import play.api.db.evolutions.EvolutionsApi;
import play.api.db.evolutions.EvolutionsConfig;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import play.api.db.evolutions.EvolutionsHelper$;
import play.api.db.evolutions.EvolutionsReader;
import play.api.db.evolutions.Script;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

public final class ApplicationEvolutions$ {
    public static final ApplicationEvolutions$ MODULE$ = new ApplicationEvolutions$();
    private static final Logger logger = Logger$.MODULE$.apply(ApplicationEvolutions.class);
    private static final String SelectPlayEvolutionsLockSql = "\n      select lock from ${schema}${evolutions_table}_lock\n    ";
    private static final String SelectPlayEvolutionsLockMysqlSql = "\n      select `lock` from ${schema}${evolutions_table}_lock\n    ";
    private static final String SelectPlayEvolutionsLockOracleSql = "\n      select \"lock\" from ${schema}${evolutions_table}_lock\n    ";
    private static final String CreatePlayEvolutionsLockSql = "\n      create table ${schema}${evolutions_table}_lock (\n        lock int not null primary key\n      )\n    ";
    private static final String CreatePlayEvolutionsLockMysqlSql = "\n      create table ${schema}${evolutions_table}_lock (\n        `lock` int not null primary key\n      )\n    ";
    private static final String CreatePlayEvolutionsLockOracleSql = "\n      CREATE TABLE ${schema}${evolutions_table}_lock (\n        \"lock\" Number(10,0) Not Null Enable,\n        CONSTRAINT ${evolutions_table}_lock_pk PRIMARY KEY (\"lock\")\n      )\n    ";
    private static final String InsertIntoPlayEvolutionsLockSql = "\n      insert into ${schema}${evolutions_table}_lock (lock) values (1)\n    ";
    private static final String InsertIntoPlayEvolutionsLockMysqlSql = "\n      insert into ${schema}${evolutions_table}_lock (`lock`) values (1)\n    ";
    private static final String InsertIntoPlayEvolutionsLockOracleSql = "\n      insert into ${schema}${evolutions_table}_lock (\"lock\") values (1)\n    ";
    private static final List<String> lockPlayEvolutionsLockSqls = new .colon.colon((Object)"\n        select lock from ${schema}${evolutions_table}_lock where lock = 1 for update nowait\n      ", (List)Nil$.MODULE$);
    private static final List<String> lockPlayEvolutionsLockMysqlSqls = new .colon.colon((Object)"\n        set innodb_lock_wait_timeout = 1\n      ", (List)new .colon.colon((Object)"\n        select `lock` from ${schema}${evolutions_table}_lock where `lock` = 1 for update\n      ", (List)Nil$.MODULE$));
    private static final List<String> lockPlayEvolutionsLockOracleSqls = new .colon.colon((Object)"\n        select \"lock\" from ${schema}${evolutions_table}_lock where \"lock\" = 1 for update nowait\n      ", (List)Nil$.MODULE$);

    private Logger logger() {
        return logger;
    }

    public String SelectPlayEvolutionsLockSql() {
        return SelectPlayEvolutionsLockSql;
    }

    public String SelectPlayEvolutionsLockMysqlSql() {
        return SelectPlayEvolutionsLockMysqlSql;
    }

    public String SelectPlayEvolutionsLockOracleSql() {
        return SelectPlayEvolutionsLockOracleSql;
    }

    public String CreatePlayEvolutionsLockSql() {
        return CreatePlayEvolutionsLockSql;
    }

    public String CreatePlayEvolutionsLockMysqlSql() {
        return CreatePlayEvolutionsLockMysqlSql;
    }

    public String CreatePlayEvolutionsLockOracleSql() {
        return CreatePlayEvolutionsLockOracleSql;
    }

    public String InsertIntoPlayEvolutionsLockSql() {
        return InsertIntoPlayEvolutionsLockSql;
    }

    public String InsertIntoPlayEvolutionsLockMysqlSql() {
        return InsertIntoPlayEvolutionsLockMysqlSql;
    }

    public String InsertIntoPlayEvolutionsLockOracleSql() {
        return InsertIntoPlayEvolutionsLockOracleSql;
    }

    public List<String> lockPlayEvolutionsLockSqls() {
        return lockPlayEvolutionsLockSqls;
    }

    public List<String> lockPlayEvolutionsLockMysqlSqls() {
        return lockPlayEvolutionsLockMysqlSqls;
    }

    public List<String> lockPlayEvolutionsLockOracleSqls() {
        return lockPlayEvolutionsLockOracleSqls;
    }

    public void runEvolutions(Database database, EvolutionsConfig config, EvolutionsApi evolutions, EvolutionsReader reader, Function4<String, EvolutionsDatasourceConfig, Seq<Script>, Object, BoxedUnit> block) {
        String db = database.name();
        EvolutionsDatasourceConfig dbConfig = config.forDatasource(db);
        if (dbConfig.enabled()) {
            this.withLock(database, dbConfig, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Seq<Script> scripts = evolutions.scripts(db, reader, dbConfig.schema(), dbConfig.metaTable());
                boolean hasDown = scripts.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ApplicationEvolutions$.$anonfun$runEvolutions$2(x$2)));
                boolean onlyDowns = scripts.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ApplicationEvolutions$.$anonfun$runEvolutions$3(x$3)));
                if (!(!scripts.nonEmpty() || onlyDowns && dbConfig.skipApplyDownsOnly())) {
                    block.apply((Object)db, (Object)dbConfig, scripts, (Object)BoxesRunTime.boxToBoolean((boolean)hasDown));
                    return;
                }
            });
            return;
        }
    }

    private void withLock(Database db, EvolutionsDatasourceConfig dbConfig, Function0<BoxedUnit> block) {
        if (dbConfig.useLocks()) {
            DataSource ds = db.dataSource();
            String url = db.url();
            Connection c = ds.getConnection();
            c.setAutoCommit(false);
            Statement s = c.createStatement();
            this.createLockTableIfNecessary(url, c, s, dbConfig);
            this.lock(url, c, s, dbConfig, this.lock$default$5());
            try {
                block.apply$mcV$sp();
            }
            finally {
                this.unlock(c, s);
            }
            return;
        }
        block.apply$mcV$sp();
    }

    private void createLockTableIfNecessary(String url, Connection c, Statement s, EvolutionsDatasourceConfig dbConfig) {
        Option option;
        Tuple3 tuple3;
        Option option2;
        String string = url;
        Tuple3 tuple32 = string != null && !(option2 = DatabaseUrlPatterns$.MODULE$.OracleJdbcUrl().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(0) == 0 ? new Tuple3((Object)this.SelectPlayEvolutionsLockOracleSql(), (Object)this.CreatePlayEvolutionsLockOracleSql(), (Object)this.InsertIntoPlayEvolutionsLockOracleSql()) : (tuple3 = string != null && !(option = DatabaseUrlPatterns$.MODULE$.MysqlJdbcUrl().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0 ? new Tuple3((Object)this.SelectPlayEvolutionsLockMysqlSql(), (Object)this.CreatePlayEvolutionsLockMysqlSql(), (Object)this.InsertIntoPlayEvolutionsLockMysqlSql()) : new Tuple3((Object)this.SelectPlayEvolutionsLockSql(), (Object)this.CreatePlayEvolutionsLockSql(), (Object)this.InsertIntoPlayEvolutionsLockSql()));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String selectScript = (String)tuple3._1();
        String createScript = (String)tuple3._2();
        String insertScript = (String)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)selectScript, (Object)createScript, (Object)insertScript);
        String selectScript2 = (String)tuple33._1();
        String createScript2 = (String)tuple33._2();
        String insertScript2 = (String)tuple33._3();
        try {
            ResultSet r = s.executeQuery(EvolutionsHelper$.MODULE$.applyConfig(selectScript2, dbConfig));
            r.close();
        }
        catch (SQLException e) {
            c.rollback();
            s.execute(EvolutionsHelper$.MODULE$.applyConfig(createScript2, dbConfig));
            s.executeUpdate(EvolutionsHelper$.MODULE$.applyConfig(insertScript2, dbConfig));
        }
    }

    private void lock(String url, Connection c, Statement s, EvolutionsDatasourceConfig dbConfig, int attempts) {
        while (true) {
            Option option;
            Option option2;
            String string;
            List<String> lockScripts = (string = url) != null && !(option2 = DatabaseUrlPatterns$.MODULE$.MysqlJdbcUrl().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(2) == 0 ? this.lockPlayEvolutionsLockMysqlSqls() : (string != null && !(option = DatabaseUrlPatterns$.MODULE$.OracleJdbcUrl().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(0) == 0 ? this.lockPlayEvolutionsLockOracleSqls() : this.lockPlayEvolutionsLockSqls());
            try {
                lockScripts.foreach((Function1 & Serializable)script -> BoxesRunTime.boxToBoolean((boolean)s.execute(EvolutionsHelper$.MODULE$.applyConfig(script, dbConfig))));
            }
            catch (SQLException e) {
                if (attempts == 0) {
                    throw e;
                }
                this.logger().warn((Function0 & Serializable)() -> "Exception while attempting to lock evolutions (other node probably has lock), sleeping for 1 sec", MarkerContext$.MODULE$.NoMarker());
                c.rollback();
                Thread.sleep(1000L);
                --attempts;
                continue;
            }
            break;
        }
    }

    private int lock$default$5() {
        return 5;
    }

    private void unlock(Connection c, Statement s) {
        Exception$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{SQLException.class})).apply((Function0)(JFunction0.mcV.sp & Serializable)() -> s.close());
        Exception$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{SQLException.class})).apply((Function0)(JFunction0.mcV.sp & Serializable)() -> c.commit());
        Exception$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{SQLException.class})).apply((Function0)(JFunction0.mcV.sp & Serializable)() -> c.close());
    }

    public static final /* synthetic */ boolean $anonfun$runEvolutions$2(Script x$2) {
        return x$2 instanceof DownScript;
    }

    public static final /* synthetic */ boolean $anonfun$runEvolutions$3(Script x$3) {
        return x$3 instanceof DownScript;
    }

    private ApplicationEvolutions$() {
    }
}

