/*
 * Decompiled with CFR 0.152.
 */
package play.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.db.DBApi;
import play.db.Database;
import play.db.DefaultDatabase;
import play.libs.Scala;
import scala.collection.Seq;

@Singleton
public class DefaultDBApi
implements DBApi {
    private final play.api.db.DBApi dbApi;
    private final List<Database> databases;
    private final Map<String, Database> databaseByName;

    @Inject
    public DefaultDBApi(play.api.db.DBApi dBApi) {
        this.dbApi = dBApi;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        ImmutableMap.Builder builder2 = new ImmutableMap.Builder();
        for (play.api.db.Database database : Scala.asJava((Seq)dBApi.databases())) {
            DefaultDatabase defaultDatabase = new DefaultDatabase(database);
            builder.add((Object)defaultDatabase);
            builder2.put((Object)defaultDatabase.getName(), (Object)defaultDatabase);
        }
        this.databases = builder.build();
        this.databaseByName = builder2.build();
    }

    public List<Database> getDatabases() {
        return this.databases;
    }

    public Database getDatabase(String string) {
        return this.databaseByName.get(string);
    }

    public void shutdown() {
        this.dbApi.shutdown();
    }
}

