/*
 * Decompiled with CFR 0.152.
 */
package play.grpc.internal;

import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.grpc.internal.GrpcProtocolNative$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpHeader$;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import play.api.http.HttpChunk;
import play.api.http.HttpEntity;
import play.api.http.Status$;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.ActionBuilder;
import play.api.mvc.AnyContent;
import play.api.mvc.BodyParser;
import play.api.mvc.BodyParser$;
import play.api.mvc.EssentialAction;
import play.api.mvc.Handler;
import play.api.mvc.Headers;
import play.api.mvc.Headers$;
import play.api.mvc.PlayBodyParsers;
import play.api.mvc.Request;
import play.api.mvc.RequestHeader;
import play.api.mvc.ResponseHeader;
import play.api.mvc.ResponseHeader$;
import play.api.mvc.Result;
import play.api.mvc.Result$;
import play.api.routing.Router;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;

@InternalApi
public abstract class PlayRouterUsingActions
implements Router {
    private final PlayBodyParsers parsers;
    private final ActionBuilder<Request, AnyContent> actionBuilder;
    public final String play$grpc$internal$PlayRouterUsingActions$$prefix;
    public final Function1<RequestHeader, EssentialAction> play$grpc$internal$PlayRouterUsingActions$$handler;

    public PlayRouterUsingActions(ActorSystem system, String serviceName, PlayBodyParsers parsers, ActionBuilder<Request, AnyContent> actionBuilder) {
        this.parsers = parsers;
        this.actionBuilder = actionBuilder;
        this.play$grpc$internal$PlayRouterUsingActions$$prefix = new StringBuilder(1).append("/").append(serviceName).toString();
        this.play$grpc$internal$PlayRouterUsingActions$$handler = this.createHandler(serviceName, system);
    }

    @InternalApi
    public abstract Function1<RequestHeader, EssentialAction> createHandler(String var1, ActorSystem var2);

    public final PartialFunction<RequestHeader, Handler> routes() {
        return new Serializable(this){
            private final /* synthetic */ PlayRouterUsingActions $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(RequestHeader x) {
                RequestHeader requestHeader = x;
                RequestHeader rh = requestHeader;
                return rh.path().startsWith(this.$outer.play$grpc$internal$PlayRouterUsingActions$$prefix);
            }

            public final Object applyOrElse(RequestHeader x, Function1 function1) {
                RequestHeader requestHeader = x;
                RequestHeader rh = requestHeader;
                if (rh.path().startsWith(this.$outer.play$grpc$internal$PlayRouterUsingActions$$prefix)) {
                    return this.$outer.play$grpc$internal$PlayRouterUsingActions$$handler.apply((Object)rh);
                }
                return function1.apply((Object)x);
            }
        };
    }

    public final Seq<Tuple3<String, String, String>> documentation() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public final Router withPrefix(String prefix) {
        String string = prefix;
        String string2 = "/";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this;
        }
        throw new UnsupportedOperationException(new StringBuilder(190).append("Prefixing gRPC services is not widely supported by clients, ").append("strongly discouraged by the specification and therefore not supported. ").append(new StringBuilder(72).append("Attempted to prefix with [").append(prefix).append("], yet already default prefix known to be [").append(this.play$grpc$internal$PlayRouterUsingActions$$prefix).append("]. ").toString()).append("When binding gRPC routers the path in `routes` MUST BE `/`.").toString());
    }

    public EssentialAction createStreamingAction(Function1<HttpRequest, Future<HttpResponse>> handler, ExecutionContext ec) {
        return this.actionBuilder.async(this.streamBodyParser(ec), (Function1 & Serializable)req -> ((Future)handler.apply((Object)this.playToPekkoRequestStream((Request<Source<ByteString, ?>>)req))).map((Function1 & Serializable)pekkoResp -> this.pekkoToPlayResp((HttpResponse)pekkoResp), ec));
    }

    public EssentialAction createUnaryAction(Function1<HttpRequest, Future<HttpResponse>> handler, ExecutionContext ec) {
        return this.actionBuilder.async(this.parsers.byteString(), (Function1 & Serializable)req -> ((Future)handler.apply((Object)this.playToPekkoRequest((Request<ByteString>)req))).map((Function1 & Serializable)pekkoResp -> this.pekkoToPlayResp((HttpResponse)pekkoResp), ec));
    }

    public BodyParser<Source<ByteString, ?>> streamBodyParser(ExecutionContext ec) {
        return BodyParser$.MODULE$.apply("stream", (Function1 & Serializable)_$1 -> Accumulator$.MODULE$.source().map((Function1 & Serializable)value -> package$.MODULE$.Right().apply(value), ec));
    }

    public HttpRequest playToPekkoRequest(Request<ByteString> request) {
        HttpEntity.Chunked entity = HttpEntity.Chunked$.MODULE$.fromData((ContentType)GrpcProtocolNative$.MODULE$.contentType(), Source$.MODULE$.single(request.body()));
        return HttpRequest$.MODULE$.apply((HttpMethod)HttpMethods$.MODULE$.getForKey((Object)request.method().toUpperCase()).get(), Uri$.MODULE$.apply(request.uri()), this.playToPekkoHeaders(request), (RequestEntity)entity, (HttpProtocol)HttpProtocols$.MODULE$.getForKey((Object)request.version().toUpperCase()).get());
    }

    public HttpRequest playToPekkoRequestStream(Request<Source<ByteString, ?>> request) {
        HttpEntity.Chunked entity = HttpEntity.Chunked$.MODULE$.fromData((ContentType)GrpcProtocolNative$.MODULE$.contentType(), (Source)request.body());
        return HttpRequest$.MODULE$.apply((HttpMethod)HttpMethods$.MODULE$.getForKey((Object)request.method().toUpperCase()).get(), Uri$.MODULE$.apply(request.uri()), this.playToPekkoHeaders(request), (RequestEntity)entity, (HttpProtocol)HttpProtocols$.MODULE$.getForKey((Object)request.version().toUpperCase()).get());
    }

    public Seq<HttpHeader> playToPekkoHeaders(Request<?> req) {
        return (Seq)Seq$.MODULE$.apply(req.headers().headers()).map((Function1 & Serializable)h -> {
            HttpHeader.ParsingResult parsingResult = HttpHeader$.MODULE$.parse((String)h._1(), (String)h._2(), HttpHeader$.MODULE$.parse$default$3());
            if (parsingResult instanceof HttpHeader.ParsingResult$.Ok) {
                HttpHeader.ParsingResult$.Ok ok = HttpHeader.ParsingResult$.Ok$.MODULE$.unapply((HttpHeader.ParsingResult$.Ok)parsingResult);
                HttpHeader httpHeader = ok._1();
                List list = ok._2();
                HttpHeader header = httpHeader;
                List errors = list;
                return header;
            }
            if (parsingResult instanceof HttpHeader.ParsingResult$.Error) {
                ErrorInfo errorInfo;
                HttpHeader.ParsingResult$.Error error = HttpHeader.ParsingResult$.Error$.MODULE$.unapply((HttpHeader.ParsingResult$.Error)parsingResult);
                ErrorInfo error2 = errorInfo = error._1();
                throw new Exception("header parsing");
            }
            throw new MatchError((Object)parsingResult);
        });
    }

    public Result pekkoToPlayResp(HttpResponse pekkoResp) {
        ResponseEntity responseEntity = pekkoResp.entity();
        if (!(responseEntity instanceof HttpEntity.Chunked)) {
            ResponseEntity e = responseEntity;
            throw new NotImplementedError(new StringBuilder(33).append("Unexpected response entity type: ").append(e.getClass().getName()).toString());
        }
        HttpEntity.Chunked chunked = HttpEntity.Chunked$.MODULE$.unapply((HttpEntity.Chunked)responseEntity);
        ContentType contentType = chunked._1();
        Source source = chunked._2();
        ContentType ct = contentType;
        Source chunks = source;
        Source playChunks = (Source)chunks.map((Function1 & Serializable)x$1 -> {
            HttpChunk.LastChunk lastChunk;
            HttpEntity.ChunkStreamPart chunkStreamPart = x$1;
            if (chunkStreamPart instanceof HttpEntity.LastChunk) {
                Seq seq;
                HttpEntity.LastChunk lastChunk2 = HttpEntity.LastChunk$.MODULE$.unapply((HttpEntity.LastChunk)chunkStreamPart);
                String string = lastChunk2._1();
                Seq trailer = seq = lastChunk2._2();
                lastChunk = HttpChunk.LastChunk$.MODULE$.apply(this.pekkoToPlayHeaders((Seq<HttpHeader>)trailer));
            } else if (chunkStreamPart instanceof HttpEntity.Chunk) {
                HttpEntity.Chunk chunk = HttpEntity.Chunk$.MODULE$.unapply((HttpEntity.Chunk)chunkStreamPart);
                ByteString byteString = chunk._1();
                String string = chunk._2();
                ByteString data = byteString;
                String ext = string;
                lastChunk = HttpChunk.Chunk$.MODULE$.apply(data);
            } else {
                throw new MatchError((Object)chunkStreamPart);
            }
            return (HttpChunk)lastChunk;
        });
        HttpEntity.Chunked playEntity = HttpEntity.Chunked$.MODULE$.apply(playChunks, (Option)Some$.MODULE$.apply((Object)ct.toString()));
        return Result$.MODULE$.apply(this.pekkoToPlayResponseHeaders(pekkoResp), (HttpEntity)playEntity, Result$.MODULE$.$lessinit$greater$default$3(), Result$.MODULE$.$lessinit$greater$default$4(), Result$.MODULE$.$lessinit$greater$default$5(), Result$.MODULE$.$lessinit$greater$default$6());
    }

    public Headers pekkoToPlayHeaders(Seq<HttpHeader> headers) {
        return Headers$.MODULE$.apply((Seq)headers.map((Function1 & Serializable)h -> Tuple2$.MODULE$.apply((Object)h.name(), (Object)h.value())));
    }

    public ResponseHeader pekkoToPlayResponseHeaders(HttpResponse resp) {
        return ResponseHeader$.MODULE$.apply(Status$.MODULE$.OK(), this.pekkoToPlayHeaders((Seq<HttpHeader>)resp.headers()).toSimpleMap(), ResponseHeader$.MODULE$.apply$default$3());
    }
}

