/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache.ehcache;

import com.google.common.primitives.Primitives;
import java.io.Serializable;
import javax.inject.Inject;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import play.api.cache.SyncCacheApi;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class SyncEhCacheApi
implements SyncCacheApi {
    private final Ehcache cache;

    @Inject
    public SyncEhCacheApi(Ehcache cache) {
        this.cache = cache;
    }

    public Ehcache cache() {
        return this.cache;
    }

    public void set(String key, Object value, Duration expiration) {
        Element element = new Element((Object)key, value);
        Duration duration = expiration;
        if (duration instanceof Duration.Infinite) {
            Duration.Infinite infinite = (Duration.Infinite)duration;
            element.setEternal(true);
        } else if (duration instanceof FiniteDuration) {
            FiniteDuration finite = (FiniteDuration)duration;
            long seconds = finite.toSeconds();
            if (seconds <= 0L) {
                element.setTimeToLive(1);
            } else if (seconds > Integer.MAX_VALUE) {
                element.setTimeToLive(Integer.MAX_VALUE);
            } else {
                element.setTimeToLive((int)seconds);
            }
        } else {
            throw new MatchError((Object)duration);
        }
        this.cache().put(element);
    }

    public void remove(String key) {
        this.cache().remove((Serializable)((Object)key));
    }

    public <A> A getOrElseUpdate(String key, Duration expiration, Function0<A> orElse, ClassTag<A> evidence$1) {
        Option<A> option = this.get(key, evidence$1);
        if (option instanceof Some) {
            Object value = ((Some)option).value();
            return (A)value;
        }
        if (None$.MODULE$.equals(option)) {
            Object value = orElse.apply();
            this.set(key, value, expiration);
            return (A)value;
        }
        throw new MatchError(option);
    }

    public <T> Option<T> get(String key, ClassTag<T> ct) {
        return Option$.MODULE$.apply((Object)this.cache().get((Serializable)((Object)key))).map((Function1 & Serializable)_$12 -> _$12.getObjectValue()).filter((Function1 & Serializable)v -> {
            if (Primitives.wrap((Class)ct.runtimeClass()).isInstance(v)) return true;
            ClassTag classTag = ct;
            ClassTag classTag2 = ClassTag$.MODULE$.Nothing();
            if (classTag == null) {
                if (classTag2 == null) return true;
            } else if (classTag.equals(classTag2)) return true;
            ClassTag classTag3 = ct;
            ManifestFactory.UnitManifest unitManifest = ClassTag$.MODULE$.Unit();
            if (classTag3 == null) {
                if (unitManifest != null) {
                    return false;
                }
            } else if (!classTag3.equals(unitManifest)) return false;
            if (!BoxesRunTime.equals((Object)v, (Object)BoxedUnit.UNIT)) return false;
            return true;
        });
    }
}

