/*
 * Decompiled with CFR 0.152.
 */
package play.db.ebean;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import io.ebean.config.DatabaseConfig;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.scanners.TypeElementsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import play.Environment;
import play.Logger;
import play.db.DBApi;
import play.db.ebean.EbeanConfig;
import play.db.ebean.EbeanParsedConfig;

@Singleton
public class DefaultEbeanConfig
implements EbeanConfig {
    private final String defaultServer;
    private final Map<String, DatabaseConfig> serverConfigs;
    private final boolean generateEvolutionsScripts;

    public DefaultEbeanConfig(String string, Map<String, DatabaseConfig> map, boolean bl) {
        this.defaultServer = string;
        this.serverConfigs = map;
        this.generateEvolutionsScripts = bl;
    }

    public DefaultEbeanConfig(String string, Map<String, DatabaseConfig> map) {
        this(string, map, true);
    }

    @Override
    public String defaultServer() {
        return this.defaultServer;
    }

    @Override
    public Map<String, DatabaseConfig> serverConfigs() {
        return this.serverConfigs;
    }

    @Override
    public boolean generateEvolutionsScripts() {
        return this.generateEvolutionsScripts;
    }

    private static class Classpath {
        private Classpath() {
        }

        static Set<String> getTypes(Environment environment, String string) {
            return ((Map)Classpath.getReflections(environment, string).getStore().getOrDefault((Object)TypeElementsScanner.class.getSimpleName(), Collections.emptyMap())).keySet();
        }

        private static Reflections getReflections(Environment environment, String string) {
            return new Reflections((Configuration)Classpath.getReflectionsConfiguration(string, environment.classLoader()));
        }

        private static ConfigurationBuilder getReflectionsConfiguration(String string, ClassLoader classLoader) {
            return new ConfigurationBuilder().addUrls(ClasspathHelper.forPackage((String)string, (ClassLoader[])new ClassLoader[]{classLoader})).filterInputsBy((Predicate)new FilterBuilder().includePackage(string)).setScanners(new Scanner[]{new TypeElementsScanner(), Scanners.TypesAnnotated, Scanners.SubTypes});
        }
    }

    @Singleton
    public static class EbeanConfigParser
    implements Provider<EbeanConfig> {
        private final Config config;
        private final Environment environment;
        private final DBApi dbApi;
        private static final Logger.ALogger LOGGER = Logger.of(DefaultEbeanConfig.class);

        @Inject
        public EbeanConfigParser(Config config, Environment environment, DBApi dBApi) {
            this.config = config;
            this.environment = environment;
            this.dbApi = dBApi;
        }

        public EbeanConfig get() {
            return this.parse();
        }

        public EbeanConfig parse() {
            EbeanParsedConfig ebeanParsedConfig = EbeanParsedConfig.parseFromConfig(this.config);
            HashMap<String, DatabaseConfig> hashMap = new HashMap<String, DatabaseConfig>();
            for (Map.Entry<String, List<String>> entry : ebeanParsedConfig.getDatasourceModels().entrySet()) {
                String string = entry.getKey();
                if (this.dbApi.getDatabase(string) == null) {
                    LOGGER.debug("There is an 'ebean.{}' but no 'db.{}' configuration", new Object[]{string, string});
                    LOGGER.info("Skipping connection for datasource '{}'", new Object[]{string});
                    continue;
                }
                DatabaseConfig databaseConfig = new DatabaseConfig();
                databaseConfig.setName(string);
                databaseConfig.loadFromProperties();
                this.setServerConfigDataSource(string, databaseConfig);
                if (!ebeanParsedConfig.getDefaultDatasource().equals(string)) {
                    databaseConfig.setDefaultServer(false);
                }
                Set<String> set = this.getModelClasses(entry);
                this.addModelClassesToServerConfig(string, databaseConfig, set);
                hashMap.put(string, databaseConfig);
            }
            return new DefaultEbeanConfig(ebeanParsedConfig.getDefaultDatasource(), hashMap, ebeanParsedConfig.generateEvolutionsScripts());
        }

        private void setServerConfigDataSource(String string, DatabaseConfig databaseConfig) {
            try {
                databaseConfig.setDataSource((DataSource)new WrappingDatasource(this.dbApi.getDatabase(string).getDataSource()));
            }
            catch (Exception exception) {
                throw new ConfigException.BadValue("ebean." + string, exception.getMessage(), (Throwable)exception);
            }
        }

        private void addModelClassesToServerConfig(String string, DatabaseConfig databaseConfig, Set<String> set) {
            for (String string2 : set) {
                try {
                    databaseConfig.addClass(Class.forName(string2, true, this.environment.classLoader()));
                }
                catch (Exception exception) {
                    throw new ConfigException.BadValue("ebean." + string, "Cannot register class [" + string2 + "] in Ebean server", (Throwable)exception);
                }
            }
        }

        private Set<String> getModelClasses(Map.Entry<String, List<String>> entry) {
            HashSet<String> hashSet = new HashSet<String>();
            entry.getValue().forEach(string -> {
                if ((string = string.trim()).endsWith(".*")) {
                    hashSet.addAll(Classpath.getTypes(this.environment, string.substring(0, string.length() - 2)));
                } else {
                    hashSet.add((String)string);
                }
            });
            return hashSet;
        }

        static class WrappingDatasource
        implements DataSource {
            final DataSource wrapped;

            public Connection wrap(Connection connection) throws SQLException {
                connection.setAutoCommit(false);
                return connection;
            }

            public WrappingDatasource(DataSource dataSource) {
                this.wrapped = dataSource;
            }

            @Override
            public Connection getConnection() throws SQLException {
                return this.wrap(this.wrapped.getConnection());
            }

            @Override
            public Connection getConnection(String string, String string2) throws SQLException {
                return this.wrap(this.wrapped.getConnection(string, string2));
            }

            @Override
            public int getLoginTimeout() throws SQLException {
                return this.wrapped.getLoginTimeout();
            }

            @Override
            public PrintWriter getLogWriter() throws SQLException {
                return this.wrapped.getLogWriter();
            }

            @Override
            public void setLoginTimeout(int n) throws SQLException {
                this.wrapped.setLoginTimeout(n);
            }

            @Override
            public void setLogWriter(PrintWriter printWriter) throws SQLException {
                this.wrapped.setLogWriter(printWriter);
            }

            @Override
            public boolean isWrapperFor(Class<?> clazz) throws SQLException {
                return this.wrapped.isWrapperFor(clazz);
            }

            @Override
            public <T> T unwrap(Class<T> clazz) throws SQLException {
                return this.wrapped.unwrap(clazz);
            }

            @Override
            public java.util.logging.Logger getParentLogger() {
                return null;
            }
        }
    }
}

