<!--- Copyright (C) from 2022 The Play Framework Contributors <https://github.com/playframework>, 2011-2021 Lightbend Inc. <https://www.lightbend.com> -->

# What is Play?

Play is a high-productivity Java and Scala web application framework that integrates components and APIs for modern web application development. Play was developed by web developers for web application development.

You will find Play's Model-View-Controller (MVC) architecture familiar and easy to learn. Play provides concise and functional programming patterns. And, the large community developing Play applications provides an excellent resource for getting your questions answered.

As a full-stack framework, Play includes all the components you need to build Web Applications and REST services, such as an integrated HTTP server, form handling, Cross-Site Request Forgery (CSRF) protection, a powerful routing mechanism, I18n support, and more. Play saves precious development time by directly supporting everyday tasks and hot reloading so that you can immediately view the results of your work.

Play’s lightweight, stateless, web-friendly architecture uses Pekko and Pekko Streams under the covers to provide predictable and minimal resource consumption (CPU, memory, threads). Thanks to its reactive model, applications scale naturally--both horizontally and vertically.

Play is non-opinionated about database access, and integrates with many object relational mapping (ORM) layers. It supports [[Anorm]], [[Slick|PlaySlick]], and [[JPA|JavaJPA]] out of the box, but many customers use NoSQL or other ORMs.


## See also:

1. The [[Hello World tutorial|HelloWorldTutorial]]
1. Play's [[philosophy and history|Philosophy]].
