/*
 * Decompiled with CFR 0.152.
 */
package play.doc;

import java.io.InputStream;
import java.io.Serializable;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import play.doc.FileHandle;
import play.doc.FileHandle$;
import play.doc.FileRepository;
import play.doc.JarRepository$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public class JarRepository
implements FileRepository {
    private final JarFile jarFile;
    private final Option<String> base;
    private final String PathSeparator;
    private final String basePrefix;

    public static Option<String> $lessinit$greater$default$2() {
        return JarRepository$.MODULE$.$lessinit$greater$default$2();
    }

    public JarRepository(JarFile jarFile, Option<String> base) {
        this.jarFile = jarFile;
        this.base = base;
        this.PathSeparator = "/";
        this.basePrefix = (String)base.map((Function1 & Serializable)_$3 -> _$3 + this.PathSeparator).getOrElse(JarRepository::$init$$$anonfun$2);
    }

    public Option<Tuple2<ZipEntry, InputStream>> getEntry(String path) {
        return Option$.MODULE$.apply((Object)this.jarFile.getEntry(this.basePrefix + path)).flatMap((Function1 & Serializable)entry -> Option$.MODULE$.apply((Object)this.jarFile.getInputStream((ZipEntry)entry)).map((Function1 & Serializable)is -> Tuple2$.MODULE$.apply(entry, is)));
    }

    @Override
    public <A> Option<A> loadFile(String path, Function1<InputStream, A> loader) {
        return this.getEntry(path).filterNot((Function1 & Serializable)_$4 -> ((ZipEntry)_$4._1()).isDirectory()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                InputStream is = (InputStream)tuple2._2();
                return loader.apply((Object)is);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public <A> Option<A> handleFile(String path, Function1<FileHandle, A> handler) {
        return this.getEntry(path).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ZipEntry entry = (ZipEntry)tuple2._1();
                InputStream is = (InputStream)tuple2._2();
                Object object = Predef$.MODULE$.refArrayOps((Object[])entry.getName().split(this.PathSeparator));
                FileHandle handle = FileHandle$.MODULE$.apply((String)ArrayOps$.MODULE$.last$extension(object), entry.getSize(), is, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> is.close());
                return handler.apply((Object)handle);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public Option<String> findFileWithName(String name) {
        String slashName = this.PathSeparator + name;
        Option found = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(this.jarFile.entries()).asScala()).map((Function1 & Serializable)_$5 -> _$5.getName()).find((Function1 & Serializable)n -> JarRepository.startsWith$1(n, this.basePrefix) && JarRepository.endsWith$1(n, slashName));
        return found.map((Function1 & Serializable)_$6 -> _$6.substring(this.basePrefix.length()));
    }

    public void close() {
        this.jarFile.close();
    }

    public String toString() {
        return "JarRepository(jarFile = " + JarRepository.toString$1(this.jarFile) + ", base = " + this.base + ")";
    }

    private static final String $init$$$anonfun$2() {
        return "";
    }

    private static final boolean startsWith$1(String full, String part) {
        if (part.isEmpty()) {
            return true;
        }
        String comparePart = full.length() == part.length() ? full : StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(full), part.length());
        return comparePart.equalsIgnoreCase(part);
    }

    private static final boolean endsWith$1(String full, String part) {
        if (part.isEmpty()) {
            return true;
        }
        String comparePart = full.length() == part.length() ? full : StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(full), part.length());
        return comparePart.equalsIgnoreCase(part);
    }

    private static final String toString$1(JarFile jar) {
        return "JarFile(name = " + jar.getName() + ")";
    }
}

