/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.util.Properties;
import org.slf4j.Logger;
import play.api.ConfigLoader;
import play.api.ConfigLoader$;
import play.api.Configuration$;
import play.api.Environment;
import play.api.PlayException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.io.Codec;
import scala.io.Codec$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scala.util.hashing.MurmurHash3$;

public class Configuration
implements Product,
Serializable {
    private final Config underlying;

    public static Configuration apply(Config config) {
        return Configuration$.MODULE$.apply(config);
    }

    public static Configuration apply(Seq<Tuple2<String, Object>> seq) {
        return Configuration$.MODULE$.apply(seq);
    }

    public static PlayException configError(String string, Option<ConfigOrigin> option, Option<Throwable> option2, Codec codec) {
        return Configuration$.MODULE$.configError(string, option, option2, codec);
    }

    public static Configuration empty() {
        return Configuration$.MODULE$.empty();
    }

    public static Configuration from(Map<String, Object> map) {
        return Configuration$.MODULE$.from(map);
    }

    public static Configuration fromProduct(Product product) {
        return Configuration$.MODULE$.fromProduct(product);
    }

    public static Configuration load(ClassLoader classLoader, Properties properties, Map<String, Object> map, boolean bl) {
        return Configuration$.MODULE$.load(classLoader, properties, map, bl);
    }

    public static Configuration load(Environment environment) {
        return Configuration$.MODULE$.load(environment);
    }

    public static Configuration load(Environment environment, Map<String, Object> map) {
        return Configuration$.MODULE$.load(environment, map);
    }

    public static Logger logger() {
        return Configuration$.MODULE$.logger();
    }

    public static Configuration reference() {
        return Configuration$.MODULE$.reference();
    }

    public static Configuration unapply(Configuration configuration) {
        return Configuration$.MODULE$.unapply(configuration);
    }

    public static Option<ConfigOrigin> configError$default$2() {
        return Configuration$.MODULE$.configError$default$2();
    }

    public static Option<Throwable> configError$default$3() {
        return Configuration$.MODULE$.configError$default$3();
    }

    public Configuration(Config underlying) {
        this.underlying = underlying;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 652995822, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Configuration)) return false;
        Configuration configuration = (Configuration)object;
        Config config = this.underlying();
        Config config2 = configuration.underlying();
        if (config == null) {
            if (config2 != null) {
                return false;
            }
        } else if (!config.equals(config2)) return false;
        if (!configuration.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Configuration;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Configuration";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "underlying";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Config underlying() {
        return this.underlying;
    }

    public void reportDeprecation(String path, String deprecated) {
        ConfigOrigin origin = this.underlying().getValue(deprecated).origin();
        Configuration$.MODULE$.logger().warn(origin.description() + ": " + deprecated + " is deprecated, use " + path + " instead");
    }

    public Configuration $plus$plus(Configuration other) {
        return Configuration$.MODULE$.apply(other.underlying().withFallback((ConfigMergeable)this.underlying()));
    }

    public Configuration withFallback(Configuration other) {
        return Configuration$.MODULE$.apply(this.underlying().withFallback((ConfigMergeable)other.underlying()));
    }

    public boolean has(String path) {
        return this.underlying().hasPath(path);
    }

    public <A> A get(String path, ConfigLoader<A> loader) {
        return loader.load(this.underlying(), path);
    }

    public <A> A getAndValidate(String path, Set<A> values, ConfigLoader<A> loader) {
        A value = this.get(path, loader);
        if (!values.apply(value)) {
            throw this.reportError(path, "Incorrect value, one of (" + values.mkString(", ") + ") was expected.", this.reportError$default$3());
        }
        return value;
    }

    public <A> Option<A> getOptional(String path, ConfigLoader<A> loader) {
        Object object;
        try {
            object = this.underlying().hasPath(path) ? Some$.MODULE$.apply(this.get(path, loader)) : None$.MODULE$;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                throw this.reportError(path, e.getMessage(), (Option<Throwable>)Some$.MODULE$.apply((Object)e));
            }
            throw throwable;
        }
        return object;
    }

    public Seq<Configuration> getPrototypedSeq(String path, String prototypePath) {
        Config prototype = this.underlying().getConfig(prototypePath.replace("$path", path));
        return (Seq)((IterableOps)this.get(path, ConfigLoader$.MODULE$.seqConfigLoader())).map((Function1 & Serializable)config -> Configuration$.MODULE$.apply(config.withFallback((ConfigMergeable)prototype)));
    }

    public String getPrototypedSeq$default$2() {
        return "prototype.$path";
    }

    public Map<String, Configuration> getPrototypedMap(String path, String prototypePath) {
        Config prototype = prototypePath.isEmpty() ? this.underlying() : this.underlying().getConfig(prototypePath.replace("$path", path));
        return (Map)((MapOps)this.get(path, ConfigLoader$.MODULE$.mapLoader(ConfigLoader$.MODULE$.configLoader()))).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Config config = (Config)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Configuration$.MODULE$.apply(config.withFallback((ConfigMergeable)prototype)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String getPrototypedMap$default$2() {
        return "prototype.$path";
    }

    public <A> A getDeprecated(String path, Seq<String> deprecatedPaths, ConfigLoader<A> evidence$1) {
        return (A)deprecatedPaths.collectFirst((PartialFunction)new Serializable(path, evidence$1, this){
            private final String path$1;
            private final ConfigLoader evidence$1$1;
            private final /* synthetic */ Configuration $outer;
            {
                this.path$1 = path$3;
                this.evidence$1$1 = evidence$1$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(String x) {
                String string;
                String deprecated = string = x;
                return this.$outer.underlying().hasPath(deprecated);
            }

            public final Object applyOrElse(String x, Function1 function1) {
                String string;
                String deprecated = string = x;
                if (this.$outer.underlying().hasPath(deprecated)) {
                    this.$outer.reportDeprecation(this.path$1, deprecated);
                    return this.$outer.get(deprecated, this.evidence$1$1);
                }
                return function1.apply((Object)x);
            }
        }).getOrElse(() -> this.getDeprecated$$anonfun$1(path, evidence$1));
    }

    public Configuration getDeprecatedWithFallback(String path, String deprecated, String parent) {
        Config config;
        Config config2 = this.get(path, ConfigLoader$.MODULE$.configLoader());
        if (this.underlying().hasPath(deprecated)) {
            this.reportDeprecation(path, deprecated);
            config = this.get(deprecated, ConfigLoader$.MODULE$.configLoader()).withFallback((ConfigMergeable)config2);
        } else {
            config = config2;
        }
        Config merged = config;
        return Configuration$.MODULE$.apply(merged);
    }

    public String getDeprecatedWithFallback$default$3() {
        return "";
    }

    public long getMillis(String path) {
        return this.get(path, ConfigLoader$.MODULE$.durationLoader()).toMillis();
    }

    public long getNanos(String path) {
        return this.get(path, ConfigLoader$.MODULE$.durationLoader()).toNanos();
    }

    public Set<String> keys() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(this.underlying().entrySet()).asScala().map((Function1 & Serializable)_$4 -> (String)_$4.getKey())).toSet();
    }

    public Set<String> subKeys() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.underlying().root().keySet()).asScala().toSet();
    }

    public Set<Tuple2<String, ConfigValue>> entrySet() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(this.underlying().entrySet()).asScala().map((Function1 & Serializable)e -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(e.getKey());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, e.getValue());
        })).toSet();
    }

    public PlayException reportError(String path, String message, Option<Throwable> e) {
        Option origin = Option$.MODULE$.apply((Object)(this.underlying().hasPath(path) ? this.underlying().getValue(path).origin() : this.underlying().root().origin()));
        return Configuration$.MODULE$.configError(message, (Option<ConfigOrigin>)origin, e, Codec$.MODULE$.fallbackSystemCodec());
    }

    public Option<Throwable> reportError$default$3() {
        return None$.MODULE$;
    }

    public PlayException globalError(String message, Option<Throwable> e) {
        return Configuration$.MODULE$.configError(message, (Option<ConfigOrigin>)Option$.MODULE$.apply((Object)this.underlying().root().origin()), e, Codec$.MODULE$.fallbackSystemCodec());
    }

    public Option<Throwable> globalError$default$2() {
        return None$.MODULE$;
    }

    public Configuration copy(Config underlying) {
        return new Configuration(underlying);
    }

    public Config copy$default$1() {
        return this.underlying();
    }

    public Config _1() {
        return this.underlying();
    }

    private final Object getDeprecated$$anonfun$1(String path$2, ConfigLoader evidence$1$2) {
        return this.get(path$2, evidence$1$2);
    }
}

