/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMemorySize;
import com.typesafe.config.ConfigObject;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import play.api.ConfigLoader;
import play.api.Configuration;
import play.api.Configuration$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class ConfigLoader$
implements Serializable {
    private static final ConfigLoader stringLoader;
    private static final ConfigLoader seqStringLoader;
    private static final ConfigLoader intLoader;
    private static final ConfigLoader seqIntLoader;
    private static final ConfigLoader booleanLoader;
    private static final ConfigLoader seqBooleanLoader;
    private static final ConfigLoader finiteDurationLoader;
    private static final ConfigLoader seqFiniteDurationLoader;
    private static final ConfigLoader durationLoader;
    private static final ConfigLoader seqDurationLoader;
    private static final ConfigLoader javaDurationLoader;
    private static final ConfigLoader javaSeqDurationLoader;
    private static final ConfigLoader periodLoader;
    private static final ConfigLoader temporalLoader;
    private static final ConfigLoader doubleLoader;
    private static final ConfigLoader seqDoubleLoader;
    private static final ConfigLoader numberLoader;
    private static final ConfigLoader seqNumberLoader;
    private static final ConfigLoader longLoader;
    private static final ConfigLoader seqLongLoader;
    private static final ConfigLoader bytesLoader;
    private static final ConfigLoader seqBytesLoader;
    private static final ConfigLoader configLoader;
    private static final ConfigLoader configListLoader;
    private static final ConfigLoader configObjectLoader;
    private static final ConfigLoader seqConfigLoader;
    private static final ConfigLoader configurationLoader;
    private static final ConfigLoader seqConfigurationLoader;
    private static final ConfigLoader urlLoader;
    private static final ConfigLoader uriLoader;
    public static final ConfigLoader$ MODULE$;

    private ConfigLoader$() {
    }

    static {
        MODULE$ = new ConfigLoader$();
        stringLoader = MODULE$.apply((Function1 & Serializable)_$7 -> (Function1 & Serializable)x$0 -> _$7.getString(x$0));
        seqStringLoader = MODULE$.apply((Function1 & Serializable)_$8 -> (Function1 & Serializable)x$0 -> _$8.getStringList(x$0)).map((Function1 & Serializable)_$9 -> CollectionConverters$.MODULE$.ListHasAsScala(_$9).asScala().toSeq());
        intLoader = MODULE$.apply((Function1 & Serializable)_$10 -> (Function1 & Serializable)x$0 -> _$10.getInt(x$0));
        seqIntLoader = MODULE$.apply((Function1 & Serializable)_$11 -> (Function1 & Serializable)x$0 -> _$11.getIntList(x$0)).map((Function1 & Serializable)_$12 -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(_$12).asScala().map((Function1 & Serializable)_$13 -> Predef$.MODULE$.Integer2int(_$13))).toSeq());
        booleanLoader = MODULE$.apply((Function1 & Serializable)_$14 -> (Function1 & Serializable)x$0 -> _$14.getBoolean(x$0));
        seqBooleanLoader = MODULE$.apply((Function1 & Serializable)_$15 -> (Function1 & Serializable)x$0 -> _$15.getBooleanList(x$0)).map((Function1 & Serializable)_$16 -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(_$16).asScala().map((Function1 & Serializable)_$17 -> _$17)).toSeq());
        finiteDurationLoader = MODULE$.apply((Function1 & Serializable)_$18 -> (Function1 & Serializable)x$0 -> _$18.getDuration(x$0)).map((Function1 & Serializable)javaDuration -> this.javaDurationToScala((java.time.Duration)javaDuration));
        seqFiniteDurationLoader = MODULE$.apply((Function1 & Serializable)_$19 -> (Function1 & Serializable)x$0 -> _$19.getDurationList(x$0)).map((Function1 & Serializable)_$20 -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(_$20).asScala().map((Function1 & Serializable)javaDuration -> this.javaDurationToScala((java.time.Duration)javaDuration))).toSeq());
        durationLoader = MODULE$.apply((Function1 & Serializable)config -> (Function1 & Serializable)path -> {
            if (config.getIsNull(path)) {
                return Duration$.MODULE$.Inf();
            }
            String string = config.getString(path);
            String string2 = "infinite";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return Duration$.MODULE$.Inf();
            }
            return (Duration)this.finiteDurationLoader().load((Config)config, (String)path);
        });
        seqDurationLoader = MODULE$.seqFiniteDurationLoader().map((Function1 & Serializable)x -> (Seq)Predef$.MODULE$.identity(x));
        javaDurationLoader = MODULE$.apply((Function1 & Serializable)_$21 -> (Function1 & Serializable)x$0 -> _$21.getDuration(x$0));
        javaSeqDurationLoader = MODULE$.apply((Function1 & Serializable)_$22 -> (Function1 & Serializable)x$0 -> _$22.getDurationList(x$0)).map((Function1 & Serializable)_$23 -> CollectionConverters$.MODULE$.ListHasAsScala(_$23).asScala().toSeq());
        periodLoader = MODULE$.apply((Function1 & Serializable)_$24 -> (Function1 & Serializable)x$0 -> _$24.getPeriod(x$0));
        temporalLoader = MODULE$.apply((Function1 & Serializable)_$25 -> (Function1 & Serializable)x$0 -> _$25.getTemporal(x$0));
        doubleLoader = MODULE$.apply((Function1 & Serializable)_$26 -> (Function1 & Serializable)x$0 -> _$26.getDouble(x$0));
        seqDoubleLoader = MODULE$.apply((Function1 & Serializable)_$27 -> (Function1 & Serializable)x$0 -> _$27.getDoubleList(x$0)).map((Function1 & Serializable)_$28 -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(_$28).asScala().map((Function1 & Serializable)_$29 -> _$29)).toSeq());
        numberLoader = MODULE$.apply((Function1 & Serializable)_$30 -> (Function1 & Serializable)x$0 -> _$30.getNumber(x$0));
        seqNumberLoader = MODULE$.apply((Function1 & Serializable)_$31 -> (Function1 & Serializable)x$0 -> _$31.getNumberList(x$0)).map((Function1 & Serializable)_$32 -> CollectionConverters$.MODULE$.ListHasAsScala(_$32).asScala().toSeq());
        longLoader = MODULE$.apply((Function1 & Serializable)_$33 -> (Function1 & Serializable)x$0 -> _$33.getLong(x$0));
        seqLongLoader = MODULE$.apply((Function1 & Serializable)_$34 -> (Function1 & Serializable)x$0 -> _$34.getLongList(x$0)).map((Function1 & Serializable)_$35 -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(_$35).asScala().map((Function1 & Serializable)_$36 -> _$36)).toSeq());
        bytesLoader = MODULE$.apply((Function1 & Serializable)_$37 -> (Function1 & Serializable)x$0 -> _$37.getMemorySize(x$0));
        seqBytesLoader = MODULE$.apply((Function1 & Serializable)_$38 -> (Function1 & Serializable)x$0 -> _$38.getMemorySizeList(x$0)).map((Function1 & Serializable)_$39 -> CollectionConverters$.MODULE$.ListHasAsScala(_$39).asScala().toSeq());
        configLoader = MODULE$.apply((Function1 & Serializable)_$40 -> (Function1 & Serializable)x$0 -> _$40.getConfig(x$0));
        configListLoader = MODULE$.apply((Function1 & Serializable)_$41 -> (Function1 & Serializable)x$0 -> _$41.getList(x$0));
        configObjectLoader = MODULE$.apply((Function1 & Serializable)_$42 -> (Function1 & Serializable)x$0 -> _$42.getObject(x$0));
        seqConfigLoader = MODULE$.apply((Function1 & Serializable)_$43 -> (Function1 & Serializable)x$0 -> _$43.getConfigList(x$0)).map((Function1 & Serializable)_$44 -> CollectionConverters$.MODULE$.ListHasAsScala(_$44).asScala().toSeq());
        configurationLoader = MODULE$.configLoader().map((Function1 & Serializable)_$45 -> Configuration$.MODULE$.apply((Config)_$45));
        seqConfigurationLoader = MODULE$.seqConfigLoader().map((Function1 & Serializable)_$46 -> (Seq)_$46.map((Function1 & Serializable)_$47 -> Configuration$.MODULE$.apply((Config)_$47)));
        urlLoader = MODULE$.apply((Function1 & Serializable)_$48 -> (Function1 & Serializable)x$0 -> _$48.getString(x$0)).map((Function1 & Serializable)_$49 -> new URI((String)_$49).toURL());
        uriLoader = MODULE$.apply((Function1 & Serializable)_$50 -> (Function1 & Serializable)x$0 -> _$50.getString(x$0)).map((Function1 & Serializable)_$51 -> new URI((String)_$51));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ConfigLoader$.class);
    }

    public <A> ConfigLoader<A> apply(Function1<Config, Function1<String, A>> f) {
        return (_$5, _$6) -> ((Function1)f.apply((Object)_$5)).apply((Object)_$6);
    }

    public ConfigLoader<String> stringLoader() {
        return stringLoader;
    }

    public ConfigLoader<Seq<String>> seqStringLoader() {
        return seqStringLoader;
    }

    public ConfigLoader<Object> intLoader() {
        return intLoader;
    }

    public ConfigLoader<Seq<Object>> seqIntLoader() {
        return seqIntLoader;
    }

    public ConfigLoader<Object> booleanLoader() {
        return booleanLoader;
    }

    public ConfigLoader<Seq<Object>> seqBooleanLoader() {
        return seqBooleanLoader;
    }

    public ConfigLoader<FiniteDuration> finiteDurationLoader() {
        return finiteDurationLoader;
    }

    public ConfigLoader<Seq<FiniteDuration>> seqFiniteDurationLoader() {
        return seqFiniteDurationLoader;
    }

    public ConfigLoader<Duration> durationLoader() {
        return durationLoader;
    }

    public ConfigLoader<Seq<Duration>> seqDurationLoader() {
        return seqDurationLoader;
    }

    public ConfigLoader<java.time.Duration> javaDurationLoader() {
        return javaDurationLoader;
    }

    public ConfigLoader<Seq<java.time.Duration>> javaSeqDurationLoader() {
        return javaSeqDurationLoader;
    }

    public ConfigLoader<Period> periodLoader() {
        return periodLoader;
    }

    public ConfigLoader<TemporalAmount> temporalLoader() {
        return temporalLoader;
    }

    public ConfigLoader<Object> doubleLoader() {
        return doubleLoader;
    }

    public ConfigLoader<Seq<Object>> seqDoubleLoader() {
        return seqDoubleLoader;
    }

    public ConfigLoader<Number> numberLoader() {
        return numberLoader;
    }

    public ConfigLoader<Seq<Number>> seqNumberLoader() {
        return seqNumberLoader;
    }

    public ConfigLoader<Object> longLoader() {
        return longLoader;
    }

    public ConfigLoader<Seq<Object>> seqLongLoader() {
        return seqLongLoader;
    }

    public ConfigLoader<ConfigMemorySize> bytesLoader() {
        return bytesLoader;
    }

    public ConfigLoader<Seq<ConfigMemorySize>> seqBytesLoader() {
        return seqBytesLoader;
    }

    public ConfigLoader<Config> configLoader() {
        return configLoader;
    }

    public ConfigLoader<ConfigList> configListLoader() {
        return configListLoader;
    }

    public ConfigLoader<ConfigObject> configObjectLoader() {
        return configObjectLoader;
    }

    public ConfigLoader<Seq<Config>> seqConfigLoader() {
        return seqConfigLoader;
    }

    public ConfigLoader<Configuration> configurationLoader() {
        return configurationLoader;
    }

    public ConfigLoader<Seq<Configuration>> seqConfigurationLoader() {
        return seqConfigurationLoader;
    }

    public ConfigLoader<URL> urlLoader() {
        return urlLoader;
    }

    public ConfigLoader<URI> uriLoader() {
        return uriLoader;
    }

    private FiniteDuration javaDurationToScala(java.time.Duration javaDuration) {
        return Duration$.MODULE$.fromNanos(javaDuration.toNanos());
    }

    public <A> ConfigLoader<Option<A>> optionLoader(ConfigLoader<A> valueLoader) {
        return (config, path) -> {
            if (config.getIsNull(path)) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply(valueLoader.load(config, path));
        };
    }

    public <A> ConfigLoader<Map<String, A>> mapLoader(ConfigLoader<A> valueLoader) {
        return (config, path) -> {
            ConfigObject obj = config.getObject(path);
            Config conf = obj.toConfig();
            return CollectionConverters$.MODULE$.IteratorHasAsScala(obj.keySet().iterator()).asScala().map((Function1 & Serializable)key -> {
                String path = "\"" + this.escapeEcmaScript((String)key) + "\"";
                String string = (String)Predef$.MODULE$.ArrowAssoc(key);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, valueLoader.load(conf, path));
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        };
    }

    private String escapeEcmaScript(String input) {
        StringBuilder s = new StringBuilder();
        int len = input.length();
        block11: for (int pos = 0; pos < len; ++pos) {
            char c = input.charAt(pos);
            switch (c) {
                case '\'': {
                    StringBuilder stringBuilder = s.append("\\'");
                    continue block11;
                }
                case '\"': {
                    StringBuilder stringBuilder = s.append("\\\"");
                    continue block11;
                }
                case '\\': {
                    StringBuilder stringBuilder = s.append("\\\\");
                    continue block11;
                }
                case '/': {
                    StringBuilder stringBuilder = s.append("\\/");
                    continue block11;
                }
                case '\b': {
                    StringBuilder stringBuilder = s.append("\\b");
                    continue block11;
                }
                case '\n': {
                    StringBuilder stringBuilder = s.append("\\n");
                    continue block11;
                }
                case '\t': {
                    StringBuilder stringBuilder = s.append("\\t");
                    continue block11;
                }
                case '\f': {
                    StringBuilder stringBuilder = s.append("\\f");
                    continue block11;
                }
                case '\r': {
                    StringBuilder stringBuilder = s.append("\\r");
                    continue block11;
                }
                default: {
                    StringBuilder stringBuilder;
                    char c2 = c;
                    if (c2 < ' ') {
                        stringBuilder = BoxedUnit.UNIT;
                        continue block11;
                    }
                    char c3 = c;
                    stringBuilder = s.append(c3);
                    continue block11;
                }
            }
        }
        return s.toString();
    }
}

