/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.Configuration;
import play.api.Environment;
import play.api.Mode;
import play.api.Mode$Test$;
import play.api.PlayException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Codec;
import scala.io.Codec$;
import scala.jdk.CollectionConverters$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Null$;

public final class Configuration$
implements Serializable {
    public static final Configuration$ MODULE$ = new Configuration$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());

    public Configuration load(ClassLoader classLoader, Properties properties, scala.collection.immutable.Map<String, Object> directSettings, boolean allowMissingApplicationConf) {
        Configuration configuration;
        try {
            Config userDefinedProperties = properties == System.getProperties() ? ConfigFactory.empty() : ConfigFactory.parseProperties((Properties)properties);
            Config directConfig = ConfigFactory.parseMap((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(directSettings).asJava());
            Config applicationConfig = (Config)Configuration$.setting$1("config.resource", directSettings, properties).map((Function1 & Serializable)resource -> ConfigFactory.parseResources((ClassLoader)classLoader, (String)resource)).orElse((Function0 & Serializable)() -> Configuration$.setting$1("config.file", directSettings, properties).map((Function1 & Serializable)fileName -> ConfigFactory.parseFileAnySyntax((File)new File((String)fileName)))).getOrElse((Function0 & Serializable)() -> {
                ConfigParseOptions parseOptions = ConfigParseOptions.defaults().setClassLoader(classLoader).setAllowMissing(allowMissingApplicationConf);
                return ConfigFactory.defaultApplication((ConfigParseOptions)parseOptions);
            });
            Config playOverridesConfig = ConfigFactory.parseResources((ClassLoader)classLoader, (String)"play/reference-overrides.conf");
            Config combinedConfig = (Config)new .colon.colon((Object)userDefinedProperties, (List)new .colon.colon((Object)directConfig, (List)new .colon.colon((Object)applicationConfig, (List)new .colon.colon((Object)playOverridesConfig, (List)Nil$.MODULE$)))).reduceLeft((Function2 & Serializable)(x$2, x$3) -> x$2.withFallback((ConfigMergeable)x$3));
            Config resolvedConfig = ConfigFactory.load((ClassLoader)classLoader, (Config)combinedConfig);
            configuration = new Configuration(resolvedConfig);
        }
        catch (ConfigException e) {
            throw this.configError(e.getMessage(), (Option<ConfigOrigin>)Option$.MODULE$.apply((Object)e.origin()), (Option<Throwable>)new Some((Object)e), Codec$.MODULE$.fallbackSystemCodec());
        }
        return configuration;
    }

    public Configuration load(Environment environment, scala.collection.immutable.Map<String, Object> devSettings) {
        Mode mode = environment.mode();
        Mode$Test$ mode$Test$ = Mode$Test$.MODULE$;
        boolean allowMissingApplicationConf = !(mode != null ? !mode.equals(mode$Test$) : mode$Test$ != null);
        return this.load(environment.classLoader(), System.getProperties(), devSettings, allowMissingApplicationConf);
    }

    public Configuration load(Environment environment) {
        return this.load(environment, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
    }

    public Configuration empty() {
        return new Configuration(ConfigFactory.empty());
    }

    public Configuration reference() {
        return new Configuration(ConfigFactory.defaultReference());
    }

    public Configuration from(scala.collection.immutable.Map<String, Object> data) {
        return new Configuration(ConfigFactory.parseMap((java.util.Map)((java.util.Map)Configuration$.toJava$1(data))));
    }

    public Configuration apply(Seq<Tuple2<String, Object>> data) {
        return this.from((scala.collection.immutable.Map<String, Object>)data.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public PlayException configError(String message, Option<ConfigOrigin> origin, Option<Throwable> e, Codec codec) {
        return (PlayException)origin.map((Function1 & Serializable)o -> {
            Integer originLine = Predef$.MODULE$.int2Integer(o.lineNumber());
            String originSourceName = o.filename();
            Option originUrlOpt = Option$.MODULE$.apply((Object)o.url());
            return new PlayException.ExceptionSource(message, e, originLine, originUrlOpt, codec, originSourceName){
                private final Integer originLine$1;
                private final Option originUrlOpt$1;
                private final Codec codec$1;
                private final String originSourceName$1;

                public Integer line() {
                    return this.originLine$1;
                }

                public Null$ position() {
                    return null;
                }

                public String input() {
                    return (String)this.originUrlOpt$1.map((Function1 & Serializable)url -> new String(Configuration$.MODULE$.play$api$Configuration$$readStream(url.openStream()), $this.codec$1.name())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                }

                public String sourceName() {
                    return this.originSourceName$1;
                }

                public String toString() {
                    return "Configuration error: " + this.getMessage();
                }
                {
                    this.originLine$1 = originLine$1;
                    this.originUrlOpt$1 = originUrlOpt$1;
                    this.codec$1 = codec$1;
                    this.originSourceName$1 = originSourceName$1;
                    super("Configuration error", message$1, (Throwable)e$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$input$1(play.api.Configuration$$anon$1 java.net.URL )}, serializedLambda);
                }
            };
        }).getOrElse((Function0 & Serializable)() -> new PlayException("Configuration error", message, (Throwable)e.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public Option<ConfigOrigin> configError$default$2() {
        return None$.MODULE$;
    }

    public Option<Throwable> configError$default$3() {
        return None$.MODULE$;
    }

    public byte[] play$api$Configuration$$readStream(InputStream stream) {
        byte[] byArray;
        try {
            byte[] buffer = new byte[8192];
            int len = stream.read(buffer);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (len != -1) {
                out.write(buffer, 0, len);
                len = stream.read(buffer);
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                this.logger().warn("Error closing stream", (Throwable)e);
            }
            throw throwable;
        }
        byte[] byArray2 = byArray;
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            this.logger().warn("Error closing stream", (Throwable)e);
        }
        return byArray2;
    }

    public Logger logger() {
        return logger;
    }

    public Configuration apply(Config underlying) {
        return new Configuration(underlying);
    }

    public Option<Config> unapply(Configuration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.underlying());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Configuration$.class);
    }

    private static final Option setting$1(String key, scala.collection.immutable.Map directSettings$1, Properties properties$1) {
        return directSettings$1.get((Object)key).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)properties$1.getProperty(key))).map((Function1 & Serializable)x$1 -> x$1.toString());
    }

    private static final Object toJava$1(Object data2) {
        Object object = data2;
        if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)object;
            return CollectionConverters$.MODULE$.MapHasAsJava((Map)map2.view().mapValues((Function1 & Serializable)data -> Configuration$.toJava$1(data)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            return CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)iterable.map((Function1 & Serializable)data -> Configuration$.toJava$1(data))).asJava();
        }
        return object;
    }

    private Configuration$() {
    }
}

