/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache.caffeine;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import play.api.cache.AsyncCacheApi;
import play.api.cache.caffeine.ExpirableCacheValue;
import play.api.cache.caffeine.ExpirableCacheValue$;
import play.api.cache.caffeine.SyncCaffeineCacheApi;
import play.api.libs.streams.Execution;
import play.cache.caffeine.NamedCaffeineCache;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.reflect.ClassTag;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class CaffeineCacheApi
implements AsyncCacheApi {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CaffeineCacheApi.class.getDeclaredField("sync$lzy1"));
    private final NamedCaffeineCache cache;
    private volatile Object sync$lzy1;

    @Inject
    public CaffeineCacheApi(NamedCaffeineCache<Object, Object> cache) {
        this.cache = cache;
    }

    public NamedCaffeineCache<Object, Object> cache() {
        return this.cache;
    }

    public SyncCaffeineCacheApi sync() {
        Object object = this.sync$lzy1;
        if (object instanceof SyncCaffeineCacheApi) {
            return (SyncCaffeineCacheApi)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SyncCaffeineCacheApi)this.sync$lzyINIT1();
    }

    private Object sync$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.sync$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SyncCaffeineCacheApi syncCaffeineCacheApi = null;
                    try {
                        syncCaffeineCacheApi = new SyncCaffeineCacheApi(this.cache());
                        object2 = syncCaffeineCacheApi == null ? LazyVals.NullValue$.MODULE$ : syncCaffeineCacheApi;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.sync$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return syncCaffeineCacheApi;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Future<Done> set(String key, Object value, Duration expiration) {
        this.sync().set(key, value, expiration);
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public <T> Future<Option<T>> get(String key, ClassTag<T> evidence$1) {
        CompletableFuture<Object> resultJFuture = this.cache().getIfPresent(key);
        if (resultJFuture == null) {
            return Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps(resultJFuture);
        return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(completionStage).map((Function1 & Serializable)valueFromCache -> Some$.MODULE$.apply(((ExpirableCacheValue)valueFromCache).value()), (ExecutionContext)Execution.trampoline$.MODULE$);
    }

    public Future<Done> remove(String key) {
        this.sync().remove(key);
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public <A> Future<A> getOrElseUpdate(String key, Duration expiration, Function0<Future<A>> orElse, ClassTag<A> evidence$1) {
        LazyRef lazyRef = new LazyRef();
        CompletableFuture<Object> resultAsJavaFuture = this.cache().get((Object)key, (? super K _$13, ? super Executor _$14) -> CaffeineCacheApi.orElseAsJavaFuture$1(lazyRef, orElse, expiration));
        CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps(resultAsJavaFuture);
        return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(completionStage).map((Function1 & Serializable)_$15 -> ((ExpirableCacheValue)_$15).value(), (ExecutionContext)Execution.trampoline$.MODULE$);
    }

    public Future<Done> removeAll() {
        this.cache().synchronous().invalidateAll();
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private static final CompletableFuture orElseAsJavaFuture$lzyINIT1$1(LazyRef orElseAsJavaFuture$lzy1$1, Function0 orElse$2, Duration expiration$2) {
        CompletableFuture completableFuture;
        LazyRef lazyRef = orElseAsJavaFuture$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (orElseAsJavaFuture$lzy1$1.initialized()) {
                object = orElseAsJavaFuture$lzy1$1.value();
            } else {
                Future future = FutureConverters$.MODULE$.FutureOps(((Future)orElse$2.apply()).map((Function1 & Serializable)_$12 -> ExpirableCacheValue$.MODULE$.apply(_$12, (Option<Duration>)Some$.MODULE$.apply((Object)expiration$2)), (ExecutionContext)Execution.trampoline$.MODULE$));
                object = orElseAsJavaFuture$lzy1$1.initialize(FutureConverters.FutureOps$.MODULE$.asJava$extension(future).toCompletableFuture());
            }
            completableFuture = (CompletableFuture)object;
        }
        return completableFuture;
    }

    private static final CompletableFuture orElseAsJavaFuture$1(LazyRef orElseAsJavaFuture$lzy1$2, Function0 orElse$3, Duration expiration$4) {
        return (CompletableFuture)(orElseAsJavaFuture$lzy1$2.initialized() ? orElseAsJavaFuture$lzy1$2.value() : CaffeineCacheApi.orElseAsJavaFuture$lzyINIT1$1(orElseAsJavaFuture$lzy1$2, orElse$3, expiration$4));
    }
}

