/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.Configuration;
import play.api.Environment;
import play.api.inject.ApplicationLifecycle;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.WSConfigParser;
import play.api.libs.ws.ahc.AhcConfigBuilder;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfigParser;
import play.api.libs.ws.ahc.OptionalAhcHttpCacheProvider;
import play.api.libs.ws.ahc.cache.AhcHttpCache;
import play.api.libs.ws.ahc.cache.CachingAsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClient;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Singleton
@ScalaSignature(bytes="\u0006\u0005M4A!\u0004\b\u00013!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b1B#\t\u000b5\u0003A\u0011\u0001(\t\u0011i\u0003\u0001R1A\u0005\u0002mCq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004c\u0001\u0001\u0006IA\u0018\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019A\u0007\u0001)A\u0005K\"9\u0011\u000e\u0001b\u0001\n\u0013Q\u0007B\u00028\u0001A\u0003%1NA\fBgft7\r\u0013;ua\u000ec\u0017.\u001a8u!J|g/\u001b3fe*\u0011q\u0002E\u0001\u0004C\"\u001c'BA\t\u0013\u0003\t98O\u0003\u0002\u0014)\u0005!A.\u001b2t\u0015\t)b#A\u0002ba&T\u0011aF\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0007\u0001Q\"\u0005\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005!A.\u00198h\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\r=\u0013'.Z2u!\r\u0019\u0003FK\u0007\u0002I)\u0011QEJ\u0001\u0007S:TWm\u0019;\u000b\u0003\u001d\nQA[1wCbL!!\u000b\u0013\u0003\u0011A\u0013xN^5eKJ\u0004\"aK\u001a\u000e\u00031R!!\f\u0018\u0002\u001f\u0005\u001c\u0018P\\2iiR\u00048\r\\5f]RT!a\f\u0019\u0002\u0007=\u0014xM\u0003\u0002\u0010c)\u0011!GF\u0001\u0007g\"\fG-\u001a3\n\u0005Qb#aD!ts:\u001c\u0007\n\u001e;q\u00072LWM\u001c;\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\t\u0003oaj\u0011\u0001F\u0005\u0003sQ\u00111\"\u00128wSJ|g.\\3oi\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"a\u000e\u001f\n\u0005u\"\"!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u000bbaBd\u0017nY1uS>tG*\u001b4fGf\u001cG.\u001a\t\u0003\u0001\nk\u0011!\u0011\u0006\u0003KQI!aQ!\u0003)\u0005\u0003\b\u000f\\5dCRLwN\u001c'jM\u0016\u001c\u0017p\u00197f\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T$\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\b\u0006\u0003P'R+FC\u0001)S!\t\t\u0006!D\u0001\u000f\u0011\u0015!U\u0001q\u0001F\u0011\u0015)T\u00011\u00017\u0011\u0015QT\u00011\u0001<\u0011\u0015qT\u00011\u0001@Q\t)q\u000b\u0005\u0002$1&\u0011\u0011\f\n\u0002\u0007\u0013:TWm\u0019;\u0002\u0007\u001d,G/F\u0001+\u0003998o\u00117jK:$8i\u001c8gS\u001e,\u0012A\u0018\t\u0003?\u0002l\u0011\u0001E\u0005\u0003CB\u0011abV*DY&,g\u000e^\"p]\u001aLw-A\bxg\u000ec\u0017.\u001a8u\u0007>tg-[4!\u0003E\t\u0007nY,t\u00072LWM\u001c;D_:4\u0017nZ\u000b\u0002KB\u0011\u0011KZ\u0005\u0003O:\u0011\u0011#\u00115d/N\u001bE.[3oi\u000e{gNZ5h\u0003I\t\u0007nY,t\u00072LWM\u001c;D_:4\u0017n\u001a\u0011\u0002+\u0005\u001c\u0018P\\2IiR\u00048\t\\5f]R\u001cuN\u001c4jOV\t1\u000e\u0005\u0002,Y&\u0011Q\u000e\f\u0002\u0016\u0003NLhn\u0019%uiB\u001cE.[3oi\u000e{gNZ5h\u0003Y\t7/\u001f8d\u0011R$\bo\u00117jK:$8i\u001c8gS\u001e\u0004\u0003F\u0001\u0001q!\t\u0019\u0013/\u0003\u0002sI\tI1+\u001b8hY\u0016$xN\u001c")
public class AsyncHttpClientProvider
implements Provider<AsyncHttpClient> {
    private AsyncHttpClient get;
    private final Environment environment;
    private final Configuration configuration;
    private final ApplicationLifecycle applicationLifecycle;
    private final ExecutionContext executionContext;
    private final WSClientConfig wsClientConfig;
    private final AhcWSClientConfig ahcWsClientConfig;
    private final AsyncHttpClientConfig asyncHttpClientConfig;
    private volatile boolean bitmap$0;

    private AsyncHttpClient get$lzycompute() {
        AsyncHttpClientProvider asyncHttpClientProvider = this;
        synchronized (asyncHttpClientProvider) {
            if (!this.bitmap$0) {
                DefaultAsyncHttpClient defaultAsyncHttpClient;
                OptionalAhcHttpCacheProvider cacheProvider = new OptionalAhcHttpCacheProvider(this.environment, this.configuration, this.applicationLifecycle, this.executionContext);
                DefaultAsyncHttpClient client = new DefaultAsyncHttpClient(this.asyncHttpClientConfig());
                Option<AhcHttpCache> option = cacheProvider.get();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AhcHttpCache ahcHttpCache = (AhcHttpCache)some.value();
                    defaultAsyncHttpClient = new CachingAsyncHttpClient((AsyncHttpClient)client, ahcHttpCache);
                } else if (None$.MODULE$.equals(option)) {
                    defaultAsyncHttpClient = client;
                } else {
                    throw new MatchError(option);
                }
                this.get = defaultAsyncHttpClient;
                this.bitmap$0 = true;
            }
        }
        return this.get;
    }

    public AsyncHttpClient get() {
        if (!this.bitmap$0) {
            return this.get$lzycompute();
        }
        return this.get;
    }

    private WSClientConfig wsClientConfig() {
        return this.wsClientConfig;
    }

    private AhcWSClientConfig ahcWsClientConfig() {
        return this.ahcWsClientConfig;
    }

    private AsyncHttpClientConfig asyncHttpClientConfig() {
        return this.asyncHttpClientConfig;
    }

    @Inject
    public AsyncHttpClientProvider(Environment environment, Configuration configuration, ApplicationLifecycle applicationLifecycle, ExecutionContext executionContext) {
        this.environment = environment;
        this.configuration = configuration;
        this.applicationLifecycle = applicationLifecycle;
        this.executionContext = executionContext;
        this.wsClientConfig = new WSConfigParser(configuration.underlying(), environment.classLoader()).parse();
        this.ahcWsClientConfig = new AhcWSClientConfigParser(this.wsClientConfig(), configuration.underlying(), environment.classLoader()).parse();
        this.asyncHttpClientConfig = new AhcConfigBuilder(this.ahcWsClientConfig()).build();
        applicationLifecycle.addStopHook((Function0 & Serializable)() -> {
            this.get().close();
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        });
    }
}

