/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import java.time.ZonedDateTime;
import org.playframework.cachecontrol.Cache;
import org.playframework.cachecontrol.CacheDirective;
import org.playframework.cachecontrol.CacheDirectives;
import org.playframework.cachecontrol.CacheDirectives$;
import org.playframework.cachecontrol.CacheDirectives$SMaxAge$;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.CacheResponse;
import org.playframework.cachecontrol.HeaderName;
import org.playframework.cachecontrol.HeaderNames$;
import org.playframework.cachecontrol.HttpDate$;
import org.playframework.cachecontrol.Seconds;
import org.playframework.cachecontrol.Seconds$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;

public class FreshnessCalculator {
    private final Cache cache;
    private final Logger logger;

    public FreshnessCalculator(Cache cache) {
        this.cache = cache;
        this.logger = LoggerFactory.getLogger((String)"org.playframework.cachecontrol.FreshnessCalculator");
    }

    public Seconds calculateFreshnessLifetime(CacheRequest request, CacheResponse response) {
        None$ none$;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("calculateFreshnessLifetime: ");
        }
        if (this.isFreshnessInformationInvalid(request, response)) {
            none$ = None$.MODULE$;
        } else {
            Option freshnessLifetime = this.calculateFreshnessFromSMaxAge(request, response).orElse(() -> this.$anonfun$1(request, response)).orElse(() -> this.$anonfun$2(request, response)).orElse(() -> this.$anonfun$3(request, response));
            this.logger.debug("calculateFreshnessLifetime: freshnessLifetime = " + freshnessLifetime);
            none$ = freshnessLifetime;
        }
        None$ maybeResult = none$;
        Seconds result = (Seconds)maybeResult.getOrElse(FreshnessCalculator::$anonfun$4);
        this.logger.debug("calculateFreshnessLifetime: result = " + result);
        return result;
    }

    public boolean isFreshnessInformationInvalid(CacheRequest request, CacheResponse response) {
        Map<HeaderName, Seq<String>> responseHeaders = response.headers();
        Seq<CacheDirective> directives = response.directives();
        if (responseHeaders.get((Object)HeaderNames$.MODULE$.Expires()).exists((Function1 & Serializable)_$1 -> _$1.size() > 1)) {
            this.logger.debug("isFreshnessInformationInvalid: duplicate Expires headers found, returning true");
            return true;
        }
        if (this.containsDuplicates(directives, this.containsDuplicates$default$2())) {
            this.logger.debug("isFreshnessInformationInvalid: duplicate directives found in " + directives + ", returning true");
            return true;
        }
        return false;
    }

    private boolean containsDuplicates(Seq<CacheDirective> directives, Set<Class<?>> seen) {
        List list;
        while ((list = directives) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            CacheDirective x = (CacheDirective)colon2.head();
            List xs = list2;
            if (seen.contains(x.getClass())) {
                return true;
            }
            List list3 = xs;
            Set set = (Set)seen.$plus(x.getClass());
            directives = list3;
            seen = set;
        }
        return false;
    }

    private Set<Class<?>> containsDuplicates$default$2() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[0]));
    }

    public Option<Seconds> calculateFreshnessFromSMaxAge(CacheRequest request, CacheResponse response) {
        if (this.cache.isShared()) {
            return CacheDirectives$.MODULE$.sMaxAge(response.directives()).map((Function1 & Serializable)_$2 -> _$2.delta());
        }
        return None$.MODULE$;
    }

    public Option<Seconds> calculateFreshnessFromMaxAge(CacheRequest request, CacheResponse response) {
        return CacheDirectives$.MODULE$.maxAge(response.directives()).map((Function1 & Serializable)_$3 -> _$3.delta());
    }

    public Option<Seconds> calculateFreshnessFromExpires(CacheRequest request, CacheResponse response) {
        Map<HeaderName, Seq<String>> headers = response.headers();
        return headers.get((Object)HeaderNames$.MODULE$.Expires()).flatMap((Function1 & Serializable)expiresList -> {
            None$ none$;
            String dateString = (String)((IterableOps)headers.getOrElse((Object)HeaderNames$.MODULE$.Date(), FreshnessCalculator::$anonfun$5)).head();
            try {
                ZonedDateTime expires = HttpDate$.MODULE$.parse((String)expiresList.head());
                ZonedDateTime date = HttpDate$.MODULE$.parse(dateString);
                Seconds expiresDuration = HttpDate$.MODULE$.diff(date, expires);
                this.logger.debug("calculateFreshnessFromExpires: expiresDuration = " + expiresDuration);
                none$ = Some$.MODULE$.apply((Object)expiresDuration);
            }
            catch (Exception e) {
                this.logger.error("calculateFreshnessFromExpires: HTTP date parsing failed", (Throwable)e);
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    public Option<Seconds> calculateFreshnessFromHeuristic(CacheRequest request, CacheResponse response) {
        return this.cache.calculateFreshnessFromHeuristic(request, response);
    }

    public Option<Seconds> unapplySeq(Seq<CacheDirective> directives) {
        Seq<CacheDirective> seq = directives;
        if (seq instanceof .colon.colon) {
            CacheDirective cacheDirective = (CacheDirective)((.colon.colon)seq).head();
            List list = ((.colon.colon)seq).next$access$1();
            if (cacheDirective instanceof CacheDirectives.SMaxAge) {
                Seconds seconds;
                CacheDirectives.SMaxAge sMaxAge = CacheDirectives$SMaxAge$.MODULE$.unapply((CacheDirectives.SMaxAge)cacheDirective);
                Seconds delta = seconds = sMaxAge._1();
                return Some$.MODULE$.apply((Object)delta);
            }
        }
        return None$.MODULE$;
    }

    private final Option $anonfun$1(CacheRequest request$1, CacheResponse response$1) {
        return this.calculateFreshnessFromMaxAge(request$1, response$1);
    }

    private final Option $anonfun$2(CacheRequest request$2, CacheResponse response$2) {
        return this.calculateFreshnessFromExpires(request$2, response$2);
    }

    private final Option $anonfun$3(CacheRequest request$3, CacheResponse response$3) {
        return this.calculateFreshnessFromHeuristic(request$3, response$3);
    }

    private static final Seconds $anonfun$4() {
        return Seconds$.MODULE$.ZERO();
    }

    private static final Seq $anonfun$5() {
        throw new RuntimeException("No Date header found!");
    }
}

