/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.plugin.ClientClasspathPlugin;
import org.pitest.util.Log;
import org.pitest.util.PitError;
import org.pitest.util.StringUtil;

public class DependencyFilter
implements Predicate<Artifact> {
    private final Set<GroupIdPair> groups = new HashSet<GroupIdPair>();

    public DependencyFilter(PluginServices plugins) {
        List runtimePlugins = plugins.findClientClasspathPlugins();
        FCollection.mapTo((Iterable)runtimePlugins, DependencyFilter.artifactToPair(), this.groups);
        this.findVendorIdForGroups();
    }

    private static Function<ClientClasspathPlugin, GroupIdPair> artifactToPair() {
        return new Function<ClientClasspathPlugin, GroupIdPair>(){

            @Override
            public GroupIdPair apply(ClientClasspathPlugin a) {
                Package p = a.getClass().getPackage();
                GroupIdPair g = new GroupIdPair(p.getImplementationVendor(), p.getImplementationTitle());
                if (g.id == null) {
                    this.reportBadPlugin("title", a);
                }
                if (g.group == null) {
                    this.reportBadPlugin("vendor", a);
                }
                return g;
            }

            private void reportBadPlugin(String missingProperty, ClientClasspathPlugin a) {
                Class<?> clss = a.getClass();
                throw new PitError("No implementation " + missingProperty + " in manifest of plugin jar for " + clss + " in " + clss.getProtectionDomain().getCodeSource().getLocation());
            }
        };
    }

    private void findVendorIdForGroups() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> urls = loader.getResources("META-INF/MANIFEST.MF");
            while (urls.hasMoreElements()) {
                GroupIdPair query;
                URL url = urls.nextElement();
                Manifest manifest = new Manifest(url.openStream());
                Attributes attributes = manifest.getMainAttributes();
                String vendor = attributes.getValue("Implementation-Vendor");
                String vendorId = attributes.getValue("Implementation-Vendor-Id");
                String id = attributes.getValue("Implementation-Title");
                if (StringUtil.isNullOrEmpty((String)vendor) || StringUtil.isNullOrEmpty((String)vendorId) || StringUtil.isNullOrEmpty((String)id) || !this.groups.contains(query = new GroupIdPair(vendor, id))) continue;
                this.groups.remove(query);
                this.groups.add(new GroupIdPair(vendorId, id));
            }
        }
        catch (IOException exc) {
            Log.getLogger().fine("An exception was thrown while looking for manifest files. Message: " + exc.getMessage());
        }
    }

    @Override
    public boolean test(Artifact a) {
        GroupIdPair p = new GroupIdPair(a.getGroupId(), a.getArtifactId());
        return this.groups.contains(p);
    }

    private static class GroupIdPair {
        private final String group;
        private final String id;

        GroupIdPair(String group, String id) {
            this.group = group;
            this.id = id;
        }

        public int hashCode() {
            return Objects.hash(this.group, this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GroupIdPair other = (GroupIdPair)obj;
            return Objects.equals(this.group, other.group) && Objects.equals(this.id, other.id);
        }
    }
}

