/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.mutationtest.build.intercept.Region;
import org.pitest.mutationtest.build.intercept.RegionInterceptor;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotWrite;

public class AssertFilter
extends RegionInterceptor {
    static final Slot<AbstractInsnNode> START = Slot.create(AbstractInsnNode.class);
    static final Slot<LabelNode> END = Slot.create(LabelNode.class);
    static final SequenceMatcher<AbstractInsnNode> ASSERT_GET = QueryStart.any(AbstractInsnNode.class).then(AssertFilter.getStatic("$assertionsDisabled").and(AssertFilter.store(START.write()))).then(OpcodeMatchers.IFNE.and(InstructionMatchers.jumpsTo(END.write()))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()));

    private static Match<AbstractInsnNode> getStatic(String name) {
        return (c, n) -> {
            if (n instanceof FieldInsnNode) {
                return Result.result(((FieldInsnNode)n).name.equals(name), c);
            }
            return Result.result(false, c);
        };
    }

    private static Match<AbstractInsnNode> store(SlotWrite<AbstractInsnNode> slot) {
        return (c, n) -> Result.result(true, c.store(slot, n));
    }

    @Override
    protected List<Region> computeRegions(MethodTree method) {
        Context context = Context.start();
        List<Region> regions = ASSERT_GET.contextMatches(method.instructions(), context).stream().map(c -> new Region(c.retrieve(START.read()).get(), c.retrieve(END.read()).get())).collect(Collectors.toList());
        return regions;
    }
}

