/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class EnumFilter
implements MutationInterceptor {
    private boolean isEnum;
    private ClassTree currentClass;

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.isEnum = clazz.rawNode().superName.equals("java/lang/Enum");
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (this.isEnum) {
            return mutations.stream().filter(this.makeMethodFilter(this.currentClass).negate()).collect(Collectors.toList());
        }
        return mutations;
    }

    private Predicate<MutationDetails> makeMethodFilter(ClassTree currentClass) {
        Location valueOf = Location.location((ClassName)currentClass.name(), (String)"valueOf", (String)("(Ljava/lang/String;)L" + currentClass.name().asInternalName() + ";"));
        Location values = Location.location((ClassName)currentClass.name(), (String)"values", (String)("()[L" + currentClass.name().asInternalName() + ";"));
        return m -> this.isInEnumConstructor((MutationDetails)m) || m.getId().getLocation().equals((Object)valueOf) || m.getId().getLocation().equals((Object)values);
    }

    private boolean isInEnumConstructor(MutationDetails m) {
        return m.getMethod().equals("<init>");
    }

    @Override
    public void end() {
        this.isEnum = false;
        this.currentClass = null;
    }
}

