/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.mutationtest.build.intercept.Region;
import org.pitest.mutationtest.build.intercept.RegionInterceptor;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;

public class TryWithResourcesFilter
extends RegionInterceptor {
    private static final boolean DEBUG = false;
    private static final Slot<List<LabelNode>> HANDLERS = Slot.createList(LabelNode.class);
    private static final Slot<AbstractInsnNode> START = Slot.create(AbstractInsnNode.class);
    private static final Slot<AbstractInsnNode> END = Slot.create(AbstractInsnNode.class);
    private static final SequenceMatcher<AbstractInsnNode> TRY_WITH_RESOURCES = TryWithResourcesFilter.javac11().or(TryWithResourcesFilter.javac()).or(TryWithResourcesFilter.ecj()).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction().or(TryWithResourcesFilter.aLabel().and(TryWithResourcesFilter.isLabel(HANDLERS.read()).negate()))).withDebug(false));

    private static SequenceQuery<AbstractInsnNode> javac11() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.closeSequence(true)).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.isLabel(HANDLERS.read()).and(InstructionMatchers.debug("handler"))).then(OpcodeMatchers.ASTORE).then(OpcodeMatchers.ALOAD).then(TryWithResourcesFilter.closeSequence(false)).then(OpcodeMatchers.GOTO).then(TryWithResourcesFilter.isLabel(HANDLERS.read()).and(InstructionMatchers.debug("handler"))).then(OpcodeMatchers.ASTORE).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ALOAD).then(TryWithResourcesFilter.addSuppressedMethodCall().and(InstructionMatchers.debug("add suppressed"))).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ATHROW.and(TryWithResourcesFilter.recordPoint(END, true))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> javac() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.javacCloseSequence(true)).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.isLabel(HANDLERS.read()).and(InstructionMatchers.debug("handler"))).then(OpcodeMatchers.ASTORE).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ASTORE).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ATHROW).then(OpcodeMatchers.ASTORE).then(TryWithResourcesFilter.javacCloseSequence(false)).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ATHROW.and(TryWithResourcesFilter.recordPoint(END, true))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> ecj() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.ecjCloseSequence(true)).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.ecjCloseAndThrow()).zeroOrMore(TryWithResourcesFilter.ecjCloseSuppress()).then(TryWithResourcesFilter.ecjSuppress()).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ATHROW.and(TryWithResourcesFilter.recordPoint(END, true))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> ecjCloseSuppress() {
        return TryWithResourcesFilter.ecjCloseSequence(false).then(OpcodeMatchers.GOTO).then(TryWithResourcesFilter.ecjSuppress()).then(TryWithResourcesFilter.ecjCloseAndThrow());
    }

    private static SequenceQuery<AbstractInsnNode> ecjSuppress() {
        return QueryStart.match(OpcodeMatchers.ASTORE).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.IFNONNULL).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ASTORE).then(OpcodeMatchers.GOTO).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.IF_ACMPEQ).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ALOAD).then(TryWithResourcesFilter.addSuppressedMethodCall());
    }

    private static SequenceQuery<AbstractInsnNode> ecjCloseSequence(boolean record) {
        return QueryStart.match(OpcodeMatchers.ALOAD.and(TryWithResourcesFilter.recordPoint(START, record))).then(OpcodeMatchers.IFNULL).then(OpcodeMatchers.ALOAD).then(TryWithResourcesFilter.closeMethodCall());
    }

    private static SequenceQuery<AbstractInsnNode> ecjCloseAndThrow() {
        return QueryStart.match(OpcodeMatchers.ALOAD).then(OpcodeMatchers.IFNULL).then(OpcodeMatchers.ALOAD).then(TryWithResourcesFilter.closeMethodCall()).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ATHROW);
    }

    private static SequenceQuery<AbstractInsnNode> javacCloseSequence(boolean record) {
        return TryWithResourcesFilter.methodSequence(record).or(TryWithResourcesFilter.fullSequence(record)).or(TryWithResourcesFilter.omittedNullCheckSequence(record)).or(TryWithResourcesFilter.optimalSequence(record));
    }

    private static SequenceQuery<AbstractInsnNode> methodSequence(boolean record) {
        return QueryStart.match(OpcodeMatchers.ALOAD.and(TryWithResourcesFilter.recordPoint(START, record))).then(OpcodeMatchers.IFNULL).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ALOAD).then(TryWithResourcesFilter.closeResourceMethodCall());
    }

    private static SequenceQuery<AbstractInsnNode> fullSequence(boolean record) {
        return QueryStart.match(OpcodeMatchers.ALOAD.and(TryWithResourcesFilter.recordPoint(START, record))).then(OpcodeMatchers.IFNULL).then(TryWithResourcesFilter.omittedNullCheckSequence(false));
    }

    private static SequenceQuery<AbstractInsnNode> omittedNullCheckSequence(boolean record) {
        return QueryStart.match(OpcodeMatchers.ALOAD.and(TryWithResourcesFilter.recordPoint(START, record))).then(OpcodeMatchers.IFNULL).then(OpcodeMatchers.ALOAD).then(TryWithResourcesFilter.closeMethodCall()).then(OpcodeMatchers.GOTO.and(InstructionMatchers.debug("goto"))).then(TryWithResourcesFilter.isLabel(HANDLERS.read()).and(InstructionMatchers.debug("handler"))).then(OpcodeMatchers.ASTORE.and(InstructionMatchers.debug("store"))).then(OpcodeMatchers.ALOAD).then(OpcodeMatchers.ALOAD).then(TryWithResourcesFilter.addSuppressedMethodCall()).then(OpcodeMatchers.GOTO).then(OpcodeMatchers.ALOAD).then(TryWithResourcesFilter.closeMethodCall().and(InstructionMatchers.debug("end of sequence")));
    }

    private static SequenceQuery<AbstractInsnNode> optimalSequence(boolean record) {
        return QueryStart.match(OpcodeMatchers.ALOAD.and(TryWithResourcesFilter.recordPoint(START, record))).then(OpcodeMatchers.ALOAD).then(TryWithResourcesFilter.closeResourceMethodCall());
    }

    private static SequenceQuery<AbstractInsnNode> closeSequence(boolean record) {
        return QueryStart.match(TryWithResourcesFilter.closeMethodCall().and(TryWithResourcesFilter.recordPoint(START, record))).or(QueryStart.match(OpcodeMatchers.IFNULL.and(TryWithResourcesFilter.recordPoint(START, record))).then(OpcodeMatchers.ALOAD).then(TryWithResourcesFilter.closeMethodCall()));
    }

    @Override
    protected List<Region> computeRegions(MethodTree method) {
        if (method.rawNode().tryCatchBlocks.size() <= 1) {
            return Collections.emptyList();
        }
        List handlers = method.rawNode().tryCatchBlocks.stream().filter(t -> "java/lang/Throwable".equals(t.type)).filter(t -> t.handler != null).map(t -> t.handler).collect(Collectors.toList());
        Context context = Context.start(false);
        context = context.store(HANDLERS.write(), handlers);
        return TRY_WITH_RESOURCES.contextMatches(method.instructions(), context).stream().map(c -> new Region(c.retrieve(START.read()).get(), c.retrieve(END.read()).get())).collect(Collectors.toList());
    }

    private static Match<AbstractInsnNode> aLabel() {
        return InstructionMatchers.isA(LabelNode.class);
    }

    private static Match<AbstractInsnNode> isLabel(SlotRead<List<LabelNode>> read) {
        return TryWithResourcesFilter.aLabel().and((c, t) -> Result.result(((List)c.retrieve(read).get()).contains(t), c));
    }

    private static Match<AbstractInsnNode> closeMethodCall() {
        return InstructionMatchers.methodCallNamed("close").and(OpcodeMatchers.INVOKEINTERFACE.or(OpcodeMatchers.INVOKEVIRTUAL)).and(InstructionMatchers.methodDescEquals("()V"));
    }

    private static Match<AbstractInsnNode> closeResourceMethodCall() {
        return InstructionMatchers.methodCallNamed("$closeResource").and(InstructionMatchers.methodDescEquals("(Ljava/lang/Throwable;Ljava/lang/AutoCloseable;)V"));
    }

    private static Match<AbstractInsnNode> addSuppressedMethodCall() {
        return InstructionMatchers.methodCallNamed("addSuppressed").and(InstructionMatchers.methodDescEquals("(Ljava/lang/Throwable;)V"));
    }

    private static Match<AbstractInsnNode> recordPoint(Slot<AbstractInsnNode> slot, boolean record) {
        if (!record) {
            return (c, t) -> Result.result(true, c);
        }
        return InstructionMatchers.writeNodeToSlot(slot.write(), AbstractInsnNode.class);
    }
}

