/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.commandline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.util.KeyValuePair;
import org.pitest.classpath.ClassPath;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.commandline.ParseResult;
import org.pitest.mutationtest.config.ConfigOption;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.util.Glob;
import org.pitest.util.Log;
import org.pitest.util.Unchecked;

public class OptionsParser {
    private final Predicate<String> dependencyFilter;
    private static final Logger LOG = Log.getLogger();
    private final OptionParser parser;
    private final ArgumentAcceptingOptionSpec<String> reportDirSpec;
    private final OptionSpec<String> targetClassesSpec;
    private final OptionSpec<String> targetTestsSpec;
    private final OptionSpec<String> avoidCallsSpec;
    private final OptionSpec<Integer> depth;
    private final OptionSpec<Integer> threadsSpec;
    private final OptionSpec<File> sourceDirSpec;
    private final OptionSpec<File> historyOutputSpec;
    private final OptionSpec<File> historyInputSpec;
    private final OptionSpec<String> mutators;
    private final OptionSpec<String> features;
    private final OptionSpec<String> jvmArgs;
    private final OptionSpec<Float> timeoutFactorSpec;
    private final OptionSpec<Long> timeoutConstSpec;
    private final OptionSpec<String> excludedMethodsSpec;
    private final ArgumentAcceptingOptionSpec<Boolean> verboseSpec;
    private final OptionSpec<String> excludedClassesSpec;
    private final OptionSpec<String> excludedTestClassesSpec;
    private final OptionSpec<String> outputFormatSpec;
    private final OptionSpec<String> additionalClassPathSpec;
    private final OptionSpec<File> classPathFile;
    private final ArgumentAcceptingOptionSpec<Boolean> failWhenNoMutations;
    private final ArgumentAcceptingOptionSpec<Boolean> skipFailingTests;
    private final ArgumentAcceptingOptionSpec<String> codePaths;
    private final OptionSpec<String> excludedGroupsSpec;
    private final OptionSpec<String> includedGroupsSpec;
    private final OptionSpec<String> includedTestMethodsSpec;
    private final OptionSpec<Boolean> fullMutationMatrixSpec;
    private final OptionSpec<Integer> mutationUnitSizeSpec;
    private final ArgumentAcceptingOptionSpec<Boolean> timestampedReportsSpec;
    private final ArgumentAcceptingOptionSpec<Boolean> detectInlinedCode;
    private final ArgumentAcceptingOptionSpec<Integer> mutationThreshHoldSpec;
    private final ArgumentAcceptingOptionSpec<Integer> coverageThreshHoldSpec;
    private final ArgumentAcceptingOptionSpec<Integer> maxSurvivingSpec;
    private final OptionSpec<String> mutationEngine;
    private final ArgumentAcceptingOptionSpec<Boolean> exportLineCoverageSpec;
    private final OptionSpec<String> javaExecutable;
    private final OptionSpec<KeyValuePair> pluginPropertiesSpec;
    private final OptionSpec<String> testPluginSpec;
    private final ArgumentAcceptingOptionSpec<Boolean> includeLaunchClasspathSpec;
    private final ArgumentAcceptingOptionSpec<Boolean> useClasspathJarSpec;

    public OptionsParser(Predicate<String> dependencyFilter) {
        this.dependencyFilter = dependencyFilter;
        this.parser = new OptionParser();
        this.parser.acceptsAll(Arrays.asList("h", "?"), "show help");
        this.testPluginSpec = this.parserAccepts(ConfigOption.TEST_PLUGIN).withRequiredArg().ofType(String.class).defaultsTo("junit", (String[])new String[0]).describedAs("test plugin to use");
        this.reportDirSpec = this.parserAccepts(ConfigOption.REPORT_DIR).withRequiredArg().describedAs("directory to create report folder in").required();
        this.targetClassesSpec = this.parserAccepts(ConfigOption.TARGET_CLASSES).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of filters to match against classes to test").required();
        this.avoidCallsSpec = this.parserAccepts(ConfigOption.AVOID_CALLS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of packages to consider as untouchable logging calls");
        this.targetTestsSpec = this.parserAccepts(ConfigOption.TEST_FILTER).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of filters to match against tests to run");
        this.depth = this.parserAccepts(ConfigOption.DEPENDENCY_DISTANCE).withRequiredArg().ofType(Integer.class).defaultsTo((Integer)ConfigOption.DEPENDENCY_DISTANCE.getDefault(Integer.class), (Integer[])new Integer[0]).describedAs("maximum distance to look from test for covered classes");
        this.threadsSpec = this.parserAccepts(ConfigOption.THREADS).withRequiredArg().ofType(Integer.class).defaultsTo((Integer)ConfigOption.THREADS.getDefault(Integer.class), (Integer[])new Integer[0]).describedAs("number of threads to use for testing");
        this.parserAccepts(ConfigOption.MAX_MUTATIONS_PER_CLASS).withRequiredArg().ofType(Integer.class).defaultsTo((Integer)ConfigOption.MAX_MUTATIONS_PER_CLASS.getDefault(Integer.class), (Integer[])new Integer[0]).describedAs("No longer supported. Use CLASSLIMIT(limit[42]) feature instead");
        this.sourceDirSpec = this.parserAccepts(ConfigOption.SOURCE_DIR).withRequiredArg().ofType(File.class).withValuesSeparatedBy(',').describedAs("comma separated list of source directories").required();
        this.mutators = this.parserAccepts(ConfigOption.MUTATIONS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of mutation operators");
        this.features = this.parserAccepts(ConfigOption.FEATURES).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of features to enable/disable.");
        this.jvmArgs = this.parserAccepts(ConfigOption.CHILD_JVM).withRequiredArg().withValuesSeparatedBy(',').describedAs("comma separated list of child JVM args");
        this.detectInlinedCode = this.parserAccepts(ConfigOption.USE_INLINED_CODE_DETECTION).withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]).describedAs("whether or not to try and detect code inlined from finally blocks");
        this.timestampedReportsSpec = this.parserAccepts(ConfigOption.TIME_STAMPED_REPORTS).withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]).describedAs("whether or not to generated timestamped directories");
        this.timeoutFactorSpec = this.parserAccepts(ConfigOption.TIMEOUT_FACTOR).withOptionalArg().ofType(Float.class).describedAs("factor to apply to calculate maximum test duration").defaultsTo((Float)ConfigOption.TIMEOUT_FACTOR.getDefault(Float.class), (Float[])new Float[0]);
        this.timeoutConstSpec = this.parserAccepts(ConfigOption.TIMEOUT_CONST).withOptionalArg().ofType(Long.class).describedAs("constant to apply to calculate maximum test duration").defaultsTo((Long)ConfigOption.TIMEOUT_CONST.getDefault(Long.class), (Long[])new Long[0]);
        this.excludedMethodsSpec = this.parserAccepts(ConfigOption.EXCLUDED_METHOD).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of filters to match against methods to exclude from mutation analysis");
        this.excludedClassesSpec = this.parserAccepts(ConfigOption.EXCLUDED_CLASSES).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of globs for classes to exclude when mutating");
        this.excludedTestClassesSpec = this.parserAccepts(ConfigOption.EXCLUDED_TEST_CLASSES).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of globs of test classes to exclude");
        this.verboseSpec = this.parserAccepts(ConfigOption.VERBOSE).withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]).describedAs("whether or not to generate verbose output");
        this.exportLineCoverageSpec = this.parserAccepts(ConfigOption.EXPORT_LINE_COVERAGE).withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]).describedAs("whether or not to dump per test line coverage data to disk");
        this.useClasspathJarSpec = this.parserAccepts(ConfigOption.USE_CLASSPATH_JAR).withOptionalArg().ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]).describedAs("support large classpaths by creating a classpath jar");
        this.includeLaunchClasspathSpec = this.parserAccepts(ConfigOption.INCLUDE_LAUNCH_CLASSPATH).withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]).describedAs("whether or not to analyse launch classpath");
        this.outputFormatSpec = this.parserAccepts(ConfigOption.OUTPUT_FORMATS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("comma separated list of listeners to receive mutation results").defaultsTo("HTML", (String[])new String[0]);
        this.additionalClassPathSpec = this.parserAccepts(ConfigOption.CLASSPATH).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("coma separated list of additional classpath elements");
        this.classPathFile = this.parserAccepts(ConfigOption.CLASSPATH_FILE).withRequiredArg().ofType(File.class).describedAs("File with a list of additional classpath elements (one per line)");
        this.failWhenNoMutations = this.parserAccepts(ConfigOption.FAIL_WHEN_NOT_MUTATIONS).withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]).describedAs("whether to throw error if no mutations found");
        this.skipFailingTests = this.parserAccepts(ConfigOption.SKIP_FAILING_TESTS).withOptionalArg().ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]).describedAs("whether to ignore failing tests when computing coverage");
        this.codePaths = this.parserAccepts(ConfigOption.CODE_PATHS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("Globs identifying classpath roots containing mutable code");
        this.includedGroupsSpec = this.parserAccepts(ConfigOption.INCLUDED_GROUPS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("TestNG groups/JUnit categories to include");
        this.includedTestMethodsSpec = this.parserAccepts(ConfigOption.INCLUDED_TEST_METHODS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("Test methods that should be included for challenging the mutants");
        this.excludedGroupsSpec = this.parserAccepts(ConfigOption.EXCLUDED_GROUPS).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("TestNG groups/JUnit categories to include");
        this.fullMutationMatrixSpec = this.parserAccepts(ConfigOption.FULL_MUTATION_MATRIX).withRequiredArg().ofType(Boolean.class).describedAs("Whether to create a full mutation matrix").defaultsTo((Boolean)ConfigOption.FULL_MUTATION_MATRIX.getDefault(Boolean.class), (Boolean[])new Boolean[0]);
        this.mutationUnitSizeSpec = this.parserAccepts(ConfigOption.MUTATION_UNIT_SIZE).withRequiredArg().ofType(Integer.class).describedAs("Maximum number of mutations to include within a single unit of analysis").defaultsTo((Integer)ConfigOption.MUTATION_UNIT_SIZE.getDefault(Integer.class), (Integer[])new Integer[0]);
        this.historyInputSpec = this.parserAccepts(ConfigOption.HISTORY_INPUT_LOCATION).withRequiredArg().ofType(File.class).describedAs("File to read history from for incremental analysis");
        this.historyOutputSpec = this.parserAccepts(ConfigOption.HISTORY_OUTPUT_LOCATION).withRequiredArg().ofType(File.class).describedAs("File to write history to for incremental analysis");
        this.mutationThreshHoldSpec = this.parserAccepts(ConfigOption.MUTATION_THRESHOLD).withRequiredArg().ofType(Integer.class).describedAs("Mutation score below which to throw an error").defaultsTo((Integer)ConfigOption.MUTATION_THRESHOLD.getDefault(Integer.class), (Integer[])new Integer[0]);
        this.maxSurvivingSpec = this.parserAccepts(ConfigOption.MAX_SURVIVING).withRequiredArg().ofType(Integer.class).describedAs("Maximum number of surviving mutants to allow without throwing an error").defaultsTo((Integer)ConfigOption.MAX_SURVIVING.getDefault(Integer.class), (Integer[])new Integer[0]);
        this.coverageThreshHoldSpec = this.parserAccepts(ConfigOption.COVERAGE_THRESHOLD).withRequiredArg().ofType(Integer.class).describedAs("Line coverage below which to throw an error").defaultsTo((Integer)ConfigOption.COVERAGE_THRESHOLD.getDefault(Integer.class), (Integer[])new Integer[0]);
        this.mutationEngine = this.parserAccepts(ConfigOption.MUTATION_ENGINE).withRequiredArg().ofType(String.class).describedAs("mutation engine to use").defaultsTo((String)ConfigOption.MUTATION_ENGINE.getDefault(String.class), (String[])new String[0]);
        this.javaExecutable = this.parserAccepts(ConfigOption.JVM_PATH).withRequiredArg().ofType(String.class).describedAs("path to java executable");
        this.pluginPropertiesSpec = this.parserAccepts(ConfigOption.PLUGIN_CONFIGURATION).withRequiredArg().ofType(KeyValuePair.class).describedAs("custom plugin properties");
    }

    private OptionSpecBuilder parserAccepts(ConfigOption option) {
        return this.parser.accepts(option.getParamName());
    }

    public ParseResult parse(String[] args) {
        ReportOptions data = new ReportOptions();
        try {
            OptionSet userArgs = this.parser.parse(args);
            return this.parseCommandLine(data, userArgs);
        }
        catch (OptionException uoe) {
            return new ParseResult(data, uoe.getLocalizedMessage());
        }
    }

    private ParseResult parseCommandLine(ReportOptions data, OptionSet userArgs) {
        data.setTestPlugin(userArgs.valueOf(this.testPluginSpec));
        data.setReportDir(userArgs.valueOf(this.reportDirSpec));
        data.setTargetClasses(this.targetClassesSpec.values(userArgs));
        data.setTargetTests((Collection)FCollection.map(this.targetTestsSpec.values(userArgs), (Function)Glob.toGlobPredicate()));
        data.setSourceDirs(this.sourceDirSpec.values(userArgs));
        data.setMutators(this.mutators.values(userArgs));
        data.setFeatures(this.features.values(userArgs));
        data.setDependencyAnalysisMaxDistance(this.depth.value(userArgs).intValue());
        data.addChildJVMArgs(this.jvmArgs.values(userArgs));
        data.setFullMutationMatrix(this.fullMutationMatrixSpec.value(userArgs).booleanValue());
        data.setDetectInlinedCode(userArgs.has(this.detectInlinedCode) && userArgs.valueOf(this.detectInlinedCode) != false);
        data.setIncludeLaunchClasspath(userArgs.valueOf(this.includeLaunchClasspathSpec).booleanValue());
        data.setUseClasspathJar(userArgs.valueOf(this.useClasspathJarSpec).booleanValue());
        data.setShouldCreateTimestampedReports(userArgs.valueOf(this.timestampedReportsSpec).booleanValue());
        data.setNumberOfThreads(this.threadsSpec.value(userArgs).intValue());
        data.setTimeoutFactor(this.timeoutFactorSpec.value(userArgs).floatValue());
        data.setTimeoutConstant(this.timeoutConstSpec.value(userArgs).longValue());
        data.setLoggingClasses(this.avoidCallsSpec.values(userArgs));
        data.setExcludedMethods(this.excludedMethodsSpec.values(userArgs));
        data.setExcludedClasses(this.excludedClassesSpec.values(userArgs));
        data.setExcludedTestClasses((Collection)FCollection.map(this.excludedTestClassesSpec.values(userArgs), (Function)Glob.toGlobPredicate()));
        data.setVerbose(userArgs.has(this.verboseSpec) && userArgs.valueOf(this.verboseSpec) != false);
        data.addOutputFormats(this.outputFormatSpec.values(userArgs));
        data.setFailWhenNoMutations(((Boolean)this.failWhenNoMutations.value(userArgs)).booleanValue());
        data.setSkipFailingTests(((Boolean)this.skipFailingTests.value(userArgs)).booleanValue());
        data.setCodePaths(this.codePaths.values(userArgs));
        data.setMutationUnitSize(this.mutationUnitSizeSpec.value(userArgs).intValue());
        data.setHistoryInputLocation(this.historyInputSpec.value(userArgs));
        data.setHistoryOutputLocation(this.historyOutputSpec.value(userArgs));
        data.setMutationThreshold(((Integer)this.mutationThreshHoldSpec.value(userArgs)).intValue());
        data.setMaximumAllowedSurvivors(((Integer)this.maxSurvivingSpec.value(userArgs)).intValue());
        data.setCoverageThreshold(((Integer)this.coverageThreshHoldSpec.value(userArgs)).intValue());
        data.setMutationEngine(this.mutationEngine.value(userArgs));
        data.setFreeFormProperties(this.listToProperties(this.pluginPropertiesSpec.values(userArgs)));
        data.setExportLineCoverage(userArgs.has(this.exportLineCoverageSpec) && userArgs.valueOf(this.exportLineCoverageSpec) != false);
        this.setClassPath(userArgs, data);
        this.setTestGroups(userArgs, data);
        data.setIncludedTestMethods(this.includedTestMethodsSpec.values(userArgs));
        data.setJavaExecutable(this.javaExecutable.value(userArgs));
        if (userArgs.has("?")) {
            return new ParseResult(data, "See above for supported parameters.");
        }
        return new ParseResult(data, null);
    }

    private void setClassPath(OptionSet userArgs, ReportOptions data) {
        ArrayList<String> elements = new ArrayList<String>();
        if (data.isIncludeLaunchClasspath()) {
            elements.addAll(ClassPath.getClassPathElementsAsPaths());
        } else {
            elements.addAll(FCollection.filter((Iterable)ClassPath.getClassPathElementsAsPaths(), this.dependencyFilter));
        }
        if (userArgs.has(this.classPathFile)) {
            try (BufferedReader classPathFileBR = new BufferedReader(new FileReader(userArgs.valueOf(this.classPathFile).getAbsoluteFile()));){
                String element;
                while ((element = classPathFileBR.readLine()) != null) {
                    elements.add(element);
                }
            }
            catch (IOException ioe) {
                LOG.warning("Unable to read class path file:" + userArgs.valueOf(this.classPathFile).getAbsolutePath() + " - " + ioe.getMessage());
            }
        }
        elements.addAll(userArgs.valuesOf(this.additionalClassPathSpec));
        data.setClassPathElements(elements);
    }

    private void setTestGroups(OptionSet userArgs, ReportOptions data) {
        TestGroupConfig conf = new TestGroupConfig(this.excludedGroupsSpec.values(userArgs), this.includedGroupsSpec.values(userArgs));
        data.setGroupConfig(conf);
    }

    private Properties listToProperties(List<KeyValuePair> kvps) {
        Properties p = new Properties();
        for (KeyValuePair kvp : kvps) {
            p.put(kvp.key, kvp.value);
        }
        return p;
    }

    public void printHelp() {
        try {
            this.parser.printHelpOn(System.out);
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException((Throwable)ex);
        }
    }
}

