/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.report.html.LineStatus;
import org.pitest.mutationtest.report.html.LineStyle;
import org.pitest.mutationtest.report.html.ResultComparator;

public class Line {
    private final long number;
    private final String text;
    private final LineStatus lineCovered;
    private final List<MutationResult> mutations;

    public Line(long number, String text, LineStatus lineCovered, List<MutationResult> mutations) {
        this.number = number;
        this.text = text;
        this.lineCovered = lineCovered;
        this.mutations = mutations;
        Collections.sort(mutations, new ResultComparator());
    }

    public long getNumber() {
        return this.number;
    }

    public String getText() {
        return this.text;
    }

    public LineStatus getLineCovered() {
        return this.lineCovered;
    }

    public List<MutationResult> getMutations() {
        return this.mutations;
    }

    public Optional<DetectionStatus> detectionStatus() {
        if (this.mutations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.mutations.get(0).getStatus());
    }

    public int getNumberOfMutations() {
        return this.mutations.size();
    }

    public String getNumberOfMutationsForDisplay() {
        if (this.getNumberOfMutations() > 0) {
            return "" + this.getNumberOfMutations();
        }
        return "";
    }

    public LineStyle getStyles() {
        return new LineStyle(this);
    }
}

