/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.aggregate;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;

final class MutatorUtil {
    private static final Map<String, MethodMutatorFactory> FACTORIES = new ConcurrentHashMap<String, MethodMutatorFactory>();

    MutatorUtil() {
    }

    static MethodMutatorFactory loadMutator(String className) {
        if (!FACTORIES.containsKey(className)) {
            try {
                Class<?> clazz = Class.forName(className);
                Method values = clazz.getMethod("values", new Class[0]);
                Object valuesArray = values.invoke(null, new Object[0]);
                MethodMutatorFactory mutator = (MethodMutatorFactory)Array.get(valuesArray, 0);
                FACTORIES.put(className, mutator);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load Mutator for class: " + className, e);
            }
        }
        return FACTORIES.get(className);
    }
}

