/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.webwork.velocity;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.servlet.VelocityViewServlet;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.containers.EmptyPicoContainer;
import org.picocontainer.web.PicoServletContainerFilter;
import webwork.action.ServletActionContext;
import webwork.util.ServletValueStack;
import webwork.view.velocity.WebWorkUtil;

public final class WebWorkVelocityServlet
extends VelocityViewServlet {
    static final String WEBWORK_UTIL = "webwork";
    static final String REQUEST = "req";
    static final String RESPONSE = "res";
    static final EmptyPicoContainer emptyContainer = new EmptyPicoContainer();

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        NanocontainerVelocityContext ctx = new NanocontainerVelocityContext((PicoContainer)ServletFilter.getRequestContainerForThread(), ServletValueStack.getStack((ServletRequest)request));
        ctx.put(REQUEST, request);
        ctx.put(RESPONSE, response);
        return ctx;
    }

    protected Template handleRequest(HttpServletRequest aRequest, HttpServletResponse aResponse, Context ctx) throws Exception {
        ServletActionContext.setContext((HttpServletRequest)aRequest, (HttpServletResponse)aResponse, (ServletContext)this.getServletContext(), null);
        ctx.put(WEBWORK_UTIL, (Object)new WebWorkUtil(ctx));
        String servletPath = (String)aRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = aRequest.getServletPath();
        }
        return this.getTemplate(servletPath);
    }

    static final class NanocontainerVelocityContext
    extends VelocityContext {
        final PicoContainer container;
        final ServletValueStack stack;

        NanocontainerVelocityContext(PicoContainer container, ServletValueStack stack) {
            this.container = container != null ? container : emptyContainer;
            this.stack = stack;
        }

        public boolean internalContainsKey(Object key) {
            boolean contains = super.internalContainsKey(key);
            if (contains) {
                return contains;
            }
            contains = this.stack.test(key.toString());
            if (contains) {
                return contains;
            }
            return this.container.getComponentAdapter(key) != null;
        }

        public Object internalGet(String key) {
            if (super.internalContainsKey((Object)key)) {
                return super.internalGet(key);
            }
            if (this.stack.test(key)) {
                return this.stack.findValue(key);
            }
            return this.container.getComponent((Object)key);
        }
    }

    public static class ServletFilter
    extends PicoServletContainerFilter {
        private static ThreadLocal<MutablePicoContainer> currentRequestContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentSessionContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentAppContainer = new ThreadLocal();

        protected void setAppContainer(MutablePicoContainer container) {
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            currentSessionContainer.set(container);
        }

        protected static MutablePicoContainer getRequestContainerForThread() {
            return currentRequestContainer.get();
        }

        protected static MutablePicoContainer getSessionContainerForThread() {
            return currentSessionContainer.get();
        }

        protected static MutablePicoContainer getApplicationContainerForThread() {
            return currentAppContainer.get();
        }
    }
}

