/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.webwork;

import java.util.HashMap;
import java.util.Map;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.web.PicoServletContainerFilter;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PicoActionFactory
extends ActionFactory {
    private final Map<String, Class<?>> classCache = new HashMap();

    public Action getActionImpl(String className) {
        try {
            Class<?> actionClass = this.getActionClass(className);
            Action action = null;
            try {
                action = this.instantiateAction(actionClass);
            }
            catch (Exception e) {
                // empty catch block
            }
            return action;
        }
        catch (PicoCompositionException e) {
            return null;
        }
    }

    protected Action instantiateAction(Class<?> actionClass) {
        MutablePicoContainer actionsContainer = ServletFilter.getRequestContainerForThread();
        Action action = (Action)actionsContainer.getComponent(actionClass);
        if (action == null) {
            actionsContainer.addComponent(actionClass);
            action = (Action)actionsContainer.getComponent(actionClass);
        }
        return action;
    }

    public Class<?> getActionClass(String className) throws PicoCompositionException {
        try {
            return this.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new PicoCompositionException("Action class '" + className + "' not found", (Throwable)e);
        }
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.classCache.containsKey(className)) {
            return this.classCache.get(className);
        }
        Class<?> result = Thread.currentThread().getContextClassLoader().loadClass(className);
        this.classCache.put(className, result);
        return result;
    }

    public static class ServletFilter
    extends PicoServletContainerFilter {
        private static ThreadLocal<MutablePicoContainer> currentRequestContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentSessionContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentAppContainer = new ThreadLocal();

        protected void setAppContainer(MutablePicoContainer container) {
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            currentSessionContainer.set(container);
        }

        protected static MutablePicoContainer getRequestContainerForThread() {
            return currentRequestContainer.get();
        }

        protected static MutablePicoContainer getSessionContainerForThread() {
            return currentSessionContainer.get();
        }

        protected static MutablePicoContainer getApplicationContainerForThread() {
            return currentAppContainer.get();
        }
    }
}

