/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.struts2;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.web.PicoServletContainerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicoObjectFactory
extends ObjectFactory {
    public Class getClassInstance(String name) throws ClassNotFoundException {
        Class clazz = super.getClassInstance(name);
        this.registerAction(clazz);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAction(Class<?> clazz) throws NoClassDefFoundError {
        PicoObjectFactory picoObjectFactory = this;
        synchronized (picoObjectFactory) {
            block7: {
                MutablePicoContainer reqContainer = ServletFilter.getRequestContainerForThread();
                if (reqContainer == null) {
                    return;
                }
                ComponentAdapter ca = reqContainer.getComponentAdapter(clazz);
                if (ca == null) {
                    try {
                        reqContainer.addComponent(clazz);
                    }
                    catch (NoClassDefFoundError e) {
                        if (e.getMessage().equals("org/apache/velocity/context/Context")) break block7;
                        throw e;
                    }
                }
            }
        }
    }

    public Object buildBean(Class clazz, Map extraContext) throws Exception {
        MutablePicoContainer requestContainer = ServletFilter.getRequestContainerForThread();
        if (requestContainer == null) {
            MutablePicoContainer appContainer = ServletFilter.getApplicationContainerForThread();
            Object comp = appContainer.getComponent(clazz);
            if (comp == null) {
                appContainer.addComponent((Object)clazz);
                comp = appContainer.getComponent(clazz);
            }
            return comp;
        }
        return requestContainer.getComponent(clazz);
    }

    public Interceptor buildInterceptor(InterceptorConfig config, Map params) throws ConfigurationException {
        return super.buildInterceptor(config, params);
    }

    public boolean isNoArgConstructorRequired() {
        return false;
    }

    public static class ServletFilter
    extends PicoServletContainerFilter {
        private static ThreadLocal<MutablePicoContainer> currentRequestContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentSessionContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentAppContainer = new ThreadLocal();

        protected void setAppContainer(MutablePicoContainer container) {
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            currentSessionContainer.set(container);
        }

        protected static MutablePicoContainer getRequestContainerForThread() {
            return currentRequestContainer.get();
        }

        protected static MutablePicoContainer getSessionContainerForThread() {
            return currentSessionContainer.get();
        }

        protected static MutablePicoContainer getApplicationContainerForThread() {
            return currentAppContainer.get();
        }
    }
}

