/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.struts;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.web.PicoServletContainerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PicoActionFactory {
    private static ThreadLocal<MutablePicoContainer> currentRequestContainer = new ThreadLocal();
    private static ThreadLocal<MutablePicoContainer> currentSessionContainer = new ThreadLocal();
    private static ThreadLocal<MutablePicoContainer> currentAppContainer = new ThreadLocal();
    private final Map<String, Class<?>> classCache = new HashMap();

    public Action getAction(HttpServletRequest request, ActionMapping mapping, ActionServlet servlet) throws PicoCompositionException {
        MutablePicoContainer actionsContainer = currentRequestContainer.get();
        String actionKey = mapping.getPath();
        Class<?> actionType = this.getActionClass(mapping.getType());
        Action action = (Action)actionsContainer.getComponent((Object)actionKey);
        if (action == null) {
            actionsContainer.addComponent((Object)actionKey, actionType, new Parameter[0]);
            action = (Action)actionsContainer.getComponent((Object)actionKey);
        }
        action.setServlet(servlet);
        return action;
    }

    public Class<?> getActionClass(String className) throws PicoCompositionException {
        try {
            return this.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new PicoCompositionException("Action class '" + className + "' not found", (Throwable)e);
        }
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.classCache.containsKey(className)) {
            return this.classCache.get(className);
        }
        Class<?> result = Thread.currentThread().getContextClassLoader().loadClass(className);
        this.classCache.put(className, result);
        return result;
    }

    public static class ServletFilter
    extends PicoServletContainerFilter {
        protected void setAppContainer(MutablePicoContainer container) {
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            currentSessionContainer.set(container);
        }
    }
}

