/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.groovy.nodes;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.picocontainer.Parameter;
import org.picocontainer.classname.ClassLoadingPicoContainer;
import org.picocontainer.parameters.ConstantParameter;
import org.picocontainer.script.NodeBuilderDecorator;
import org.picocontainer.script.groovy.nodes.AbstractBuilderNode;
import org.picocontainer.script.util.ComponentElementHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentNode
extends AbstractBuilderNode {
    public static final String NODE_NAME = "component";
    public static final String KEY = "key";
    private static final String CLASS = "class";
    private static final String CLASS_NAME_KEY = "classNameKey";
    private static final String INSTANCE = "instance";
    private static final String PARAMETERS = "parameters";
    private static final String PROPERTIES = "properties";
    private final NodeBuilderDecorator decorator;

    public ComponentNode(NodeBuilderDecorator decorator) {
        super(NODE_NAME);
        this.decorator = decorator;
        this.addAttribute(KEY).addAttribute(CLASS).addAttribute(CLASS_NAME_KEY).addAttribute(INSTANCE).addAttribute(PARAMETERS).addAttribute(PROPERTIES);
    }

    @Override
    public Object createNewNode(Object current, Map<String, Object> attributes) {
        this.decorator.rememberComponentKey(attributes);
        Object key = attributes.remove(KEY);
        Object classNameKey = attributes.remove(CLASS_NAME_KEY);
        Object classValue = attributes.remove(CLASS);
        Object instance = attributes.remove(INSTANCE);
        Object parameters = attributes.remove(PARAMETERS);
        Object properties = attributes.remove(PROPERTIES);
        return ComponentElementHelper.makeComponent((Object)classNameKey, (Object)key, (Parameter[])ComponentNode.getParameters(parameters), (Object)classValue, (ClassLoadingPicoContainer)((ClassLoadingPicoContainer)current), (Object)instance, (Properties[])ComponentNode.getProperties(properties));
    }

    private static Parameter[] getParameters(Object params) {
        if (params == null) {
            return null;
        }
        if (params instanceof Parameter[]) {
            return (Parameter[])params;
        }
        if (!(params instanceof List)) {
            throw new IllegalArgumentException("Parameters may only be of type List or Parameter Array");
        }
        List list = (List)params;
        int n = list.size();
        Parameter[] parameters = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            parameters[i] = ComponentNode.toParameter(list.get(i));
        }
        return parameters;
    }

    private static Parameter toParameter(Object obj) {
        return obj instanceof Parameter ? (Parameter)obj : new ConstantParameter(obj);
    }

    private static Properties[] getProperties(Object props) {
        if (props == null) {
            return new Properties[0];
        }
        if (!(props instanceof List)) {
            throw new IllegalArgumentException("Properties may only be of type List");
        }
        List list = (List)props;
        return list.toArray(new Properties[list.size()]);
    }
}

