/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.groovy.nodes;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.picocontainer.script.ScriptedPicoContainerMarkupException;
import org.picocontainer.script.groovy.BuilderNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilderNode
implements BuilderNode,
Serializable {
    private final String nodeName;
    private final Set<String> supportedAttributes = new HashSet<String>();

    public AbstractBuilderNode(String nodeName) {
        this.nodeName = nodeName;
    }

    protected AbstractBuilderNode addAttribute(String name) {
        this.supportedAttributes.add(name);
        return this;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public Set<String> getSupportedAttributeNames() {
        return Collections.unmodifiableSet(this.supportedAttributes);
    }

    public String toString() {
        return "BuilderNode: " + this.getClass().getName() + " (\"" + this.getNodeName() + "\")";
    }

    protected boolean isAttribute(Map<String, Object> attributes, String key) {
        return attributes.containsKey(key) && attributes.get(key) != null;
    }

    @Override
    public void validateScriptedAttributes(Map<String, Object> specifiedAttributes) throws ScriptedPicoContainerMarkupException {
        Set<String> specifiedAttributeNames = specifiedAttributes.keySet();
        if (this.getSupportedAttributeNames().containsAll(specifiedAttributeNames)) {
            return;
        }
        HashSet<String> unknownAttributeNames = new HashSet<String>(specifiedAttributeNames);
        unknownAttributeNames.removeAll(this.getSupportedAttributeNames());
        StringBuffer errorMessage = new StringBuffer();
        errorMessage.append("Found one or more unknown attributes for builder node '");
        errorMessage.append(this.getNodeName());
        errorMessage.append("': ");
        errorMessage.append(this.toCSV(unknownAttributeNames));
        errorMessage.append(".  Recognized Attributes For this node are [");
        errorMessage.append(this.toCSV(this.getSupportedAttributeNames()));
        errorMessage.append("].");
        throw new ScriptedPicoContainerMarkupException(errorMessage.toString());
    }

    private String toCSV(Set<String> set) {
        StringBuffer result = new StringBuffer();
        boolean needComma = false;
        for (String element : set) {
            if (needComma) {
                result.append(",");
            } else {
                needComma = true;
            }
            result.append(element.toString());
        }
        return result.toString();
    }
}

