/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.logging.store.stores;

import java.util.HashMap;
import java.util.Map;
import org.picocontainer.logging.Logger;
import org.picocontainer.logging.store.LoggerNotFoundException;
import org.picocontainer.logging.store.LoggerStore;

public abstract class AbstractLoggerStore
implements LoggerStore {
    private final Map<String, Logger> loggers = new HashMap<String, Logger>();
    private Logger logger;
    private Logger rootLogger;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        Logger logger;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            String message = "Root Logger returned";
            this.logger.debug("Root Logger returned");
        }
        if ((logger = this.getRootLogger()) == null) {
            String message = "Root Logger is not defined";
            throw new LoggerNotFoundException("Root Logger is not defined");
        }
        return logger;
    }

    public Logger getLogger(String name) {
        if (null == name) {
            throw new NullPointerException("name");
        }
        Logger logger = this.retrieveLogger(name);
        if (logger == null) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                String message = "Logger named '" + name + "' not defined in configuration. New Logger " + "created and returned.";
                this.logger.debug(message);
            }
            Logger logger1 = logger = this.createLogger(name);
            this.loggers.put(name, logger1);
        }
        return logger;
    }

    protected abstract Logger createLogger(String var1);

    protected final void setRootLogger(Logger rootLogger) {
        this.rootLogger = rootLogger;
    }

    protected final Logger getRootLogger() {
        return this.rootLogger;
    }

    private Logger retrieveLogger(String name) {
        Logger logger = this.loggers.get(name);
        if (null != logger && null != this.logger && this.logger.isDebugEnabled()) {
            String message = "Retrieved Logger named: " + name;
            this.logger.debug(message);
        }
        return logger;
    }
}

