/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.logging.store;

import java.io.InputStream;
import java.util.HashMap;
import org.picocontainer.logging.store.LoggerStore;
import org.picocontainer.logging.store.LoggerStoreCreationException;
import org.picocontainer.logging.store.factories.DOMLog4JLoggerStoreFactory;
import org.picocontainer.logging.store.factories.InitialLoggerStoreFactory;
import org.picocontainer.logging.store.factories.JdkLoggerStoreFactory;
import org.picocontainer.logging.store.factories.PropertyLog4JLoggerStoreFactory;

public class Configurator {
    public static final String LOG4J_DOM = "log4j-dom";
    public static final String LOG4J_PROPERTY = "log4j-property";
    public static final String JDK = "jdk";

    public static LoggerStore createLoggerStore(String configuratorType, String resource) {
        InitialLoggerStoreFactory factory = new InitialLoggerStoreFactory();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("org.picocontainer.logging.store.factory", Configurator.getFactoryClassName(configuratorType));
        data.put("org.picocontainer.logging.store.file", resource);
        return factory.createLoggerStore(data);
    }

    public static LoggerStore createLoggerStore(String configuratorType, InputStream resource) {
        InitialLoggerStoreFactory factory = new InitialLoggerStoreFactory();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("org.picocontainer.logging.store.factory", Configurator.getFactoryClassName(configuratorType));
        data.put(InputStream.class.getName(), resource);
        return factory.createLoggerStore(data);
    }

    private static String getFactoryClassName(String type) {
        if (LOG4J_DOM.equals(type)) {
            return DOMLog4JLoggerStoreFactory.class.getName();
        }
        if (LOG4J_PROPERTY.equals(type)) {
            return PropertyLog4JLoggerStoreFactory.class.getName();
        }
        if (JDK.equals(type)) {
            return JdkLoggerStoreFactory.class.getName();
        }
        String message = "Unknown type " + type;
        throw new LoggerStoreCreationException(message);
    }
}

