/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.logging.store.factories;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.picocontainer.logging.store.LoggerStore;
import org.picocontainer.logging.store.LoggerStoreCreationException;
import org.picocontainer.logging.store.factories.AbstractLoggerStoreFactory;
import org.picocontainer.logging.store.stores.Log4JLoggerStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLog4JLoggerStoreFactory
extends AbstractLoggerStoreFactory {
    @Override
    protected LoggerStore doCreateLoggerStore(Map<String, Object> config) {
        try {
            Properties properties = (Properties)config.get(Properties.class.getName());
            if (null != properties) {
                return new Log4JLoggerStore(properties);
            }
            InputStream resource = this.getInputStream(config);
            if (null != resource) {
                return new Log4JLoggerStore(this.createPropertiesFromStream(resource));
            }
            return this.missingConfiguration();
        }
        catch (Exception e) {
            String message = "Failed to create logger store for configuration " + config;
            throw new LoggerStoreCreationException(message, e);
        }
    }

    private Properties createPropertiesFromStream(InputStream resource) throws IOException {
        Properties properties = new Properties();
        properties.load(resource);
        return properties;
    }
}

