/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import com.thoughtworks.paranamer.AdaptiveParanamer;
import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.annotations.Bind;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.ParameterNameBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IterativeInjector<T>
extends AbstractInjector<T> {
    private static final Object[] NONE = new Object[0];
    private transient AbstractInjector.ThreadLocalCyclicDependencyGuard instantiationGuard;
    protected transient List<AccessibleObject> injectionMembers;
    protected transient Type[] injectionTypes;
    protected transient Annotation[] bindings;
    private transient Paranamer paranamer;

    public IterativeInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, monitor, useNames);
    }

    protected Constructor getConstructor() {
        Object retVal = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return IterativeInjector.this.getComponentImplementation().getConstructor(null);
                }
                catch (NoSuchMethodException e) {
                    return new PicoCompositionException(e);
                }
                catch (SecurityException e) {
                    return new PicoCompositionException(e);
                }
            }
        });
        if (retVal instanceof Constructor) {
            return (Constructor)retVal;
        }
        throw (PicoCompositionException)retVal;
    }

    private Parameter[] getMatchingParameterListForSetters(PicoContainer container) throws PicoCompositionException {
        if (this.injectionMembers == null) {
            this.initializeInjectionMembersAndTypeLists();
        }
        ArrayList<Object> matchingParameterList = new ArrayList<Object>(Collections.nCopies(this.injectionMembers.size(), null));
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(this.injectionTypes);
        Set<Integer> nonMatchingParameterPositions = this.matchParameters(container, matchingParameterList, currentParameters);
        HashSet<Type> unsatisfiableDependencyTypes = new HashSet<Type>();
        for (int i = 0; i < matchingParameterList.size(); ++i) {
            if (matchingParameterList.get(i) != null) continue;
            unsatisfiableDependencyTypes.add(this.injectionTypes[i]);
        }
        if (unsatisfiableDependencyTypes.size() > 0) {
            this.unsatisfiedDependencies(container, unsatisfiableDependencyTypes);
        } else if (nonMatchingParameterPositions.size() > 0) {
            throw new PicoCompositionException("Following parameters do not match any of the injectionMembers for " + this.getComponentImplementation() + ": " + nonMatchingParameterPositions.toString());
        }
        return matchingParameterList.toArray(new Parameter[matchingParameterList.size()]);
    }

    private Set<Integer> matchParameters(PicoContainer container, List<Object> matchingParameterList, Parameter[] currentParameters) {
        HashSet<Integer> unmatchedParameters = new HashSet<Integer>();
        for (int i = 0; i < currentParameters.length; ++i) {
            if (this.matchParameter(container, matchingParameterList, currentParameters[i])) continue;
            unmatchedParameters.add(i);
        }
        return unmatchedParameters;
    }

    private boolean matchParameter(PicoContainer container, List<Object> matchingParameterList, Parameter parameter) {
        for (int j = 0; j < this.injectionTypes.length; ++j) {
            Object o = matchingParameterList.get(j);
            if (o != null || !parameter.resolve(container, this, null, this.injectionTypes[j], this.makeParameterNameImpl(this.injectionMembers.get(j)), this.useNames(), this.bindings[j]).isResolved()) continue;
            matchingParameterList.set(j, parameter);
            return true;
        }
        return false;
    }

    protected NameBinding makeParameterNameImpl(AccessibleObject member) {
        if (this.paranamer == null) {
            this.paranamer = new CachingParanamer((Paranamer)new AnnotationParanamer((Paranamer)new AdaptiveParanamer()));
        }
        return new ParameterNameBinding(this.paranamer, member, 0);
    }

    protected void unsatisfiedDependencies(PicoContainer container, Set<Type> unsatisfiableDependencyTypes) {
        throw new AbstractInjector.UnsatisfiableDependenciesException(this, null, unsatisfiableDependencyTypes, container);
    }

    @Override
    public T getComponentInstance(final PicoContainer container, Type into) throws PicoCompositionException {
        final Constructor constructor = this.getConstructor();
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run() {
                    Parameter[] matchingParameters = IterativeInjector.this.getMatchingParameterListForSetters(this.guardedContainer);
                    Object componentInstance = IterativeInjector.this.makeInstance(container, constructor, IterativeInjector.this.currentMonitor());
                    return IterativeInjector.this.decorateComponentInstance(matchingParameters, IterativeInjector.this.currentMonitor(), componentInstance, container, this.guardedContainer);
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        return this.instantiationGuard.observe(this.getComponentImplementation());
    }

    private Object decorateComponentInstance(Parameter[] matchingParameters, ComponentMonitor componentMonitor, Object componentInstance, PicoContainer container, PicoContainer guardedContainer) {
        AccessibleObject member = null;
        Object[] injected = new Object[this.injectionMembers.size()];
        Object lastReturn = null;
        try {
            for (int i = 0; i < this.injectionMembers.size(); ++i) {
                member = this.injectionMembers.get(i);
                if (matchingParameters[i] == null) continue;
                Object toInject = matchingParameters[i].resolve(guardedContainer, this, null, this.injectionTypes[i], this.makeParameterNameImpl(this.injectionMembers.get(i)), this.useNames(), this.bindings[i]).resolveInstance();
                Object rv = componentMonitor.invoking(container, this, (Member)((Object)member), componentInstance, new Object[]{toInject});
                if (rv == ComponentMonitor.KEEP) {
                    long str = System.currentTimeMillis();
                    lastReturn = this.injectIntoMember(member, componentInstance, toInject);
                    componentMonitor.invoked(container, this, (Member)((Object)member), componentInstance, System.currentTimeMillis() - str, new Object[]{toInject}, lastReturn);
                } else {
                    lastReturn = rv;
                }
                injected[i] = toInject;
            }
            return this.memberInvocationReturn(lastReturn, member, componentInstance);
        }
        catch (InvocationTargetException e) {
            return this.caughtInvocationTargetException(componentMonitor, (Member)((Object)member), componentInstance, e);
        }
        catch (IllegalAccessException e) {
            return this.caughtIllegalAccessException(componentMonitor, (Member)((Object)member), componentInstance, e);
        }
    }

    protected abstract Object memberInvocationReturn(Object var1, AccessibleObject var2, Object var3);

    private Object makeInstance(PicoContainer container, Constructor constructor, ComponentMonitor componentMonitor) {
        Object componentInstance;
        long startTime = System.currentTimeMillis();
        Constructor constructorToUse = componentMonitor.instantiating(container, this, constructor);
        try {
            componentInstance = this.newInstance(constructorToUse, null);
        }
        catch (InvocationTargetException e) {
            componentMonitor.instantiationFailed(container, this, constructorToUse, e);
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new PicoCompositionException(e.getTargetException());
        }
        catch (InstantiationException e) {
            return this.caughtInstantiationException(componentMonitor, constructor, e, container);
        }
        catch (IllegalAccessException e) {
            return this.caughtIllegalAccessException(componentMonitor, constructor, e, container);
        }
        componentMonitor.instantiated(container, this, constructorToUse, componentInstance, NONE, System.currentTimeMillis() - startTime);
        return componentInstance;
    }

    @Override
    public Object decorateComponentInstance(final PicoContainer container, Type into, final T instance) {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run() {
                    Parameter[] matchingParameters = IterativeInjector.this.getMatchingParameterListForSetters(this.guardedContainer);
                    return IterativeInjector.this.decorateComponentInstance(matchingParameters, IterativeInjector.this.currentMonitor(), instance, container, this.guardedContainer);
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        return this.instantiationGuard.observe(this.getComponentImplementation());
    }

    protected abstract Object injectIntoMember(AccessibleObject var1, Object var2, Object var3) throws IllegalAccessException, InvocationTargetException;

    @Override
    public void verify(final PicoContainer container) throws PicoCompositionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run() {
                    Parameter[] currentParameters = IterativeInjector.this.getMatchingParameterListForSetters(this.guardedContainer);
                    for (int i = 0; i < currentParameters.length; ++i) {
                        currentParameters[i].verify(container, IterativeInjector.this, IterativeInjector.this.injectionTypes[i], IterativeInjector.this.makeParameterNameImpl(IterativeInjector.this.injectionMembers.get(i)), IterativeInjector.this.useNames(), IterativeInjector.this.bindings[i]);
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setGuardedContainer(container);
        this.verifyingGuard.observe(this.getComponentImplementation());
    }

    protected void initializeInjectionMembersAndTypeLists() {
        Method[] methods;
        this.injectionMembers = new ArrayList<AccessibleObject>();
        ArrayList<Annotation> bingingIds = new ArrayList<Annotation>();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (Method method : methods = this.getMethods()) {
            boolean isInjector;
            Type[] parameterTypes = method.getGenericParameterTypes();
            this.fixGenericParameterTypes(method, parameterTypes);
            if (parameterTypes.length != 1 || !(isInjector = this.isInjectorMethod(method))) continue;
            this.injectionMembers.add(method);
            nameList.add(this.getName(method));
            typeList.add(this.box(parameterTypes[0]));
            bingingIds.add(this.getBindings(method, 0));
        }
        this.injectionTypes = typeList.toArray(new Type[0]);
        this.bindings = bingingIds.toArray(new Annotation[0]);
    }

    protected String getName(Method method) {
        return null;
    }

    private void fixGenericParameterTypes(Method method, Type[] parameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            if (!(parameterType instanceof TypeVariable)) continue;
            parameterTypes[i] = method.getParameterTypes()[i];
        }
    }

    private Annotation getBindings(Method method, int i) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length >= i + 1) {
            Annotation[] o;
            for (Annotation annotation : o = parameterAnnotations[i]) {
                if (annotation.annotationType().getAnnotation(Bind.class) == null) continue;
                return annotation;
            }
            return null;
        }
        if (parameterAnnotations != null) {
            // empty if block
        }
        return null;
    }

    protected boolean isInjectorMethod(Method method) {
        return false;
    }

    private Method[] getMethods() {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return IterativeInjector.this.getComponentImplementation().getMethods();
            }
        });
    }
}

