/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.scim.parsing;

import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.scim.codec.SCIMParser;
import org.picketlink.scim.model.v11.ServiceProviderConfiguration;

public class ServiceProviderConfigurationParsingTestCase {
    @Test
    public void parse() throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("json/serviceprovider.json");
        Assert.assertNotNull((Object)is);
        SCIMParser parser = new SCIMParser();
        ServiceProviderConfiguration sp = parser.parseServiceProviderConfiguration(is);
        Assert.assertNotNull((Object)sp);
        Assert.assertEquals((Object)"http://example.com/help/scim.html", (Object)sp.getDocumentationUrl());
        Assert.assertTrue((boolean)sp.getPatch().isSupported());
        Assert.assertEquals((long)2L, (long)sp.getAuthenticationSchemes().length);
        ServiceProviderConfiguration.Bulk bulk = sp.getBulk();
        Assert.assertTrue((boolean)bulk.isSupported());
        Assert.assertEquals((long)1000L, (long)bulk.getMaxOperations());
        Assert.assertEquals((long)0x100000L, (long)bulk.getMaxPayloadSize());
        ServiceProviderConfiguration.Filter filter = sp.getFilter();
        Assert.assertTrue((boolean)filter.isSupported());
        Assert.assertEquals((long)200L, (long)filter.getMaxResults());
        Assert.assertTrue((boolean)sp.getChangePassword().isSupported());
        Assert.assertTrue((boolean)sp.getSort().isSupported());
        Assert.assertTrue((boolean)sp.getEtag().isSupported());
        Assert.assertTrue((boolean)sp.getXmlDataFormat().isSupported());
    }
}

