/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.scim.parsing;

import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.scim.codec.SCIMParser;
import org.picketlink.scim.model.v11.SCIMGroups;

public class GroupParsingTestCase {
    @Test
    public void parse() throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("json/group.json");
        Assert.assertNotNull((Object)is);
        SCIMParser parser = new SCIMParser();
        SCIMGroups group = parser.parseGroup(is);
        Assert.assertNotNull((Object)group);
        Assert.assertEquals((Object)"e9e30dba-f08f-4109-8486-d5c6a331660a", (Object)group.getId());
        Assert.assertEquals((Object)"Tour Guides", (Object)group.getDisplayName());
        SCIMGroups.Members[] members = group.getMembers();
        Assert.assertEquals((long)2L, (long)members.length);
        for (int i = 0; i < 2; ++i) {
            SCIMGroups.Members member = members[i];
            Assert.assertTrue(("2819c223-7f76-453a-919d-413861904646".equals(member.getValue()) || "902c246b-6245-4190-8e05-00816be7344a".equals(member.getValue()) ? 1 : 0) != 0);
            Assert.assertTrue(("Babs Jensen".equals(member.getDisplay()) || "Mandy Pepperidge".equals(member.getDisplay()) ? 1 : 0) != 0);
        }
    }
}

