/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.scim.parsing;

import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.scim.codec.SCIMParser;
import org.picketlink.scim.model.v11.Meta;
import org.picketlink.scim.model.v11.SCIMUser;
import org.picketlink.scim.model.v11.UserName;

public class UserParsingTestCase {
    @Test
    public void parse() throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("json/user.json");
        Assert.assertNotNull((Object)is);
        SCIMParser parser = new SCIMParser();
        SCIMUser user = parser.parseUser(is);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"2819c223-7f76-453a-919d-413861904646", (Object)user.getId());
        Assert.assertEquals((Object)"701984", (Object)user.getExternalId());
        Assert.assertEquals((Object)"Ms. Barbara J Jensen III", (Object)user.getName().getFormatted());
        UserName userName = user.getName();
        Assert.assertEquals((Object)"Ms. Barbara J Jensen III", (Object)userName.getFormatted());
        Assert.assertEquals((Object)"Jensen", (Object)userName.getFamilyName());
        Assert.assertEquals((Object)"Barbara", (Object)userName.getGivenName());
        Assert.assertEquals((Object)"Jane", (Object)userName.getMiddleName());
        Assert.assertEquals((Object)"Ms.", (Object)userName.getHonorificPrefix());
        Assert.assertEquals((Object)"III", (Object)userName.getHonorificSuffix());
        Assert.assertEquals((Object)"Babs Jensen", (Object)user.getDisplayName());
        Assert.assertEquals((Object)"Babs", (Object)user.getNickName());
        Assert.assertEquals((Object)"https://login.example.com/bjensen", (Object)user.getProfileUrl());
        SCIMUser.Emails[] emails = user.getEmails();
        Assert.assertEquals((long)2L, (long)emails.length);
        Assert.assertEquals((long)2L, (long)user.getAddresses().length);
        Assert.assertEquals((long)2L, (long)user.getPhoneNumbers().length);
        SCIMUser.Ims[] ims = user.getIms();
        Assert.assertEquals((long)1L, (long)ims.length);
        SCIMUser.Ims im = ims[0];
        Assert.assertEquals((Object)"someaimhandle", (Object)im.getValue());
        Assert.assertEquals((Object)"aim", (Object)im.getType());
        Assert.assertEquals((long)2L, (long)user.getPhotos().length);
        Assert.assertEquals((Object)"Employee", (Object)user.getUserType());
        Assert.assertEquals((Object)"Tour Guide", (Object)user.getTitle());
        Assert.assertEquals((Object)"en_US", (Object)user.getPreferredLanguage());
        Assert.assertEquals((Object)"en_US", (Object)user.getLocale());
        Assert.assertEquals((Object)"America/Los_Angeles", (Object)user.getTimezone());
        Assert.assertTrue((boolean)user.isActive());
        Assert.assertEquals((Object)"t1meMa$heen", (Object)user.getPassword());
        Assert.assertEquals((long)3L, (long)user.getGroups().length);
        Assert.assertEquals((long)1L, (long)user.getX509Certificates().length);
        Meta meta = user.getMeta();
        Assert.assertEquals((Object)"2010-01-23T04:56:22Z", (Object)meta.getCreated());
        Assert.assertEquals((Object)"2011-05-13T04:42:34Z", (Object)meta.getLastModified());
        Assert.assertEquals((Object)"W\"a330bc54f0671c9\"", (Object)meta.getVersion());
        Assert.assertEquals((Object)"https://example.com/v1/Users/2819c223-7f76-453a-919d-413861904646", (Object)meta.getLocation());
    }
}

