/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.scim.endpoints;

import java.io.Serializable;
import java.net.URL;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.picketlink.idm.jpa.model.sample.simple.AccountTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.AttributeTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.GroupTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.IdentityTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.PartitionTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.PasswordCredentialTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.RelationshipIdentityTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.RelationshipTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.RoleTypeEntity;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.Group;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.scim.PicketLinkSCIMApplication;
import org.picketlink.test.scim.EmbeddedWebServerBase;

public abstract class AbstractEndpointTestCase
extends EmbeddedWebServerBase {
    protected String storedUserId = null;
    protected String storedGroupId = null;

    protected void populateIDM() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"picketlink-scim-pu");
        final EntityManager entityManager = entityManagerFactory.createEntityManager();
        entityManager.getTransaction().begin();
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        builder.named("default").stores().jpa().mappedEntity(new Class[]{AccountTypeEntity.class, RoleTypeEntity.class, GroupTypeEntity.class, IdentityTypeEntity.class, RelationshipTypeEntity.class, RelationshipIdentityTypeEntity.class, PartitionTypeEntity.class, PasswordCredentialTypeEntity.class, AttributeTypeEntity.class}).supportGlobalRelationship(new Class[]{Relationship.class}).addContextInitializer(new ContextInitializer(){

            public void initContextForStore(IdentityContext context, IdentityStore<?> store) {
                context.setParameter("CTX_ENTITY_MANAGER", (Object)entityManager);
            }
        }).supportAllFeatures();
        IdentityConfiguration identityConfig = builder.build();
        DefaultPartitionManager partitionManager = new DefaultPartitionManager(identityConfig);
        List partitions = partitionManager.getPartitions(Realm.class);
        if (partitions != null) {
            for (Partition partition : partitions) {
                if (!partition.getName().equalsIgnoreCase("default")) continue;
                partitionManager.remove(partition);
            }
        }
        partitionManager.add((Partition)new Realm("default"));
        IdentityManager identityManager = partitionManager.createIdentityManager();
        User anil = BasicModel.getUser((IdentityManager)identityManager, (String)"anil");
        if (anil == null) {
            User admin = new User("anil");
            admin.setAttribute(new Attribute("ID", (Serializable)((Object)"1234")));
            admin.setEmail("admin@acme.com");
            identityManager.add((IdentityType)admin);
            identityManager.updateCredential((Account)admin, (Object)new Password("tough"));
            Role roleAdmin = new Role("administrator");
            identityManager.add((IdentityType)roleAdmin);
            RelationshipManager relationshipManager = partitionManager.createRelationshipManager();
            BasicModel.grantRole((RelationshipManager)relationshipManager, (IdentityType)admin, (Role)roleAdmin);
            Group group = new Group("SomeGroup");
            group.setAttribute(new Attribute("ID", (Serializable)((Object)"jboss_groupid")));
            identityManager.add((IdentityType)group);
            anil = BasicModel.getUser((IdentityManager)identityManager, (String)"anil");
        }
        Group storedGroup = BasicModel.getGroup((IdentityManager)identityManager, (String)"SomeGroup");
        this.storedGroupId = storedGroup.getId();
        this.storedUserId = anil.getId();
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Override
    protected void establishUserApps() {
        this.populateIDM();
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl == null) {
            tcl = this.getClass().getClassLoader();
        }
        String WEBAPPDIR = "scim";
        String CONTEXTPATH = "/*";
        URL warUrl = tcl.getResource("scim");
        String warUrlString = warUrl.toExternalForm();
        WebAppContext context = this.createWebApp("/*", warUrlString);
        context.setClassLoader(this.getClass().getClassLoader());
        context.setExtraClasspath(warUrlString + "/..");
        context.setConfigurationClasses(new String[]{"org.eclipse.jetty.webapp.WebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.MetaInfConfiguration", "org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration", "org.eclipse.jetty.webapp.TagLibConfiguration"});
        context.setContextPath("/");
        ServletHolder servletHolder = new ServletHolder((Servlet)new HttpServletDispatcher());
        servletHolder.setInitParameter("javax.ws.rs.Application", PicketLinkSCIMApplication.class.getName());
        context.addServlet(servletHolder, "/*");
        this.server.setHandler((Handler)context);
    }
}

