/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.scim.endpoints;

import java.io.Serializable;
import java.net.URL;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.Group;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;
import org.picketlink.scim.PicketLinkSCIMApplication;
import org.picketlink.test.scim.EmbeddedWebServerBase;

public abstract class AbstractEndpointTestCase
extends EmbeddedWebServerBase {
    protected void populateIDM() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"picketlink-scim-pu");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        entityManager.getTransaction().begin();
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        builder.named("default").stores().jpa();
        DefaultPartitionManager partitionManager = new DefaultPartitionManager(builder.build());
        partitionManager.add((Partition)new Realm("default"));
        IdentityManager identityManager = partitionManager.createIdentityManager();
        User anil = BasicModel.getUser((IdentityManager)identityManager, (String)"anil");
        if (anil == null) {
            User admin = new User("anil");
            admin.setAttribute(new Attribute("ID", (Serializable)((Object)"1234")));
            admin.setEmail("admin@acme.com");
            identityManager.add((IdentityType)admin);
            identityManager.updateCredential((Account)admin, (Object)new Password("tough"));
            Role roleAdmin = new Role("administrator");
            identityManager.add((IdentityType)roleAdmin);
            RelationshipManager relationshipManager = partitionManager.createRelationshipManager();
            BasicModel.grantRole((RelationshipManager)relationshipManager, (IdentityType)admin, (Role)roleAdmin);
            Group group = new Group("SomeGroup");
            group.setAttribute(new Attribute("ID", (Serializable)((Object)"jboss")));
            identityManager.add((IdentityType)group);
        }
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Override
    protected void establishUserApps() {
        this.populateIDM();
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl == null) {
            tcl = this.getClass().getClassLoader();
        }
        String WEBAPPDIR = "scim";
        String CONTEXTPATH = "/*";
        URL warUrl = tcl.getResource("scim");
        String warUrlString = warUrl.toExternalForm();
        WebAppContext context = this.createWebApp("/*", warUrlString);
        context.setClassLoader(this.getClass().getClassLoader());
        context.setExtraClasspath(warUrlString + "/..");
        context.setConfigurationClasses(new String[]{"org.eclipse.jetty.webapp.WebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.MetaInfConfiguration", "org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration", "org.eclipse.jetty.webapp.TagLibConfiguration"});
        context.setContextPath("/");
        ServletHolder servletHolder = new ServletHolder((Servlet)new HttpServletDispatcher());
        servletHolder.setInitParameter("javax.ws.rs.Application", PicketLinkSCIMApplication.class.getName());
        context.addServlet(servletHolder, "/*");
        this.server.setHandler((Handler)context);
    }
}

