/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.scim.providers;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jboss.logging.Logger;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.idm.jpa.internal.JPAContextInitializer;
import org.picketlink.idm.jpa.schema.CredentialObject;
import org.picketlink.idm.jpa.schema.CredentialObjectAttribute;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.IdentityObjectAttribute;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityObject;
import org.picketlink.idm.jpa.schema.RelationshipObject;
import org.picketlink.idm.jpa.schema.RelationshipObjectAttribute;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.scim.DataProvider;
import org.picketlink.scim.model.v11.SCIMGroups;
import org.picketlink.scim.model.v11.SCIMResource;
import org.picketlink.scim.model.v11.SCIMUser;
import org.picketlink.scim.model.v11.UserName;

public class PicketLinkIDMDataProvider
implements DataProvider {
    private static Logger log = Logger.getLogger(PicketLinkIDMDataProvider.class);
    protected EntityManagerFactory entityManagerFactory;
    protected ThreadLocal<EntityManager> entityManagerThreadLocal = new ThreadLocal();
    @Inject
    private IdentityManager identityManager;

    @Override
    public SCIMUser getUser(String id) {
        this.verifyIdentityManager();
        SCIMUser scimUser = new SCIMUser();
        IdentityQuery query = this.identityManager.createIdentityQuery(User.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"ID"), new Object[]{id});
        List result = query.getResultList();
        User user = null;
        if (result.size() > 0) {
            user = (User)result.get(0);
            scimUser.setId(id);
            UserName userName = new UserName();
            userName.setGivenName(user.getFirstName());
            userName.setFamilyName(user.getLastName());
            scimUser.setName(userName);
        }
        return scimUser;
    }

    @Override
    public SCIMGroups getGroups(String id) {
        this.verifyIdentityManager();
        SCIMGroups scimGroup = new SCIMGroups();
        IdentityQuery query = this.identityManager.createIdentityQuery(Group.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"ID"), new Object[]{id});
        List result = query.getResultList();
        Group group = null;
        if (result.size() > 0) {
            group = (Group)result.get(0);
        }
        if (group != null) {
            scimGroup.setDisplayName(group.getName());
            scimGroup.setId(id);
        }
        return scimGroup;
    }

    @Override
    public SCIMResource getResource(String id) {
        SCIMResource scimResource = new SCIMResource();
        return scimResource;
    }

    @Override
    public String createUser(SCIMUser user) {
        this.verifyIdentityManager();
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setLoginName(user.getDisplayName());
        UserName userName = user.getName();
        if (userName != null) {
            simpleUser.setFirstName(userName.getGivenName());
            simpleUser.setLastName(userName.getFamilyName());
            simpleUser.setAttribute(new Attribute("FullName", (Serializable)((Object)userName.getFormatted())));
        }
        this.identityManager.add((IdentityType)simpleUser);
        User storedUser = this.identityManager.getUser(user.getDisplayName());
        String id = storedUser.getId();
        return id;
    }

    @Override
    public String createGroup(SCIMGroups group) {
        this.verifyIdentityManager();
        SimpleGroup simpleGroup = new SimpleGroup(group.getDisplayName());
        this.identityManager.add((IdentityType)simpleGroup);
        Group storedGroup = this.identityManager.getGroup(group.getDisplayName());
        String id = storedGroup.getId();
        return id;
    }

    public PicketLinkIDMDataProvider setIdentityManager(IdentityManager im) {
        this.identityManager = im;
        return this;
    }

    @Override
    public void initializeConnection() {
        this.verifyIdentityManager();
        if (this.entityManagerFactory != null) {
            EntityManager entityManager = this.entityManagerFactory.createEntityManager();
            entityManager.getTransaction().begin();
            this.entityManagerThreadLocal.set(entityManager);
        }
    }

    @Override
    public void closeConnection() {
        if (this.entityManagerFactory != null) {
            EntityManager entityManager = this.entityManagerThreadLocal.get();
            if (entityManager != null) {
                entityManager.getTransaction().commit();
                entityManager.close();
            }
            this.entityManagerThreadLocal.remove();
        }
    }

    protected void verifyIdentityManager() {
        if (this.identityManager == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Identity Manager not injected. Creating JPA based Identity Manager");
            }
            this.createJPADrivenIdentityManager();
        }
    }

    protected void createJPADrivenIdentityManager() {
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"picketlink-scim-pu");
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)builder.stores().jpa().addRealm(new String[]{"default"})).identityClass(IdentityObject.class).attributeClass(IdentityObjectAttribute.class).relationshipClass(RelationshipObject.class).relationshipIdentityClass(RelationshipIdentityObject.class).relationshipAttributeClass(RelationshipObjectAttribute.class).credentialClass(CredentialObject.class).credentialAttributeClass(CredentialObjectAttribute.class).partitionClass(PartitionObject.class).supportAllFeatures()).addContextInitializer((ContextInitializer)new JPAContextInitializer(this.entityManagerFactory){

            public EntityManager getEntityManager() {
                return PicketLinkIDMDataProvider.this.entityManagerThreadLocal.get();
            }
        });
        this.identityManager = new IdentityManagerFactory(builder.build()).createIdentityManager();
    }
}

