/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.scim.endpoints;

import java.io.Serializable;
import java.net.URL;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.idm.jpa.internal.JPAContextInitializer;
import org.picketlink.idm.jpa.schema.CredentialObject;
import org.picketlink.idm.jpa.schema.CredentialObjectAttribute;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.IdentityObjectAttribute;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityObject;
import org.picketlink.idm.jpa.schema.RelationshipObject;
import org.picketlink.idm.jpa.schema.RelationshipObjectAttribute;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.scim.PicketLinkSCIMApplication;
import org.picketlink.test.scim.EmbeddedWebServerBase;

public abstract class AbstractEndpointTestCase
extends EmbeddedWebServerBase {
    protected void populateIDM() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"picketlink-scim-pu");
        final EntityManager entityManager = entityManagerFactory.createEntityManager();
        entityManager.getTransaction().begin();
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)builder.stores().jpa().addRealm(new String[]{"default"})).identityClass(IdentityObject.class).attributeClass(IdentityObjectAttribute.class).relationshipClass(RelationshipObject.class).relationshipIdentityClass(RelationshipIdentityObject.class).relationshipAttributeClass(RelationshipObjectAttribute.class).credentialClass(CredentialObject.class).credentialAttributeClass(CredentialObjectAttribute.class).partitionClass(PartitionObject.class).supportAllFeatures()).addContextInitializer((ContextInitializer)new JPAContextInitializer(entityManagerFactory){

            public EntityManager getEntityManager() {
                return entityManager;
            }
        });
        IdentityManager identityManager = new IdentityManagerFactory(builder.build()).createIdentityManager();
        User anil = identityManager.getUser("anil");
        if (anil == null) {
            SimpleUser admin = new SimpleUser("anil");
            admin.setAttribute(new Attribute("ID", (Serializable)((Object)"1234")));
            admin.setEmail("admin@acme.com");
            identityManager.add((IdentityType)admin);
            identityManager.updateCredential((Agent)admin, (Object)new Password("tough"));
            SimpleRole roleAdmin = new SimpleRole("administrator");
            identityManager.add((IdentityType)roleAdmin);
            identityManager.grantRole((IdentityType)admin, (Role)roleAdmin);
            SimpleGroup group = new SimpleGroup("SomeGroup");
            group.setAttribute(new Attribute("ID", (Serializable)((Object)"jboss")));
            identityManager.add((IdentityType)group);
        }
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Override
    protected void establishUserApps() {
        this.populateIDM();
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl == null) {
            tcl = this.getClass().getClassLoader();
        }
        String WEBAPPDIR = "scim";
        String CONTEXTPATH = "/*";
        URL warUrl = tcl.getResource("scim");
        String warUrlString = warUrl.toExternalForm();
        WebAppContext context = this.createWebApp("/*", warUrlString);
        context.setClassLoader(this.getClass().getClassLoader());
        context.setExtraClasspath(warUrlString + "/..");
        context.setConfigurationClasses(new String[]{"org.eclipse.jetty.webapp.WebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.MetaInfConfiguration", "org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration", "org.eclipse.jetty.webapp.TagLibConfiguration"});
        context.setContextPath("/");
        ServletHolder servletHolder = new ServletHolder((Servlet)new HttpServletDispatcher());
        servletHolder.setInitParameter("javax.ws.rs.Application", PicketLinkSCIMApplication.class.getName());
        context.addServlet(servletHolder, "/*");
        this.server.setHandler((Handler)context);
    }
}

