/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.picketlink.idm.ldap.internal.LDAPConstants;
import org.picketlink.idm.ldap.internal.LDAPEntry;
import org.picketlink.idm.model.Role;

public class LDAPRole
extends LDAPEntry
implements Role {
    private static final long serialVersionUID = 1L;
    private String roleName;

    public LDAPRole() {
        this(null);
    }

    public LDAPRole(String roleDNSuffix) {
        super(roleDNSuffix);
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add(LDAPConstants.GROUP_OF_NAMES);
        this.getLDAPAttributes().put(oc);
    }

    public LDAPRole(Attributes ldapAttributes, String roleDNSuffix) {
        this(roleDNSuffix);
        this.setLDAPAttributes(ldapAttributes);
    }

    public void setName(String roleName) {
        this.roleName = roleName;
        Attribute theAttribute = this.getLDAPAttributes().get("cn");
        if (theAttribute == null) {
            this.getLDAPAttributes().put("cn", roleName);
        } else {
            theAttribute.set(0, roleName);
        }
        this.getLDAPAttributes().put("member", " ");
    }

    public String getName() {
        Attribute cnAttribute;
        if (this.roleName == null && (cnAttribute = this.getLDAPAttributes().get("cn")) != null) {
            try {
                this.roleName = (String)cnAttribute.get();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.roleName;
    }

    public String getKey() {
        return String.format("%s%s", "ROLE://", this.getName());
    }
}

