/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.PasswordCredentialHandler;
import org.picketlink.idm.credential.internal.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.credential.spi.annotations.Stored;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.internal.util.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.NamedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.PropertyQueries;
import org.picketlink.idm.jpa.annotations.IDMAttribute;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroupRole;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

@CredentialHandlers(value={PasswordCredentialHandler.class, X509CertificateCredentialHandler.class})
public class JPAIdentityStore
implements IdentityStore<JPAIdentityStoreConfiguration>,
CredentialStore {
    public static final String INVOCATION_CTX_ENTITY_MANAGER = "CTX_ENTITY_MANAGER";
    public static final String EVENT_CONTEXT_USER_ENTITY = "USER_ENTITY";
    public static final String EVENT_CONTEXT_GROUP_ENTITY = "GROUP_ENTITY";
    public static final String EVENT_CONTEXT_ROLE_ENTITY = "ROLE_ENTITY";
    private JPAIdentityStoreConfiguration config;
    private IdentityStoreInvocationContext context;

    public void setup(JPAIdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        this.config = config;
        this.context = context;
    }

    public JPAIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    public void add(IdentityType identityType) {
        this.checkInvalidIdentityType(identityType);
        if (this.lookupIdentityObjectById(identityType) != null) {
            throw new IdentityManagementException("IdentityType already exists.");
        }
        try {
            IdentityTypeHandler<IdentityType> identityTypeManager = this.getConfig().getIdentityTypeManager(identityType.getClass());
            Object identity = identityTypeManager.createIdentityInstance(this.getContext().getRealm(), identityType, this);
            EntityManager em = this.getEntityManager();
            em.persist(identity);
            em.flush();
            this.updateAttributes(identityType, identity);
            AbstractBaseEvent event = identityTypeManager.raiseCreatedEvent(identityType, this);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, identity);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        }
        catch (Exception ex) {
            throw new IdentityManagementException("Exception while creating IdentityType [" + identityType + "].", (Throwable)ex);
        }
    }

    public void update(IdentityType identityType) {
        this.checkInvalidIdentityType(identityType);
        IdentityTypeHandler<IdentityType> identityTypeManager = this.getConfig().getIdentityTypeManager(identityType.getClass());
        Object identity = this.getIdentityObject(identityType);
        identityTypeManager.populateIdentityInstance(this.getContext().getRealm(), identity, identityType, this);
        this.updateAttributes(identityType, identity);
        EntityManager em = this.getEntityManager();
        em.merge(identity);
        em.flush();
        AbstractBaseEvent event = identityTypeManager.raiseUpdatedEvent(identityType, this);
        event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, identity);
        this.getContext().getEventBridge().raiseEvent((Object)event);
    }

    public void remove(IdentityType identityType) {
        this.checkInvalidIdentityType(identityType);
        EntityManager em = this.getEntityManager();
        IdentityTypeHandler<IdentityType> identityTypeManager = this.getConfig().getIdentityTypeManager(identityType.getClass());
        Object identity = this.getIdentityObject(identityType);
        identityTypeManager.remove(identity, identityType, this);
        this.removeCredentials(identity);
        this.removeAttributes(identity);
        this.removeMemberships(identity);
        em.remove(identity);
        em.flush();
        AbstractBaseEvent event = identityTypeManager.raiseDeletedEvent(identityType, this);
        event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, identity);
        this.getContext().getEventBridge().raiseEvent((Object)event);
    }

    public User getUser(String id) {
        if (id == null) {
            return null;
        }
        User user = this.getContext().getCache().lookupUser(this.context.getRealm(), id);
        if (user == null) {
            DefaultIdentityQuery<User> defaultIdentityQuery = new DefaultIdentityQuery<User>(User.class, this);
            defaultIdentityQuery.setParameter(User.ID, id);
            List<User> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                user = resultList.get(0);
            }
            this.getContext().getCache().putUser(this.context.getRealm(), user);
        }
        return user;
    }

    private void configurePartition(Partition partition, Object identity, IdentityType identityType) {
        if (this.getConfig().isModelPropertySet("IDENTITY_PARTITION")) {
            Object partitionInstance = this.getModelProperty(Object.class, identity, "IDENTITY_PARTITION");
            identityType.setPartition(this.convertPartitionEntityToPartition(partitionInstance));
        } else {
            identityType.setPartition(partition);
        }
    }

    public Group getGroup(String groupId) {
        if (groupId == null) {
            return null;
        }
        Realm partition = this.context.getRealm();
        Group group = this.getContext().getCache().lookupGroup((Partition)partition, groupId);
        if (group == null) {
            DefaultIdentityQuery<Group> defaultIdentityQuery = new DefaultIdentityQuery<Group>(Group.class, this);
            defaultIdentityQuery.setParameter(Group.NAME, groupId);
            List<Group> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                group = resultList.get(0);
            }
            this.getContext().getCache().putGroup((Partition)partition, group);
        }
        return group;
    }

    public Group getGroup(String name, Group parent) {
        if (name == null || parent == null) {
            return null;
        }
        Group group = this.getGroup(name);
        if (group.getParentGroup() == null || !group.getParentGroup().getName().equals(parent.getName())) {
            group = null;
        }
        return group;
    }

    public Role getRole(String name) {
        if (name == null) {
            return null;
        }
        Realm partition = this.context.getRealm();
        Role role = this.getContext().getCache().lookupRole((Partition)partition, name);
        if (role == null) {
            DefaultIdentityQuery<Role> defaultIdentityQuery = new DefaultIdentityQuery<Role>(Role.class, this);
            defaultIdentityQuery.setParameter(Role.NAME, name);
            List<Role> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                role = resultList.get(0);
            }
            this.getContext().getCache().putRole((Partition)partition, role);
        }
        return role;
    }

    public Agent getAgent(String id) {
        if (id == null) {
            return null;
        }
        Realm partition = this.context.getRealm();
        Object agent = this.getContext().getCache().lookupAgent(partition, id);
        if (agent == null) {
            DefaultIdentityQuery<Agent> defaultIdentityQuery = new DefaultIdentityQuery<Agent>(Agent.class, this);
            defaultIdentityQuery.setParameter(Agent.ID, id);
            List<Agent> resultList = defaultIdentityQuery.getResultList();
            agent = !resultList.isEmpty() ? resultList.get(0) : this.getUser(id);
            this.getContext().getCache().putAgent(partition, agent);
        }
        return agent;
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        ArrayList<IdentityType> result = new ArrayList<IdentityType>();
        try {
            EntityManager em = this.getEntityManager();
            JPACriteriaQueryBuilder criteriaBuilder = new JPACriteriaQueryBuilder(this, identityQuery);
            List<Predicate> predicates = criteriaBuilder.getPredicates();
            CriteriaQuery<?> criteria = criteriaBuilder.getCriteria();
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List queryResult = em.createQuery(criteria).getResultList();
            for (Object identity : queryResult) {
                String discriminator = this.getConfig().getModelProperty("IDENTITY_DISCRIMINATOR").getValue(identity).toString();
                IdentityTypeHandler<? extends IdentityType> identityTypeManager = this.getConfig().getIdentityTypeStores().get(discriminator);
                IdentityType identityType = identityTypeManager.createIdentityType(this.getContext().getRealm(), identity, this);
                this.configurePartition((Partition)this.getContext().getRealm(), identity, identityType);
                this.populateAttributes(identityType, identity);
                result.add(identityType);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error executing query.", (Throwable)e);
        }
        return result;
    }

    public GroupRole createMembership(IdentityType member, Group group, Role role) {
        Object membership;
        Group storedGroup;
        Agent storedAgent;
        Role storedRole;
        Property<Object> memberModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_MEMBER");
        Property<Object> roleModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_ROLE");
        Property<Object> groupModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_GROUP");
        SimpleGroupRole groupRole = null;
        if (member instanceof Agent) {
            storedRole = null;
            Object identityRole = null;
            if (role != null) {
                storedRole = this.getRole(role.getName());
                identityRole = this.lookupIdentityObjectById((IdentityType)storedRole);
            }
            storedAgent = null;
            Object identityUser = null;
            if (member != null) {
                storedAgent = this.getAgent(((Agent)member).getId());
                identityUser = this.lookupIdentityObjectById((IdentityType)storedAgent);
            }
            storedGroup = null;
            Object identityGroup = null;
            if (group != null) {
                storedGroup = this.getGroup(group.getName());
                identityGroup = this.lookupIdentityObjectById((IdentityType)storedGroup);
            }
            membership = null;
            try {
                membership = this.getConfig().getMembershipClass().newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not create membership type instance.", (Throwable)e);
            }
            if (storedRole != null && storedGroup != null) {
                try {
                    memberModelProperty.setValue(membership, identityUser);
                    roleModelProperty.setValue(membership, identityRole);
                    groupModelProperty.setValue(membership, identityGroup);
                }
                catch (Exception e) {}
            } else if (storedRole != null) {
                memberModelProperty.setValue(membership, identityUser);
                roleModelProperty.setValue(membership, identityRole);
            } else {
                memberModelProperty.setValue(membership, identityUser);
                groupModelProperty.setValue(membership, identityGroup);
            }
        } else {
            if (member instanceof Group) {
                throw new UnsupportedOperationException();
            }
            throw new IllegalArgumentException("The member parameter must be an instance of User or Group");
        }
        this.getEntityManager().persist(membership);
        this.getEntityManager().flush();
        groupRole = new SimpleGroupRole((IdentityType)storedAgent, storedRole, storedGroup);
        return groupRole;
    }

    public void removeMembership(IdentityType member, Group group, Role role) {
        Object identityRole;
        Property<Object> memberModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_MEMBER");
        Property<Object> roleModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_ROLE");
        Property<Object> groupModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_GROUP");
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getMembershipClass());
        Root root = criteria.from(this.getConfig().getMembershipClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object identityUser = this.lookupIdentityObjectById(member);
        predicates.add(builder.equal((Expression)root.get(memberModelProperty.getName()), identityUser));
        if (group != null && role != null) {
            identityRole = this.lookupIdentityObjectById((IdentityType)role);
            Object identityGroup = this.lookupIdentityObjectById((IdentityType)group);
            predicates.add(builder.equal((Expression)root.get(roleModelProperty.getName()), identityRole));
            predicates.add(builder.equal((Expression)root.get(groupModelProperty.getName()), identityGroup));
        } else {
            if (role != null) {
                identityRole = this.lookupIdentityObjectById((IdentityType)role);
                predicates.add(builder.equal((Expression)root.get(roleModelProperty.getName()), identityRole));
            }
            if (group != null) {
                Object identityGroup = this.lookupIdentityObjectById((IdentityType)group);
                predicates.add(builder.equal((Expression)root.get(groupModelProperty.getName()), identityGroup));
            }
        }
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List resultList = em.createQuery(criteria).getResultList();
        for (Object object : resultList) {
            em.remove(object);
        }
        em.flush();
    }

    public GroupRole getMembership(IdentityType member, Group group, Role role) {
        SimpleGroupRole groupRole = null;
        List<Object> resultList = Collections.emptyList();
        DefaultIdentityQuery defaultIdentityQuery = new DefaultIdentityQuery(member.getClass(), this);
        defaultIdentityQuery.setParameter(IdentityType.HAS_GROUP_ROLE, new SimpleGroupRole(member, role, group));
        resultList = defaultIdentityQuery.getResultList();
        if (!resultList.isEmpty()) {
            Agent storedAgent = this.getAgent(((Agent)member).getId());
            Role storedRole = null;
            Group storedGroup = null;
            if (role != null) {
                storedRole = this.getRole(role.getName());
            }
            if (group != null) {
                storedGroup = this.getGroup(group.getName());
            }
            groupRole = new SimpleGroupRole((IdentityType)storedAgent, storedRole, storedGroup);
        }
        return groupRole;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(IdentityType identity, Attribute<? extends Serializable> providedAttrib) {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(IdentityType identity, String name) {
        throw new UnsupportedOperationException();
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        throw new UnsupportedOperationException();
    }

    protected EntityManager getEntityManager() {
        if (!this.getContext().isParameterSet(INVOCATION_CTX_ENTITY_MANAGER)) {
            throw new IllegalStateException("Error while trying to determine EntityManager - context parameter not set.");
        }
        return (EntityManager)this.getContext().getParameter(INVOCATION_CTX_ENTITY_MANAGER);
    }

    private void storeAttribute(Object identity, Attribute<? extends Serializable> userAttribute) {
        Serializable value = userAttribute.getValue();
        Object[] values = null;
        values = value.getClass().isArray() ? (Object[])value : new Object[]{value};
        Property<Object> attributeNameProperty = this.getConfig().getAttributeNameProperty();
        Property<Object> attributeIdentityProperty = this.getConfig().getAttributeIdentityProperty();
        Property<Object> attributeValueProperty = this.getConfig().getAttributeValueProperty();
        try {
            for (Object attribValue : values) {
                Object newInstance = this.getConfig().getAttributeClass().newInstance();
                attributeNameProperty.setValue(newInstance, userAttribute.getName());
                attributeValueProperty.setValue(newInstance, attribValue);
                attributeIdentityProperty.setValue(newInstance, identity);
                this.getEntityManager().persist(newInstance);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating attributes.", (Throwable)e);
        }
    }

    private void removeAttributes(Object identity, List<String> attributesToRetain) {
        StringBuffer attributeNames = new StringBuffer();
        for (String string : attributesToRetain) {
            if (attributeNames.length() != 0) {
                attributeNames.append(",");
            }
            attributeNames.append("'").append(string).append("'");
        }
        List<?> storedAttributes = this.findAttributes(identity);
        for (Object attribute : storedAttributes) {
            String attributeName = this.getConfig().getAttributeNameProperty().getValue(attribute).toString();
            if (attributesToRetain.contains(attributeName)) continue;
            this.getEntityManager().remove(attribute);
        }
    }

    private void removeAllAttributes(Object identity) {
        this.removeAttributes(identity, Collections.<String>emptyList());
    }

    private List<?> findAttributes(IdentityType identityType, String idValue, Attribute<? extends Serializable> userAttribute) {
        Property<Object> attributeIdentityProperty = this.getConfig().getAttributeIdentityProperty();
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getAttributeClass());
        Root root = criteria.from(this.getConfig().getAttributeClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Join join = root.join(attributeIdentityProperty.getName());
        if (IDMUtil.isAgentType(identityType.getClass())) {
            predicates.add(builder.equal((Expression)join.get(this.getConfig().getIdentityIdProperty().getName()), (Object)idValue));
        } else {
            predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty("IDENTITY_NAME").getName()), (Object)idValue));
        }
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getAttributeNameProperty().getName()), (Object)userAttribute.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private List<?> findAttributes(Object object) {
        Class<?> attributeClass = this.getConfig().getAttributeClass();
        String identityProperty = this.getConfig().getAttributeIdentityProperty().getName();
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(attributeClass);
        Root root = criteria.from(attributeClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(identityProperty), object));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    protected Object lookupIdentityObjectById(IdentityType identityType) {
        String id = this.getIdentifierValue(identityType);
        if (id == null) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getIdentityClass());
        Root root = criteria.from(this.getConfig().getIdentityClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getDiscriminatorProperty().getName()), (Object)this.getConfig().getIdentityDiscriminator(identityType.getClass())));
        if (IDMUtil.isUserType(identityType.getClass()) || IDMUtil.isAgentType(identityType.getClass())) {
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getIdentityIdProperty().getName()), (Object)id));
        } else if (IDMUtil.isGroupType(identityType.getClass()) || IDMUtil.isRoleType(identityType.getClass()) || IDMUtil.isRelationshipType(identityType.getClass())) {
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getIdentityNameProperty().getName()), (Object)id));
        } else {
            throw new SecurityException("Could not lookup identity by id - unsupported IdentityType [" + identityType.getClass().getName() + "]");
        }
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new SecurityException("Error looking up identity by id - ambiguous identities found for id: [" + id + "]");
    }

    private void removeMemberships(Object object) {
        EntityManager em = this.getEntityManager();
        if (this.getConfig().getMembershipClass() != null) {
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.getConfig().getMembershipClass());
            Root root = criteria.from(this.getConfig().getMembershipClass());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("MEMBERSHIP_MEMBER").getName()), object));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List results = em.createQuery(criteria).getResultList();
            for (Object result : results) {
                em.remove(result);
            }
            criteria = builder.createQuery(this.getConfig().getMembershipClass());
            root = criteria.from(this.getConfig().getMembershipClass());
            predicates.clear();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("MEMBERSHIP_GROUP").getName()), object));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            results = em.createQuery(criteria).getResultList();
            for (Object result : results) {
                em.remove(result);
            }
            criteria = builder.createQuery(this.getConfig().getMembershipClass());
            root = criteria.from(this.getConfig().getMembershipClass());
            predicates.clear();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("MEMBERSHIP_ROLE").getName()), object));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            results = em.createQuery(criteria).getResultList();
            for (Object result : results) {
                em.remove(result);
            }
        }
    }

    private void removeAttributes(Object object) {
        EntityManager em = this.getEntityManager();
        if (this.getConfig().getAttributeClass() != null) {
            List<?> results = this.findAttributes(object);
            for (Object result : results) {
                em.remove(result);
            }
        }
    }

    private void removeCredentials(Object object) {
        EntityManager em = this.getEntityManager();
        if (this.getConfig().getCredentialClass() != null) {
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
            Root root = criteria.from(this.getConfig().getCredentialClass());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("CREDENTIAL_IDENTITY").getName()), object));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List results = em.createQuery(criteria).getResultList();
            for (Object credential : results) {
                CriteriaQuery attributeCriteria = builder.createQuery(this.getConfig().getCredentialAttributeClass());
                Root attributeRoot = attributeCriteria.from(this.getConfig().getCredentialAttributeClass());
                ArrayList<Predicate> attributePredicates = new ArrayList<Predicate>();
                Property<Object> attributeCredential = this.getConfig().getModelProperty("CREDENTIAL_ATTRIBUTE");
                attributePredicates.add(builder.equal((Expression)attributeRoot.get(attributeCredential.getName()), credential));
                List attributes = em.createQuery(attributeCriteria).getResultList();
                for (Object attribute : attributes) {
                    em.remove(attribute);
                }
                em.remove(credential);
            }
        }
    }

    <P> P getModelProperty(Class<P> propertyType, Object instance, String propertyName) {
        Property<Object> property = this.getConfig().getModelProperty(propertyName);
        return (P)(property == null ? null : property.getValue(instance));
    }

    void setModelProperty(Object instance, String propertyName, Object value) {
        this.setModelProperty(instance, propertyName, value, false);
    }

    void setModelProperty(Object instance, String propertyName, Object value, boolean required) {
        if (this.getConfig().isModelPropertySet(propertyName)) {
            this.getConfig().getModelProperty(propertyName).setValue(instance, value);
        } else if (required) {
            throw new IdentityManagementException("Model property [" + propertyName + "] has not been configured.");
        }
    }

    private void updateAttributes(IdentityType identityType, Object identity) {
        EntityManager em = this.getEntityManager();
        if (identityType.getAttributes() != null && !identityType.getAttributes().isEmpty()) {
            ArrayList<String> attributesToRetain = new ArrayList<String>();
            for (Attribute userAttribute : identityType.getAttributes()) {
                attributesToRetain.add(userAttribute.getName());
                try {
                    JPAIdentityStoreConfiguration.MappedAttribute mappedAttribute = this.getConfig().getAttributeProperties().get(userAttribute.getName());
                    if (mappedAttribute != null) {
                        for (String attribName : this.getConfig().getAttributeProperties().keySet()) {
                            JPAIdentityStoreConfiguration.MappedAttribute attrib = this.getConfig().getAttributeProperties().get(attribName);
                            if (!userAttribute.getName().equals(attribName)) continue;
                            attrib.getAttributeProperty().setValue(identity, userAttribute.getValue());
                        }
                        continue;
                    }
                    List<?> results = this.findAttributes(identityType, this.getIdentifierValue(identityType), (Attribute<? extends Serializable>)userAttribute);
                    for (Object object : results) {
                        em.remove(object);
                    }
                    this.storeAttribute(identity, (Attribute<? extends Serializable>)userAttribute);
                }
                catch (Exception e) {
                    throw new IdentityManagementException("Error setting attribute [" + userAttribute + "] for [" + identity + "]", (Throwable)e);
                }
            }
            if (attributesToRetain.isEmpty()) {
                this.removeAllAttributes(identity);
            } else {
                this.removeAttributes(identity, attributesToRetain);
            }
        }
    }

    private String getIdentifierValue(IdentityType identityType) {
        String value = null;
        if (IDMUtil.isUserType(identityType.getClass())) {
            value = ((User)identityType).getId();
        } else if (IDMUtil.isAgentType(identityType.getClass())) {
            value = ((Agent)identityType).getId();
        } else if (IDMUtil.isRoleType(identityType.getClass())) {
            value = ((Role)identityType).getName();
        } else if (IDMUtil.isGroupType(identityType.getClass())) {
            value = ((Group)identityType).getName();
        } else if (IDMUtil.isRelationshipType(identityType.getClass())) {
            value = ((Relationship)identityType).getName();
        }
        return value;
    }

    private void populateAttributes(IdentityType identityType, Object identity) {
        try {
            for (JPAIdentityStoreConfiguration.MappedAttribute attrib : this.getConfig().getAttributeProperties().values()) {
                if (attrib.getIdentityProperty() != null && attrib.getIdentityProperty().getValue(identity) == null) continue;
                Member member = attrib.getAttributeProperty().getMember();
                String mappedName = null;
                Object value = null;
                if (member instanceof Field) {
                    Field field = (Field)member;
                    IDMAttribute annotation = field.getAnnotation(IDMAttribute.class);
                    field.setAccessible(true);
                    mappedName = annotation.name();
                    value = field.get(identity);
                }
                identityType.setAttribute(new Attribute(mappedName, (Serializable)value));
            }
            if (this.getConfig().getAttributeClass() != null) {
                EntityManager em = this.getEntityManager();
                CriteriaBuilder builder = em.getCriteriaBuilder();
                CriteriaQuery criteria = builder.createQuery(this.getConfig().getAttributeClass());
                Root attributeClassRoot = criteria.from(this.getConfig().getAttributeClass());
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                Join identityPropertyJoin = attributeClassRoot.join(this.getConfig().getAttributeIdentityProperty().getName());
                String propertyNameToJoin = this.getConfig().getIdentityIdProperty().getName();
                if (IDMUtil.isRoleType(identityType.getClass()) || IDMUtil.isGroupType(identityType.getClass()) || IDMUtil.isRelationshipType(identityType.getClass())) {
                    propertyNameToJoin = this.getConfig().getModelProperty("IDENTITY_NAME").getName();
                }
                predicates.add(builder.equal((Expression)identityPropertyJoin.get(propertyNameToJoin), (Object)this.getIdentifierValue(identityType)));
                criteria.where(predicates.toArray(new Predicate[predicates.size()]));
                List results = em.createQuery(criteria).getResultList();
                if (!results.isEmpty()) {
                    for (Object object : results) {
                        Property<Object> attributeNameProperty = this.getConfig().getAttributeNameProperty();
                        Property<Object> attributeValueProperty = this.getConfig().getAttributeValueProperty();
                        String attribName = (String)attributeNameProperty.getValue(object);
                        Serializable attribValue = (Serializable)attributeValueProperty.getValue(object);
                        Attribute identityTypeAttribute = identityType.getAttribute(attribName);
                        if (identityTypeAttribute == null) {
                            identityTypeAttribute = new Attribute(attribName, attribValue);
                            identityType.setAttribute(identityTypeAttribute);
                            continue;
                        }
                        if (identityTypeAttribute.getValue() == null) continue;
                        String[] values = null;
                        values = identityTypeAttribute.getValue().getClass().isArray() ? (String[])identityTypeAttribute.getValue() : new String[]{identityTypeAttribute.getValue().toString()};
                        String[] newValues = Arrays.copyOf(values, values.length + 1);
                        newValues[newValues.length - 1] = attribValue.toString();
                        identityTypeAttribute.setValue((Serializable)newValues);
                        identityType.setAttribute(identityTypeAttribute);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error setting attribute.", (Throwable)e);
        }
    }

    private Partition convertPartitionEntityToPartition(Object instance) {
        return null;
    }

    Object lookupPartitionObject(Partition partition) {
        return null;
    }

    private void checkInvalidIdentityType(IdentityType identityType) throws IdentityManagementException {
        if (identityType == null) {
            throw new IdentityManagementException("The provided IdentityType instance is invalid or was null.");
        }
    }

    private Object getIdentityObject(IdentityType identityType) throws IdentityManagementException {
        Object identity = this.lookupIdentityObjectById(identityType);
        if (identity == null) {
            throw new IdentityManagementException("The provided IdentityType instance does not exists.");
        }
        return identity;
    }

    public void validateCredentials(Credentials credentials) {
        CredentialHandler handler = this.getContext().getCredentialValidator(credentials.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for validating Credentials of type [" + credentials.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.validate(credentials, (IdentityStore)this);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        CredentialHandler handler = this.getContext().getCredentialUpdater(credential.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for updating Credentials of type [" + credential.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.update(agent, credential, (IdentityStore)this, effectiveDate, expiryDate);
    }

    public void storeCredential(Agent agent, CredentialStorage storage) {
        Property<Object> identityTypeProperty = this.getConfig().getModelProperty("CREDENTIAL_IDENTITY");
        Property<Object> typeProperty = this.getConfig().getModelProperty("CREDENTIAL_TYPE");
        Property<Object> effectiveProperty = this.getConfig().getModelProperty("CREDENTIAL_EFFECTIVE_DATE");
        Property<Object> expiryProperty = this.getConfig().getModelProperty("CREDENTIAL_EXPIRY_DATE");
        Object lastCredential = this.retrieveCurrentCredentialEntity(agent, storage.getClass());
        EntityManager em = this.getEntityManager();
        if (lastCredential != null) {
            expiryProperty.setValue(lastCredential, new Date());
            em.merge(lastCredential);
        }
        Object newCredential = null;
        try {
            newCredential = this.getConfig().getCredentialClass().newInstance();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not instantiate credential class [" + this.getConfig().getCredentialClass().getName() + "].", (Throwable)e);
        }
        Date effectiveDate = storage.getEffectiveDate();
        if (effectiveDate == null) {
            effectiveDate = new Date();
        }
        Object agentInstance = this.lookupIdentityObjectById((IdentityType)agent);
        identityTypeProperty.setValue(newCredential, agentInstance);
        typeProperty.setValue(newCredential, storage.getClass().getName());
        effectiveProperty.setValue(newCredential, effectiveDate);
        expiryProperty.setValue(newCredential, storage.getExpiryDate());
        em.persist(newCredential);
        List annotatedTypes = PropertyQueries.createQuery(storage.getClass()).addCriteria(new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        Property<Object> attributeName = this.getConfig().getModelProperty("CREDENTIAL_ATTRIBUTE_NAME");
        Property<Object> attributeValue = this.getConfig().getModelProperty("CREDENTIAL_ATTRIBUTE_VALUE");
        Property<Object> attributeType = this.getConfig().getModelProperty("CREDENTIAL_ATTRIBUTE_TYPE");
        Property<Object> attributeCredential = this.getConfig().getModelProperty("CREDENTIAL_ATTRIBUTE");
        for (Property property : annotatedTypes) {
            if (!property.getJavaClass().equals(String.class)) continue;
            Object newCredentialAttribute = null;
            try {
                newCredentialAttribute = this.getConfig().getCredentialAttributeClass().newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not instantiate credential attribute class [" + this.getConfig().getCredentialAttributeClass().getName() + "].", (Throwable)e);
            }
            attributeName.setValue(newCredentialAttribute, property.getName());
            attributeValue.setValue(newCredentialAttribute, Base64.encodeObject((Serializable)property.getValue(storage)));
            attributeType.setValue(newCredentialAttribute, property.getJavaClass().getName());
            attributeCredential.setValue(newCredentialAttribute, newCredential);
            em.persist(newCredentialAttribute);
        }
        em.flush();
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Agent agent, Class<T> storageClass) {
        Object lastCredential = this.retrieveCurrentCredentialEntity(agent, storageClass);
        return (T)this.convertToCredentialStorage(lastCredential, storageClass);
    }

    private <T> Object retrieveCurrentCredentialEntity(Agent agent, Class<T> storageClass) {
        Property<Object> identityTypeProperty = this.getConfig().getModelProperty("CREDENTIAL_IDENTITY");
        Property<Object> typeProperty = this.getConfig().getModelProperty("CREDENTIAL_TYPE");
        Property<Object> effectiveProperty = this.getConfig().getModelProperty("CREDENTIAL_EFFECTIVE_DATE");
        Property<Object> expiryProperty = this.getConfig().getModelProperty("CREDENTIAL_EXPIRY_DATE");
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
        Root root = criteria.from(this.getConfig().getCredentialClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object agentInstance = this.lookupIdentityObjectById((IdentityType)agent);
        predicates.add(builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
        predicates.add(builder.equal((Expression)root.get(typeProperty.getName()), (Object)storageClass.getName()));
        Predicate conjunction = builder.conjunction();
        conjunction.getExpressions().add(builder.or((Expression)builder.greaterThanOrEqualTo((Expression)root.get(expiryProperty.getName()), (Comparable)new Date()), (Expression)builder.isNull((Expression)root.get(expiryProperty.getName()))));
        predicates.add(conjunction);
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        criteria.orderBy(new Order[]{builder.desc((Expression)root.get(effectiveProperty.getName()))});
        Object lastCredential = null;
        try {
            List result = em.createQuery(criteria).getResultList();
            if (!result.isEmpty()) {
                lastCredential = result.get(0);
            }
        }
        catch (NoResultException ignore) {
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not query credentials.", (Throwable)e);
        }
        return lastCredential;
    }

    private CredentialStorage convertToCredentialStorage(Object instance, Class<? extends CredentialStorage> storageClass) {
        CredentialStorage storage = null;
        if (instance != null) {
            try {
                storage = storageClass.newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not instantiate storage class [" + storageClass.getName() + "].", (Throwable)e);
            }
            Property<Object> effectiveProperty = this.getConfig().getModelProperty("CREDENTIAL_EFFECTIVE_DATE");
            Property<Object> expiryProperty = this.getConfig().getModelProperty("CREDENTIAL_EXPIRY_DATE");
            List effectiveDateProperty = PropertyQueries.createQuery(storageClass).addCriteria(new NamedPropertyCriteria("effectiveDate")).getResultList();
            effectiveDateProperty.get(0).setValue(storage, effectiveProperty.getValue(instance));
            List expiryDateProperty = PropertyQueries.createQuery(storageClass).addCriteria(new NamedPropertyCriteria("expiryDate")).getResultList();
            expiryDateProperty.get(0).setValue(storage, expiryProperty.getValue(instance));
            EntityManager em = this.getEntityManager();
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery attributeCriteria = builder.createQuery(this.getConfig().getCredentialAttributeClass());
            Root attributeRoot = attributeCriteria.from(this.getConfig().getCredentialAttributeClass());
            ArrayList<Predicate> attributePredicates = new ArrayList<Predicate>();
            Property<Object> attributeCredential = this.getConfig().getModelProperty("CREDENTIAL_ATTRIBUTE");
            attributePredicates.add(builder.equal((Expression)attributeRoot.get(attributeCredential.getName()), instance));
            attributeCriteria.where(attributePredicates.toArray(new Predicate[attributePredicates.size()]));
            List attributes = em.createQuery(attributeCriteria).getResultList();
            Property<Object> attributeName = this.getConfig().getModelProperty("CREDENTIAL_ATTRIBUTE_NAME");
            Property<Object> attributeValue = this.getConfig().getModelProperty("CREDENTIAL_ATTRIBUTE_VALUE");
            for (Object attribute : attributes) {
                String name = attributeName.getValue(attribute).toString();
                String value = attributeValue.getValue(attribute).toString();
                List annotatedTypes = PropertyQueries.createQuery(storageClass).addCriteria(new NamedPropertyCriteria(name)).getResultList();
                if (annotatedTypes.isEmpty()) {
                    throw new IdentityManagementException("Could not find property [" + attributeName.getName() + "] on CredentialStorage [" + storageClass.getName() + "].");
                }
                if (annotatedTypes.size() > 1) {
                    throw new IdentityManagementException("Ambiguos property [" + attributeName.getName() + "] on CredentialStorage [" + storageClass.getName() + "].");
                }
                Property<Object> property = annotatedTypes.get(0);
                property.setValue(storage, Base64.decodeToObject(value));
            }
        }
        return storage;
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Agent agent, Class<T> storageClass) {
        Property<Object> identityTypeProperty = this.getConfig().getModelProperty("CREDENTIAL_IDENTITY");
        Property<Object> typeProperty = this.getConfig().getModelProperty("CREDENTIAL_TYPE");
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
        Root root = criteria.from(this.getConfig().getCredentialClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object agentInstance = this.lookupIdentityObjectById((IdentityType)agent);
        predicates.add(builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
        predicates.add(builder.equal((Expression)root.get(typeProperty.getName()), (Object)storageClass.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List result = em.createQuery(criteria).getResultList();
        ArrayList<CredentialStorage> storages = new ArrayList<CredentialStorage>();
        for (Object object : result) {
            storages.add(this.convertToCredentialStorage(object, storageClass));
        }
        return storages;
    }
}

