/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.DigestCredentialHandler;
import org.picketlink.idm.credential.internal.PasswordCredentialHandler;
import org.picketlink.idm.credential.internal.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.credential.spi.annotations.Stored;
import org.picketlink.idm.event.AgentCreatedEvent;
import org.picketlink.idm.event.AgentDeletedEvent;
import org.picketlink.idm.event.AgentUpdatedEvent;
import org.picketlink.idm.event.GroupCreatedEvent;
import org.picketlink.idm.event.GroupDeletedEvent;
import org.picketlink.idm.event.GroupUpdatedEvent;
import org.picketlink.idm.event.RoleCreatedEvent;
import org.picketlink.idm.event.RoleDeletedEvent;
import org.picketlink.idm.event.RoleUpdatedEvent;
import org.picketlink.idm.event.UserCreatedEvent;
import org.picketlink.idm.event.UserDeletedEvent;
import org.picketlink.idm.event.UserUpdatedEvent;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FileIdentityStoreConfiguration;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.internal.util.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.NamedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.PropertyQueries;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleGroupRole;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

@CredentialHandlers(value={PasswordCredentialHandler.class, X509CertificateCredentialHandler.class, DigestCredentialHandler.class})
public class FileBasedIdentityStore
implements IdentityStore<FileIdentityStoreConfiguration>,
CredentialStore {
    private FileIdentityStoreConfiguration config;
    private IdentityStoreInvocationContext context;

    public void setup(FileIdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        this.config = config;
        this.context = context;
    }

    public FileIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    public void add(IdentityType identityType) {
        Class<?> identityTypeClass = identityType.getClass();
        if (IDMUtil.isUserType(identityTypeClass)) {
            User storedUser = this.addUser((User)identityType);
            UserCreatedEvent event = new UserCreatedEvent(storedUser);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (IDMUtil.isAgentType(identityTypeClass)) {
            Agent storedAgent = this.addAgent((Agent)identityType);
            AgentCreatedEvent event = new AgentCreatedEvent(storedAgent);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (IDMUtil.isGroupType(identityTypeClass)) {
            Group storedGroup = this.addGroup((Group)identityType);
            GroupCreatedEvent event = new GroupCreatedEvent(storedGroup);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (IDMUtil.isRoleType(identityTypeClass)) {
            Role storedRole = this.addRole((Role)identityType);
            RoleCreatedEvent event = new RoleCreatedEvent(storedRole);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else {
            throw new IdentityManagementException("Unsupported IdentityType [" + identityTypeClass.getName() + "].");
        }
    }

    public void update(IdentityType identityType) {
        Class<?> identityTypeClass = identityType.getClass();
        if (IDMUtil.isUserType(identityTypeClass)) {
            User updatedUser = (User)identityType;
            if (updatedUser.getId() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            User storedUser = this.getUser(updatedUser.getId());
            if (storedUser == null) {
                throw new RuntimeException("User [" + updatedUser.getId() + "] does not exists.");
            }
            this.updateUser(updatedUser, storedUser);
            UserUpdatedEvent event = new UserUpdatedEvent(storedUser);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (IDMUtil.isAgentType(identityTypeClass)) {
            Agent updatedAgent = (Agent)identityType;
            if (updatedAgent.getId() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            Agent storedAgent = this.getAgent(updatedAgent.getId());
            if (storedAgent == null) {
                throw new RuntimeException("Agent [" + updatedAgent.getId() + "] does not exists.");
            }
            this.updateAgent(updatedAgent, storedAgent);
            AgentUpdatedEvent event = new AgentUpdatedEvent(storedAgent);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (IDMUtil.isGroupType(identityTypeClass)) {
            Group updatedGroup = (Group)identityType;
            if (updatedGroup.getName() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            Group storedGroup = this.getGroup(updatedGroup.getName());
            if (storedGroup == null) {
                throw new RuntimeException("No group found with the given name [" + updatedGroup.getName() + "].");
            }
            this.updateGroup(updatedGroup, storedGroup);
            GroupUpdatedEvent event = new GroupUpdatedEvent(storedGroup);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (IDMUtil.isRoleType(identityTypeClass)) {
            Role updatedRole = (Role)identityType;
            if (updatedRole.getName() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            Role storedRole = this.getRole(updatedRole.getName());
            if (storedRole == null) {
                throw new RuntimeException("No role found with the given name [" + updatedRole.getName() + "].");
            }
            this.updateRole(updatedRole, storedRole);
            RoleUpdatedEvent event = new RoleUpdatedEvent(storedRole);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else {
            throw new IdentityManagementException("Unsupported IdentityType [" + identityTypeClass.getName() + "].");
        }
    }

    public void remove(IdentityType identityType) {
        Class<?> identityTypeClass = identityType.getClass();
        if (IDMUtil.isUserType(identityTypeClass)) {
            User user = (User)identityType;
            if (user.getId() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            User storedUser = this.getUser(user.getId());
            if (storedUser == null) {
                throw new RuntimeException("User [" + user.getId() + "] doest not exists.");
            }
            this.removeUser(storedUser);
            UserDeletedEvent event = new UserDeletedEvent(storedUser);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (IDMUtil.isAgentType(identityTypeClass)) {
            Agent agent = (Agent)identityType;
            if (agent.getId() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            Agent storedAgent = this.getAgent(agent.getId());
            if (storedAgent == null) {
                throw new RuntimeException("Agent [" + agent.getId() + "] doest not exists.");
            }
            this.removeAgent(storedAgent);
            AgentDeletedEvent event = new AgentDeletedEvent(storedAgent);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (IDMUtil.isGroupType(identityTypeClass)) {
            Group group = (Group)identityType;
            if (group.getName() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            Group storedGroup = this.getGroup(group.getName());
            if (storedGroup == null) {
                throw new RuntimeException("Group [" + group.getName() + "] doest not exists.");
            }
            this.removeGroup(storedGroup);
            GroupDeletedEvent event = new GroupDeletedEvent(storedGroup);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (IDMUtil.isRoleType(identityTypeClass)) {
            Role role = (Role)identityType;
            if (role.getName() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            Role storedRole = this.getRole(role.getName());
            if (storedRole == null) {
                throw new RuntimeException("Role [" + role.getName() + "] doest not exists.");
            }
            this.removeRole(storedRole);
            RoleDeletedEvent event = new RoleDeletedEvent(storedRole);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        }
    }

    private Role addRole(Role role) {
        SimpleRole fileRole = new SimpleRole(role.getName());
        this.updateCommonProperties((IdentityType)role, (IdentityType)fileRole);
        this.getConfig().getRoles().put(fileRole.getName(), (Role)fileRole);
        this.flushRoles();
        return fileRole;
    }

    private Group addGroup(Group group) {
        SimpleGroup fileGroup = null;
        fileGroup = group.getParentGroup() != null ? new SimpleGroup(group.getName(), this.getGroup(group.getParentGroup().getName())) : new SimpleGroup(group.getName());
        this.updateCommonProperties((IdentityType)group, (IdentityType)fileGroup);
        this.getConfig().getGroups().put(fileGroup.getName(), (Group)fileGroup);
        this.flushGroups();
        return fileGroup;
    }

    private User addUser(User user) {
        SimpleUser storedUser = new SimpleUser(user.getId());
        storedUser.setFirstName(user.getFirstName());
        storedUser.setLastName(user.getLastName());
        storedUser.setEmail(user.getEmail());
        this.updateCommonProperties((IdentityType)user, (IdentityType)storedUser);
        this.getConfig().getUsers().put(storedUser.getId(), (Agent)storedUser);
        this.flushUsers();
        return storedUser;
    }

    private Agent addAgent(Agent user) {
        SimpleAgent storedAgent = new SimpleAgent(user.getId());
        this.updateCommonProperties((IdentityType)user, (IdentityType)storedAgent);
        this.getConfig().getUsers().put(storedAgent.getId(), (Agent)storedAgent);
        this.flushUsers();
        return storedAgent;
    }

    private Role updateRole(Role updatedRole, Role storedRole) {
        if (storedRole != updatedRole) {
            this.updateCommonProperties((IdentityType)updatedRole, (IdentityType)storedRole);
        }
        this.getConfig().getRoles().put(storedRole.getName(), storedRole);
        this.flushRoles();
        return storedRole;
    }

    private Group updateGroup(Group updatedGroup, Group storedGroup) {
        if (storedGroup != updatedGroup) {
            this.updateCommonProperties((IdentityType)updatedGroup, (IdentityType)storedGroup);
        }
        this.getConfig().getGroups().put(storedGroup.getName(), storedGroup);
        this.flushGroups();
        return storedGroup;
    }

    private User updateUser(User updatedUser, User storedUser) {
        if (storedUser != updatedUser) {
            storedUser.setFirstName(updatedUser.getFirstName());
            storedUser.setLastName(updatedUser.getLastName());
            storedUser.setEmail(updatedUser.getEmail());
            this.updateCommonProperties((IdentityType)updatedUser, (IdentityType)storedUser);
        }
        this.getConfig().getUsers().put(storedUser.getId(), (Agent)storedUser);
        this.flushUsers();
        return updatedUser;
    }

    private Agent updateAgent(Agent updatedAgent, Agent storedAgent) {
        if (storedAgent != updatedAgent) {
            this.updateCommonProperties((IdentityType)updatedAgent, (IdentityType)storedAgent);
        }
        this.getConfig().getUsers().put(storedAgent.getId(), storedAgent);
        this.flushUsers();
        return updatedAgent;
    }

    private Role removeRole(Role role) {
        this.getConfig().getRoles().remove(role.getName());
        for (GroupRole membership : new ArrayList<GroupRole>(this.getConfig().getMemberships())) {
            Role roleMembership = membership.getRole();
            if (roleMembership == null || !roleMembership.getName().equals(role.getName())) continue;
            this.getConfig().getMemberships().remove(membership);
        }
        this.flushRoles();
        this.flushMemberships();
        return role;
    }

    private Group removeGroup(Group group) {
        this.getConfig().getGroups().remove(group.getName());
        for (GroupRole membership : new ArrayList<GroupRole>(this.getConfig().getMemberships())) {
            Group groupMembership = membership.getGroup();
            if (groupMembership == null || !groupMembership.getName().equals(group.getName())) continue;
            this.getConfig().getMemberships().remove(membership);
        }
        this.flushGroups();
        this.flushMemberships();
        return group;
    }

    private User removeUser(User user) {
        this.getConfig().getUsers().remove(user.getId());
        for (GroupRole membership : new ArrayList<GroupRole>(this.getConfig().getMemberships())) {
            User userMember;
            IdentityType member = membership.getMember();
            if (!IDMUtil.isUserType(member.getClass()) || !(userMember = (User)member).getId().equals(user.getId())) continue;
            this.getConfig().getMemberships().remove(membership);
        }
        this.flushUsers();
        this.flushMemberships();
        return user;
    }

    private Agent removeAgent(Agent user) {
        this.getConfig().getUsers().remove(user.getId());
        for (GroupRole membership : new ArrayList<GroupRole>(this.getConfig().getMemberships())) {
            Agent userMember;
            IdentityType member = membership.getMember();
            if (!IDMUtil.isAgentType(member.getClass()) || !(userMember = (Agent)member).getId().equals(user.getId())) continue;
            this.getConfig().getMemberships().remove(membership);
        }
        this.flushUsers();
        this.flushMemberships();
        return user;
    }

    public Agent getAgent(String id) {
        return this.getConfig().getUsers().get(id);
    }

    public User getUser(String id) {
        Agent agent = this.getAgent(id);
        if (!User.class.isInstance(agent)) {
            return null;
        }
        return (User)agent;
    }

    public Role getRole(String role) {
        return this.getConfig().getRoles().get(role);
    }

    public Group getGroup(String groupId) {
        return this.getConfig().getGroups().get(groupId);
    }

    public Group getGroup(String name, Group parent) {
        Group group = this.getGroup(name);
        Group parentGroup = group.getParentGroup();
        if (parentGroup == null || !parentGroup.getName().equals(parent.getName())) {
            group = null;
        }
        return group;
    }

    public GroupRole createMembership(IdentityType member, Group group, Role role) {
        SimpleGroupRole membership = new SimpleGroupRole(member, role, group);
        this.getConfig().getMemberships().add((GroupRole)membership);
        this.flushMemberships();
        return membership;
    }

    public void removeMembership(IdentityType member, Group group, Role role) {
        for (GroupRole membership : new ArrayList<GroupRole>(this.getConfig().getMemberships())) {
            Agent providedMember = (Agent)member;
            Agent membershipMember = (Agent)membership.getMember();
            if (membershipMember == null || providedMember == null || !membershipMember.getId().equals(providedMember.getId()) || !this.hasGroupRole(membership, group, role)) continue;
            this.getConfig().getMemberships().remove(membership);
        }
        this.flushMemberships();
    }

    public GroupRole getMembership(IdentityType member, Group group, Role role) {
        for (GroupRole membership : new ArrayList<GroupRole>(this.getConfig().getMemberships())) {
            Agent providedMember = (Agent)member;
            Agent membershipMember = (Agent)membership.getMember();
            if (membershipMember == null || providedMember == null || !membershipMember.getId().equals(providedMember.getId()) || !this.hasGroupRole(membership, group, role)) continue;
            return membership;
        }
        return null;
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        Class identityTypeClass = identityQuery.getIdentityType();
        Set<Map.Entry<String, Agent>> entries = null;
        if (IDMUtil.isUserType(identityTypeClass)) {
            entries = this.getConfig().getUsers().entrySet();
        } else if (IDMUtil.isRoleType(identityTypeClass)) {
            entries = this.getConfig().getRoles().entrySet();
        } else if (IDMUtil.isGroupType(identityTypeClass)) {
            entries = this.getConfig().getGroups().entrySet();
        } else if (IDMUtil.isAgentType(identityTypeClass)) {
            entries = this.getConfig().getUsers().entrySet();
        }
        ArrayList<IdentityType> result = new ArrayList<IdentityType>();
        for (Map.Entry<String, Agent> entry : entries) {
            Date createdDate;
            IdentityType storedIdentityType = (IdentityType)entry.getValue();
            if (!identityTypeClass.isAssignableFrom(storedIdentityType.getClass())) continue;
            if (IDMUtil.isUserType(identityTypeClass)) {
                User user = (User)storedIdentityType;
                if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), User.ID, (Serializable)((Object)user.getId())) || !this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), User.EMAIL, (Serializable)((Object)user.getEmail())) || !this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), User.FIRST_NAME, (Serializable)((Object)user.getFirstName())) || !this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), User.LAST_NAME, (Serializable)((Object)user.getLastName()))) continue;
            }
            if (IDMUtil.isAgentType(identityTypeClass)) {
                Agent agent = (Agent)storedIdentityType;
                if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), Agent.ID, (Serializable)((Object)agent.getId()))) continue;
            }
            if (IDMUtil.isRoleType(identityTypeClass)) {
                Role role = (Role)storedIdentityType;
                if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), Role.NAME, (Serializable)((Object)role.getName()))) continue;
            }
            if (IDMUtil.isGroupType(identityTypeClass)) {
                Group group = (Group)storedIdentityType;
                if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), Group.NAME, (Serializable)((Object)group.getName()))) continue;
                String parentGroupName = null;
                if (group.getParentGroup() != null) {
                    parentGroupName = group.getParentGroup().getName();
                }
                if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), Group.PARENT, (Serializable)((Object)parentGroupName))) continue;
            }
            if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), IdentityType.ENABLED, Boolean.valueOf(storedIdentityType.isEnabled())) || (createdDate = storedIdentityType.getCreatedDate()) != null && (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), IdentityType.CREATED_DATE, createdDate) || !this.isQueryParameterLessThan(identityQuery.getParameters(), IdentityType.CREATED_BEFORE, createdDate.getTime()) || !this.isQueryParameterGreaterThan(identityQuery.getParameters(), IdentityType.CREATED_AFTER, createdDate.getTime()))) continue;
            Date expiryDate = storedIdentityType.getExpirationDate();
            if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), IdentityType.EXPIRY_DATE, expiryDate)) continue;
            Long expiryDateInMillis = null;
            if (expiryDate != null) {
                expiryDateInMillis = expiryDate.getTime();
            }
            if (!this.isQueryParameterLessThan(identityQuery.getParameters(), IdentityType.EXPIRY_BEFORE, expiryDateInMillis) || !this.isQueryParameterGreaterThan(identityQuery.getParameters(), IdentityType.EXPIRY_AFTER, expiryDateInMillis)) continue;
            result.add(storedIdentityType);
        }
        if (identityQuery.getParameters().containsKey(IdentityType.HAS_ROLE) || identityQuery.getParameters().containsKey(IdentityType.MEMBER_OF) || identityQuery.getParameters().containsKey(IdentityType.HAS_GROUP_ROLE) || identityQuery.getParameters().containsKey(IdentityType.ROLE_OF) || identityQuery.getParameters().containsKey(IdentityType.HAS_MEMBER)) {
            for (IdentityType fileUser : new ArrayList(result)) {
                for (Map.Entry parameters : identityQuery.getParameters().entrySet()) {
                    QueryParameter queryParameter = (QueryParameter)parameters.getKey();
                    Object[] values = (Object[])parameters.getValue();
                    int valuesMatchCount = values.length;
                    for (GroupRole membership : this.getConfig().getMemberships()) {
                        Agent agent;
                        if (IDMUtil.isAgentType(fileUser.getClass()) && IDMUtil.isAgentType(membership.getMember().getClass())) {
                            Agent selectedAgent = (Agent)fileUser;
                            Agent memberAgent = (Agent)membership.getMember();
                            if (!selectedAgent.getId().equals(memberAgent.getId())) continue;
                        }
                        if (queryParameter.equals(IdentityType.HAS_GROUP_ROLE) && membership.getGroup() != null && membership.getRole() != null) {
                            for (Object groupNames : values) {
                                GroupRole groupRole = (GroupRole)groupNames;
                                if (!groupRole.getGroup().getName().equals(membership.getGroup().getName()) || !groupRole.getRole().getName().equals(membership.getRole().getName())) continue;
                                --valuesMatchCount;
                            }
                            continue;
                        }
                        if (queryParameter.equals(IdentityType.HAS_ROLE) && membership.getRole() != null) {
                            for (Object roleNames : values) {
                                if (!roleNames.equals(membership.getRole().getName())) continue;
                                --valuesMatchCount;
                            }
                            continue;
                        }
                        if (queryParameter.equals(IdentityType.MEMBER_OF) && membership.getGroup() != null) {
                            for (Object groupNames : values) {
                                if (!groupNames.equals(membership.getGroup().getName())) continue;
                                --valuesMatchCount;
                            }
                            continue;
                        }
                        if (queryParameter.equals(IdentityType.ROLE_OF) && membership.getRole() != null) {
                            for (Object member : values) {
                                agent = (Agent)member;
                                if (agent == null || !agent.getKey().equals(membership.getMember().getKey()) || !membership.getRole().getKey().equals(fileUser.getKey())) continue;
                                --valuesMatchCount;
                            }
                            continue;
                        }
                        if (!queryParameter.equals(IdentityType.HAS_MEMBER) || membership.getGroup() == null) continue;
                        for (Object member : values) {
                            agent = (Agent)member;
                            if (agent == null || !agent.getKey().equals(membership.getMember().getKey()) || !membership.getGroup().getKey().equals(fileUser.getKey())) continue;
                            --valuesMatchCount;
                        }
                    }
                    if (valuesMatchCount <= 0) continue;
                    result.remove(fileUser);
                }
            }
        }
        this.findByCustomAttributes(result, identityQuery);
        return result;
    }

    private void findByCustomAttributes(List<? extends IdentityType> identityTypes, IdentityQuery identityQuery) {
        Set entrySet = identityQuery.getParameters().entrySet();
        for (IdentityType identityType : new ArrayList<IdentityType>(identityTypes)) {
            for (Map.Entry entry : entrySet) {
                QueryParameter queryParameter = (QueryParameter)entry.getKey();
                Object[] queryParameterValues = (Object[])entry.getValue();
                if (!IdentityType.AttributeParameter.class.isInstance(queryParameter) || queryParameterValues == null) continue;
                IdentityType.AttributeParameter customParameter = (IdentityType.AttributeParameter)queryParameter;
                Attribute userAttribute = identityType.getAttribute(customParameter.getName());
                boolean match = false;
                if (userAttribute != null && userAttribute.getValue() != null) {
                    int count = queryParameterValues.length;
                    for (Object value : queryParameterValues) {
                        if (userAttribute.getValue().getClass().isArray()) {
                            Object[] userValues;
                            for (Object object : userValues = (Object[])userAttribute.getValue()) {
                                if (!object.equals(value)) continue;
                                --count;
                            }
                            continue;
                        }
                        if (!value.equals(userAttribute.getValue())) continue;
                        --count;
                    }
                    if (count <= 0) {
                        match = true;
                    }
                }
                if (match) continue;
                identityTypes.remove(identityType);
            }
        }
    }

    private void updateCommonProperties(IdentityType fromIdentityType, IdentityType toIdentityType) {
        toIdentityType.setEnabled(fromIdentityType.isEnabled());
        toIdentityType.setCreatedDate(fromIdentityType.getCreatedDate());
        toIdentityType.setExpirationDate(fromIdentityType.getExpirationDate());
        for (Object object : toIdentityType.getAttributes().toArray()) {
            Attribute attribute = (Attribute)object;
            toIdentityType.removeAttribute(attribute.getName());
        }
        for (Attribute attrib : fromIdentityType.getAttributes()) {
            toIdentityType.setAttribute(attrib);
        }
    }

    private boolean hasGroupRole(GroupRole membership, Group group, Role role) {
        boolean match = false;
        if (role != null && group != null) {
            match = membership.getRole() != null && role.getName().equals(membership.getRole().getName()) && membership.getGroup() != null && group.getName().equals(membership.getGroup().getName());
        } else if (group != null) {
            match = membership.getGroup() != null && group.getName().equals(membership.getGroup().getName());
        } else if (role != null) {
            match = membership.getRole() != null && role.getName().equals(membership.getRole().getName());
        }
        return match;
    }

    private boolean isQueryParameterEquals(Map<QueryParameter, Object[]> parameters, QueryParameter queryParameter, Serializable valueToCompare) {
        Object[] values = parameters.get(queryParameter);
        if (values == null) {
            return true;
        }
        Object value = values[0];
        if (Date.class.isInstance(valueToCompare)) {
            Date parameterDate = (Date)value;
            value = parameterDate.getTime();
            Date toCompareDate = (Date)valueToCompare;
            valueToCompare = Long.valueOf(toCompareDate.getTime());
        }
        return values.length > 0 && valueToCompare != null && valueToCompare.equals(value);
    }

    private boolean isQueryParameterEquals(Map<QueryParameter, Object[]> parameters, QueryParameter queryParameter, Date valueToCompare) {
        Object[] values = parameters.get(queryParameter);
        if (values == null) {
            return true;
        }
        return values.length > 0 && valueToCompare != null && valueToCompare.equals(values[0]);
    }

    private boolean isQueryParameterGreaterThan(Map<QueryParameter, Object[]> parameters, QueryParameter queryParameter, Long valueToCompare) {
        return this.isQueryParameterGreaterOrLessThan(parameters, queryParameter, valueToCompare, true);
    }

    private boolean isQueryParameterLessThan(Map<QueryParameter, Object[]> parameters, QueryParameter queryParameter, Long valueToCompare) {
        return this.isQueryParameterGreaterOrLessThan(parameters, queryParameter, valueToCompare, false);
    }

    private boolean isQueryParameterGreaterOrLessThan(Map<QueryParameter, Object[]> parameters, QueryParameter queryParameter, Long valueToCompare, boolean greaterThan) {
        Object[] values = parameters.get(queryParameter);
        if (values == null) {
            return true;
        }
        long value = 0L;
        if (Date.class.isInstance(values[0])) {
            Date parameterDate = (Date)values[0];
            value = parameterDate.getTime();
        } else {
            value = Long.valueOf(values[0].toString());
        }
        if (values.length > 0 && valueToCompare != null) {
            if (greaterThan && valueToCompare >= value) {
                return true;
            }
            if (!greaterThan && valueToCompare <= value) {
                return true;
            }
        }
        return false;
    }

    public void validateCredentials(Credentials credentials) {
        CredentialHandler handler = this.getContext().getCredentialValidator(credentials.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for validating Credentials of type [" + credentials.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.validate(credentials, (IdentityStore)this);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        CredentialHandler handler = this.getContext().getCredentialUpdater(credential.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for updating Credentials of type [" + credential.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.update(agent, credential, (IdentityStore)this, effectiveDate, expiryDate);
    }

    public void storeCredential(Agent agent, CredentialStorage storage) {
        List<FileCredentialStorage> credentials;
        Map<String, List<FileCredentialStorage>> agentCredentials = this.getConfig().getCredentials().get(agent.getId());
        if (agentCredentials == null) {
            agentCredentials = new HashMap<String, List<FileCredentialStorage>>();
        }
        if ((credentials = agentCredentials.get(storage.getClass().getName())) == null) {
            credentials = new ArrayList<FileCredentialStorage>();
        }
        for (FileCredentialStorage fileCredentialStorage : credentials) {
            if (!this.isCurrentCredential(fileCredentialStorage)) continue;
            fileCredentialStorage.setExpiryDate(new Date());
        }
        List annotatedTypes = PropertyQueries.createQuery(storage.getClass()).addCriteria(new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        FileCredentialStorage credential = new FileCredentialStorage();
        for (Property property : annotatedTypes) {
            credential.getStoredFields().put(property.getName(), (Serializable)property.getValue(storage));
        }
        if (credential.getEffectiveDate() == null) {
            credential.setEffectiveDate(new Date());
        }
        credentials.add(credential);
        agentCredentials.put(storage.getClass().getName(), credentials);
        this.getConfig().getCredentials().put(agent.getId(), agentCredentials);
        this.flushCredentials();
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Agent agent, Class<T> storageClass) {
        List<FileCredentialStorage> credentials;
        Map<String, List<FileCredentialStorage>> agentCredentials = this.getConfig().getCredentials().get(agent.getId());
        if (agentCredentials == null) {
            agentCredentials = new HashMap<String, List<FileCredentialStorage>>();
        }
        if ((credentials = agentCredentials.get(storageClass.getName())) != null) {
            for (FileCredentialStorage fileCredentialStorage : credentials) {
                if (!this.isCurrentCredential(fileCredentialStorage)) continue;
                return (T)((CredentialStorage)this.convertToCredentialStorage(storageClass, fileCredentialStorage));
            }
        }
        return null;
    }

    private boolean isCurrentCredential(FileCredentialStorage fileCredentialStorage) {
        boolean isCurrent = true;
        Date actualDate = new Date();
        if (fileCredentialStorage.getEffectiveDate() != null && fileCredentialStorage.getEffectiveDate().after(actualDate) && fileCredentialStorage.getEffectiveDate().compareTo(actualDate) != 0) {
            isCurrent = false;
        }
        if (fileCredentialStorage.getExpiryDate() != null && fileCredentialStorage.getExpiryDate().before(actualDate) && fileCredentialStorage.getExpiryDate().compareTo(actualDate) != 0) {
            isCurrent = false;
        }
        return isCurrent;
    }

    private <T> T convertToCredentialStorage(Class<T> storageClass, FileCredentialStorage fileCredentialStorage) {
        T storage = null;
        try {
            storage = storageClass.newInstance();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not create CredentialStorage instance for class [" + storageClass.getName() + "].", (Throwable)e);
        }
        Set<Map.Entry<String, Serializable>> storedFieldsEntrySet = fileCredentialStorage.getStoredFields().entrySet();
        for (Map.Entry<String, Serializable> storedFieldEntry : storedFieldsEntrySet) {
            List annotatedTypes = PropertyQueries.createQuery(storageClass).addCriteria(new NamedPropertyCriteria(storedFieldEntry.getKey())).getResultList();
            if (annotatedTypes.isEmpty()) {
                throw new IdentityManagementException("Could not find property [" + storedFieldEntry.getKey() + "] on CredentialStorage [" + storageClass.getName() + "].");
            }
            if (annotatedTypes.size() > 1) {
                throw new IdentityManagementException("Ambiguos property [" + storedFieldEntry.getKey() + "] on CredentialStorage [" + storageClass.getName() + "].");
            }
            Property<Serializable> property = annotatedTypes.get(0);
            property.setValue(storage, storedFieldEntry.getValue());
        }
        return storage;
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Agent agent, Class<T> storageClass) {
        List<FileCredentialStorage> credentials;
        ArrayList<T> storedCredentials = new ArrayList<T>();
        Map<String, List<FileCredentialStorage>> agentCredentials = this.getConfig().getCredentials().get(agent.getId());
        if (agentCredentials == null) {
            agentCredentials = new HashMap<String, List<FileCredentialStorage>>();
        }
        if ((credentials = agentCredentials.get(storageClass.getName())) != null) {
            for (FileCredentialStorage fileCredentialStorage : credentials) {
                storedCredentials.add(this.convertToCredentialStorage(storageClass, fileCredentialStorage));
            }
        }
        return storedCredentials;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        throw this.createNotImplementedYetException();
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        throw this.createNotImplementedYetException();
    }

    public void setAttribute(IdentityType identityType, Attribute<? extends Serializable> attribute) {
        throw this.createNotImplementedYetException();
    }

    public void removeAttribute(IdentityType identityType, String attributeName) {
        throw this.createNotImplementedYetException();
    }

    private IdentityManagementException createNotImplementedYetException() {
        return new IdentityManagementException("Not implemented yet.");
    }

    synchronized void flushUsers() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getConfig().getUsersFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getConfig().getUsers());
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    synchronized void flushRoles() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getConfig().getRolesFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getConfig().getRoles());
            oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void flushGroups() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getConfig().getGroupsFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getConfig().getGroups());
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    synchronized void flushMemberships() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getConfig().getMembershipsFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getConfig().getMemberships());
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    synchronized void flushCredentials() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getConfig().getCredentialsFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getConfig().getCredentials());
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

