/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.util.Date;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Digest;
import org.picketlink.idm.credential.DigestCredentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;

@SupportsCredentials(value={DigestCredentials.class, Digest.class})
public class DigestCredentialHandler
implements CredentialHandler {
    public void validate(Credentials credentials, IdentityStore<?> identityStore) {
        if (!CredentialStore.class.isInstance(identityStore)) {
            throw new IdentityManagementException("Provided IdentityStore [" + identityStore + "] is not an instance of CredentialStore.");
        }
        DigestCredentials digestCredential = (DigestCredentials)credentials;
        Agent agent = identityStore.getAgent(digestCredential.getDigest().getUsername());
        CredentialStore credentialStore = (CredentialStore)identityStore;
        digestCredential.setStatus(Credentials.Status.VALID);
    }

    public void update(Agent agent, Object credential, IdentityStore<?> store, Date effectiveDate, Date expiryDate) {
    }
}

