/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;

public class RelationshipMetadata {
    private Map<Class<? extends Relationship>, Set<Property<? extends IdentityType>>> relationshipIdentityProperties = new ConcurrentHashMap<Class<? extends Relationship>, Set<Property<? extends IdentityType>>>();

    public Set<Partition> getRelationshipPartitions(Relationship relationship) {
        HashSet<Partition> partitions = new HashSet<Partition>();
        for (Property<? extends IdentityType> prop : this.getRelationshipIdentityProperties(relationship.getClass())) {
            IdentityType identity = (IdentityType)prop.getValue((Object)relationship);
            if (partitions.contains(identity.getPartition())) continue;
            partitions.add(identity.getPartition());
        }
        return partitions;
    }

    public Set<Property<? extends IdentityType>> getRelationshipIdentityProperties(Class<? extends Relationship> relationshipClass) {
        if (!this.relationshipIdentityProperties.containsKey(relationshipClass)) {
            ((ConcurrentHashMap)this.relationshipIdentityProperties).putIfAbsent(relationshipClass, this.queryRelationshipIdentityProperties(relationshipClass));
        }
        return this.relationshipIdentityProperties.get(relationshipClass);
    }

    private Set<Property<? extends IdentityType>> queryRelationshipIdentityProperties(Class<? extends Relationship> relationshipClass) {
        PropertyQuery query = PropertyQueries.createQuery(relationshipClass);
        query.addCriteria((PropertyCriteria)new TypedPropertyCriteria(IdentityType.class, TypedPropertyCriteria.MatchOption.SUB_TYPE));
        HashSet<Property> properties = new HashSet<Property>();
        for (Property prop : query.getResultList()) {
            properties.add(prop);
        }
        return Collections.unmodifiableSet(properties);
    }
}

