/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.InheritsPrivileges;
import org.picketlink.idm.query.RelationshipQuery;

public class PrivilegeChainQuery {
    private final Map<Class<? extends Relationship>, Map<Property<IdentityType>, Property<IdentityType>>> privilegeChains = new HashMap<Class<? extends Relationship>, Map<Property<IdentityType>, Property<IdentityType>>>();

    public void registerRelationshipType(Class<? extends Relationship> relationshipType) {
        if (!this.privilegeChains.containsKey(relationshipType)) {
            List properties = PropertyQueries.createQuery(relationshipType).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(InheritsPrivileges.class)).addCriteria((PropertyCriteria)new TypedPropertyCriteria(IdentityType.class, TypedPropertyCriteria.MatchOption.ALL)).getResultList();
            HashMap<Property, Property> inheritanceMapping = new HashMap<Property, Property>();
            for (Property p : properties) {
                InheritsPrivileges annotation = p.getAnnotatedElement().getAnnotation(InheritsPrivileges.class);
                String assigneeName = annotation.value();
                if (StringUtil.isNullOrEmpty((String)assigneeName)) {
                    throw new IllegalArgumentException(String.format("Specified relationshipType [%s] does not declare valid @InheritsPrivilege annotation on property [%s] - missing assignee property name", relationshipType.getName(), p.getName()));
                }
                Property assignee = PropertyQueries.createQuery(relationshipType).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{assigneeName})).getSingleResult();
                inheritanceMapping.put(p, assignee);
            }
            this.privilegeChains.put(relationshipType, inheritanceMapping);
        }
    }

    public boolean inheritsPrivileges(RelationshipManager relationshipManager, IdentityType identity, IdentityType assignee) {
        IdentityType parentIdentity;
        if (identity == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("identity");
        }
        if (assignee == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("assignee");
        }
        RelationshipQuery query = relationshipManager.createRelationshipQuery(Relationship.class);
        query.setParameter(Relationship.IDENTITY, new Object[]{identity});
        boolean hasPrivileges = false;
        for (Relationship relationship : new ArrayList(query.getResultList())) {
            Map<Property<IdentityType>, Property<IdentityType>> propertyPropertyMap = this.privilegeChains.get(relationship.getClass());
            if (propertyPropertyMap == null) continue;
            for (Property<IdentityType> identityProperty : propertyPropertyMap.keySet()) {
                Property<IdentityType> assigneeProperty = propertyPropertyMap.get(identityProperty);
                if (!assigneeProperty.getDeclaringClass().equals(relationship.getClass())) continue;
                IdentityType relationshipAssignee = (IdentityType)assigneeProperty.getValue((Object)relationship);
                if (relationshipAssignee.equals(assignee)) {
                    hasPrivileges = true;
                } else if (!identity.equals(relationshipAssignee)) {
                    hasPrivileges = this.inheritsPrivileges(relationshipManager, relationshipAssignee, assignee);
                }
                if (!hasPrivileges) continue;
                return true;
            }
        }
        Property parentProperty = PropertyQueries.createQuery(identity.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(identity.getClass(), TypedPropertyCriteria.MatchOption.SUB_TYPE)).getFirstResult();
        if (parentProperty != null && (parentIdentity = (IdentityType)parentProperty.getValue((Object)identity)) != null) {
            return this.inheritsPrivileges(relationshipManager, parentIdentity, assignee);
        }
        return false;
    }
}

